/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import com.gargoylesoftware.htmlunit.AlertHandler;
import com.gargoylesoftware.htmlunit.Page;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.openqa.selenium.Alert;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.security.Credentials;

class HtmlUnitAlert
implements Alert,
AlertHandler {
    private HtmlUnitDriver driver;
    private Map<Page, Queue<String>> queues = new HashMap<Page, Queue<String>>();

    HtmlUnitAlert(HtmlUnitDriver driver) {
        this.driver = driver;
        driver.getWebClient().setAlertHandler((AlertHandler)this);
    }

    public void dismiss() {
        this.accept();
    }

    public void accept() {
        Queue<String> queue = this.getCurrentQueue();
        if (queue == null || queue.poll() == null) {
            throw new NoAlertPresentException();
        }
    }

    public String getText() {
        String text;
        Queue<String> queue = this.getCurrentQueue();
        if (queue != null && (text = queue.peek()) != null) {
            return text;
        }
        throw new NoAlertPresentException();
    }

    public void sendKeys(String keysToSend) {
        throw new ElementNotVisibleException("alert is not visible");
    }

    public void authenticateUsing(Credentials credentials) {
    }

    public void setCredentials(Credentials credentials) {
    }

    public void handleAlert(Page page, String message) {
        Queue<String> queue = this.queues.get(page);
        if (queue == null) {
            queue = new LinkedList<String>();
            this.queues.put(page, queue);
        }
        queue.add(message);
    }

    Queue<String> getCurrentQueue() {
        return this.queues.get(this.driver.getCurrentWindow().getEnclosedPage());
    }

    void close() {
        this.queues.remove(this.driver.getCurrentWindow().getEnclosedPage());
    }
}

