/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.parboiled.common.Preconditions;
import org.parboiled.transform.AsmUtils;
import org.parboiled.transform.InstructionGraphNode;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.RuleMethodProcessor;
import org.parboiled.transform.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImplicitActionsConverter
implements RuleMethodProcessor {
    private final Set<InstructionGraphNode> covered = new HashSet<InstructionGraphNode>();
    private RuleMethod method;

    ImplicitActionsConverter() {
    }

    @Override
    public boolean appliesTo(ParserClassNode classNode, RuleMethod method) {
        Preconditions.checkArgNotNull((Object)((Object)classNode), (String)"classNode");
        Preconditions.checkArgNotNull((Object)((Object)method), (String)"method");
        return method.containsImplicitActions();
    }

    @Override
    public void process(ParserClassNode classNode, RuleMethod method) throws Exception {
        this.method = (RuleMethod)((Object)Preconditions.checkArgNotNull((Object)((Object)method), (String)"method"));
        this.covered.clear();
        this.walkNode(method.getReturnInstructionNode());
        method.setContainsImplicitActions(false);
    }

    private void walkNode(InstructionGraphNode node) {
        if (this.covered.contains(node)) {
            return;
        }
        this.covered.add(node);
        if (this.isImplicitAction(node)) {
            this.replaceWithActionWrapper(node);
            this.method.setContainsExplicitActions(true);
            return;
        }
        if (!node.isActionRoot()) {
            for (InstructionGraphNode predecessor : node.getPredecessors()) {
                this.walkNode(predecessor);
            }
        }
    }

    private void replaceWithActionWrapper(InstructionGraphNode node) {
        MethodInsnNode insn = this.createActionWrappingInsn();
        this.method.instructions.set(node.getInstruction(), (AbstractInsnNode)insn);
        node.setIsActionRoot();
        node.setInstruction((AbstractInsnNode)insn);
    }

    private boolean isImplicitAction(InstructionGraphNode node) {
        if (!AsmUtils.isBooleanValueOfZ(node.getInstruction())) {
            return false;
        }
        List<InstructionGraphNode> dependents = this.getDependents(node);
        if (dependents.size() != 1) {
            return false;
        }
        InstructionGraphNode dependent = dependents.get(0);
        return this.isObjectArgumentToRuleCreatingMethodCall(node, dependent) || this.isStoredIntoObjectArray(dependent);
    }

    private boolean isObjectArgumentToRuleCreatingMethodCall(InstructionGraphNode node, InstructionGraphNode dependent) {
        AbstractInsnNode insn = dependent.getInstruction();
        if (insn.getType() != 5) {
            return false;
        }
        MethodInsnNode mi = (MethodInsnNode)insn;
        if (!Types.RULE.equals((Object)Type.getReturnType((String)mi.desc))) {
            return false;
        }
        Type[] argTypes = Type.getArgumentTypes((String)mi.desc);
        int argIndex = this.getArgumentIndex(dependent, node);
        Preconditions.checkState((argIndex < argTypes.length ? 1 : 0) != 0);
        return "java/lang/Object".equals(argTypes[argIndex].getInternalName());
    }

    private boolean isStoredIntoObjectArray(InstructionGraphNode dependent) {
        AbstractInsnNode insn = dependent.getInstruction();
        if (insn.getOpcode() != 83) {
            return false;
        }
        List<InstructionGraphNode> dependents = this.getDependents(dependent);
        Preconditions.checkState((dependents.size() == 1 ? 1 : 0) != 0);
        AbstractInsnNode newArrayInsn = dependents.get(0).getInstruction();
        Preconditions.checkState((newArrayInsn.getOpcode() == 189 ? 1 : 0) != 0);
        return "java/lang/Object".equals(((TypeInsnNode)newArrayInsn).desc);
    }

    private int getArgumentIndex(InstructionGraphNode callNode, InstructionGraphNode predecessor) {
        int startIndex;
        for (int i = startIndex = callNode.getInstruction().getOpcode() == 184 ? 0 : 1; i < callNode.getPredecessors().size(); ++i) {
            InstructionGraphNode argumentNode = callNode.getPredecessors().get(i);
            if (!predecessor.equals(argumentNode)) continue;
            return i - startIndex;
        }
        throw new IllegalStateException();
    }

    private List<InstructionGraphNode> getDependents(InstructionGraphNode predecessor) {
        ArrayList<InstructionGraphNode> dependents = new ArrayList<InstructionGraphNode>();
        for (InstructionGraphNode node : this.method.getGraphNodes()) {
            if (!node.getPredecessors().contains(predecessor)) continue;
            dependents.add(node);
        }
        return dependents;
    }

    private MethodInsnNode createActionWrappingInsn() {
        return new MethodInsnNode(184, Types.BASE_PARSER.getInternalName(), "ACTION", "(Z)" + Types.ACTION_DESC);
    }
}

