/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.helpers;

import org.openrdf.model.Statement;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;

public class RDFHandlerWrapper
implements RDFHandler {
    private final RDFHandler[] rdfHandlers;

    public RDFHandlerWrapper(RDFHandler ... rdfHandlers) {
        assert (rdfHandlers != null);
        this.rdfHandlers = rdfHandlers;
    }

    public void startRDF() throws RDFHandlerException {
        for (RDFHandler rdfHandler : this.rdfHandlers) {
            rdfHandler.startRDF();
        }
    }

    public void endRDF() throws RDFHandlerException {
        for (RDFHandler rdfHandler : this.rdfHandlers) {
            rdfHandler.endRDF();
        }
    }

    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        for (RDFHandler rdfHandler : this.rdfHandlers) {
            rdfHandler.handleNamespace(prefix, uri);
        }
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        for (RDFHandler rdfHandler : this.rdfHandlers) {
            rdfHandler.handleStatement(st);
        }
    }

    public void handleComment(String comment) throws RDFHandlerException {
        for (RDFHandler rdfHandler : this.rdfHandlers) {
            rdfHandler.handleComment(comment);
        }
    }
}

