/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.iterator;

import info.aduna.iteration.FilterIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import java.util.HashSet;
import java.util.Set;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryResults;

public class SPARQLMinusIteration<X extends Exception>
extends FilterIteration<BindingSet, X> {
    private final Iteration<BindingSet, X> rightArg;
    private final boolean distinct;
    private boolean initialized;
    private Set<BindingSet> excludeSet;

    public SPARQLMinusIteration(Iteration<BindingSet, X> leftArg, Iteration<BindingSet, X> rightArg) {
        this(leftArg, rightArg, false);
    }

    public SPARQLMinusIteration(Iteration<BindingSet, X> leftArg, Iteration<BindingSet, X> rightArg, boolean distinct) {
        super(leftArg);
        assert (rightArg != null);
        this.rightArg = rightArg;
        this.distinct = distinct;
        this.initialized = false;
    }

    protected boolean accept(BindingSet object) throws X {
        if (!this.initialized) {
            this.excludeSet = (Set)Iterations.addAll(this.rightArg, new HashSet());
            this.initialized = true;
        }
        boolean compatible = false;
        for (BindingSet excluded : this.excludeSet) {
            HashSet sharedBindingNames = new HashSet(excluded.getBindingNames());
            sharedBindingNames.retainAll(object.getBindingNames());
            if (sharedBindingNames.isEmpty() || !QueryResults.bindingSetsCompatible((BindingSet)excluded, (BindingSet)object)) continue;
            compatible = true;
            break;
        }
        return !compatible;
    }

    protected void handleClose() throws X {
        super.handleClose();
        Iterations.closeCloseable(this.rightArg);
    }
}

