/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model.impl;

import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.vocabulary.XMLSchema;

public abstract class ValueFactoryBase
implements ValueFactory {
    private static long lastBNodePrefixUID = 0L;
    private int nextBNodeID;
    private String bnodePrefix;

    private static synchronized long getNextBNodePrefixUid() {
        lastBNodePrefixUID = Math.max(System.currentTimeMillis(), lastBNodePrefixUID + 1L);
        return lastBNodePrefixUID;
    }

    public ValueFactoryBase() {
        this.initBNodeParams();
    }

    protected void initBNodeParams() {
        this.bnodePrefix = "node" + Long.toString(ValueFactoryBase.getNextBNodePrefixUid(), 32) + "x";
        this.nextBNodeID = 1;
    }

    public synchronized BNode createBNode() {
        int id = this.nextBNodeID++;
        BNode result = this.createBNode(this.bnodePrefix + id);
        if (id == Integer.MAX_VALUE) {
            this.initBNodeParams();
        }
        return result;
    }

    public Literal createLiteral(boolean b) {
        return this.createLiteral(Boolean.toString(b), XMLSchema.BOOLEAN);
    }

    public Literal createLiteral(byte value) {
        return this.createIntegerLiteral(value, XMLSchema.BYTE);
    }

    public Literal createLiteral(short value) {
        return this.createIntegerLiteral(value, XMLSchema.SHORT);
    }

    public Literal createLiteral(int value) {
        return this.createIntegerLiteral(value, XMLSchema.INT);
    }

    public Literal createLiteral(long value) {
        return this.createIntegerLiteral(value, XMLSchema.LONG);
    }

    protected Literal createIntegerLiteral(Number value, URI datatype) {
        return this.createNumericLiteral(value, datatype);
    }

    public Literal createLiteral(float value) {
        return this.createFPLiteral(Float.valueOf(value), XMLSchema.FLOAT);
    }

    public Literal createLiteral(double value) {
        return this.createFPLiteral(value, XMLSchema.DOUBLE);
    }

    protected Literal createFPLiteral(Number value, URI datatype) {
        return this.createNumericLiteral(value, datatype);
    }

    protected Literal createNumericLiteral(Number number, URI datatype) {
        return this.createLiteral(number.toString(), datatype);
    }

    public Literal createLiteral(XMLGregorianCalendar calendar) {
        return this.createLiteral(calendar.toXMLFormat(), XMLDatatypeUtil.qnameToURI(calendar.getXMLSchemaType()));
    }

    public Literal createLiteral(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        try {
            XMLGregorianCalendar xmlGregCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(c);
            return this.createLiteral(xmlGregCalendar);
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException("Could not instantiate javax.xml.datatype.DatatypeFactory", e);
        }
    }

    public Literal createLiteral(Object object) {
        if (object instanceof Boolean) {
            return this.createLiteral((Boolean)object);
        }
        if (object instanceof Byte) {
            return this.createLiteral((Byte)object);
        }
        if (object instanceof Double) {
            return this.createLiteral((Double)object);
        }
        if (object instanceof Float) {
            return this.createLiteral(((Float)object).floatValue());
        }
        if (object instanceof Integer) {
            return this.createLiteral((Integer)object);
        }
        if (object instanceof Long) {
            return this.createLiteral((Long)object);
        }
        if (object instanceof Short) {
            return this.createLiteral((Short)object);
        }
        if (object instanceof XMLGregorianCalendar) {
            return this.createLiteral((XMLGregorianCalendar)object);
        }
        if (object instanceof Date) {
            return this.createLiteral((Date)object);
        }
        return this.createLiteral(object.toString(), XMLSchema.STRING);
    }
}

