/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugin.spring.boot;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.TimeZone;
import org.nutz.integration.spring.NutzJsonMessageConverter;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.Strings;
import org.nutz.plugin.spring.boot.config.NutzJsonProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;

@Configuration
@ConditionalOnClass(value={Json.class})
@EnableConfigurationProperties(value={NutzJsonProperties.class})
public class NutzJsonMessageConverterAutoConfiguration {
    @Autowired
    private NutzJsonProperties jsonProperties;

    @Bean
    @ConditionalOnExpression(value="${nutz.json.enabled:false}")
    public HttpMessageConverter json() {
        JsonFormat format = JsonFormat.compact();
        if (this.jsonProperties.getMode() != null) {
            switch (this.jsonProperties.getMode()) {
                case COMPACT: {
                    format = JsonFormat.compact();
                    break;
                }
                case FORLOOK: {
                    format = JsonFormat.forLook();
                    break;
                }
                case FULL: {
                    format = JsonFormat.full();
                    break;
                }
                case NICE: {
                    format = JsonFormat.nice();
                    break;
                }
                case TIDY: {
                    format = JsonFormat.tidy();
                    break;
                }
                default: {
                    format = JsonFormat.compact();
                    break;
                }
            }
        } else {
            format = (JsonFormat)Json.fromJson(JsonFormat.class, (CharSequence)Json.toJson((Object)this.jsonProperties));
        }
        if (Strings.isNotBlank((CharSequence)this.jsonProperties.getActived())) {
            format.setActived(this.jsonProperties.getActived());
        }
        if (Strings.isNotBlank((CharSequence)this.jsonProperties.getLocked())) {
            format.setLocked(this.jsonProperties.getLocked());
        }
        if (Strings.isNotBlank((CharSequence)this.jsonProperties.getDateFormat())) {
            format.setDateFormat(this.jsonProperties.getDateFormat());
        }
        if (Strings.isNotBlank((CharSequence)this.jsonProperties.getNumberFormat())) {
            format.setNumberFormat((NumberFormat)new DecimalFormat(this.jsonProperties.getNumberFormat()));
        }
        if (Strings.isNotBlank((CharSequence)this.jsonProperties.getTimeZone())) {
            format.setTimeZone(TimeZone.getTimeZone(this.jsonProperties.getTimeZone()));
        }
        NutzJsonMessageConverter c = new NutzJsonMessageConverter().setFormat(format).setIgnoreType(this.jsonProperties.getIgnoreType());
        return c;
    }
}

