/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugin.spring.boot;

import javax.sql.DataSource;
import org.nutz.dao.Dao;
import org.nutz.dao.SqlManager;
import org.nutz.dao.impl.DaoRunner;
import org.nutz.dao.impl.NutDao;
import org.nutz.integration.spring.SpringDaoRunner;
import org.nutz.plugin.spring.boot.SqlManagerAutoConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Dao.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, SqlManagerAutoConfiguration.class})
public class NutzDaoAutoConfiguration {
    @Autowired
    DataSource dataSource;
    @Autowired
    DaoRunner daoRunner;

    @Bean
    public Dao dao(SqlManager sqlManager) {
        NutDao dao = new NutDao(this.dataSource, sqlManager);
        dao.setRunner((DaoRunner)new SpringDaoRunner());
        return dao;
    }

    @Bean
    @ConditionalOnMissingBean(value={DaoRunner.class})
    public DaoRunner daoRunner() {
        return new SpringDaoRunner();
    }
}

