/*
 * Decompiled with CFR 0.152.
 */
package ninja.servlet;

import com.google.inject.Injector;
import com.google.inject.servlet.GuiceServletContextListener;
import javax.servlet.ServletContextEvent;
import ninja.Bootstrap;
import ninja.servlet.NinjaServletBootstrap;
import ninja.utils.NinjaModeHelper;
import ninja.utils.NinjaPropertiesImpl;

public class NinjaServletListener
extends GuiceServletContextListener {
    private volatile Bootstrap ninjaBootstrap;
    NinjaPropertiesImpl ninjaProperties = null;
    String contextPath;

    public synchronized void setNinjaProperties(NinjaPropertiesImpl ninjaPropertiesImpl) {
        if (this.ninjaProperties != null) {
            throw new IllegalStateException("NinjaProperties already set.");
        }
        this.ninjaProperties = ninjaPropertiesImpl;
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        this.contextPath = servletContextEvent.getServletContext().getContextPath();
        super.contextInitialized(servletContextEvent);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        this.ninjaBootstrap.shutdown();
        super.contextDestroyed(servletContextEvent);
    }

    public Bootstrap getNinjaBootstrap() {
        return this.ninjaBootstrap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Injector getInjector() {
        Bootstrap ninjaBootstrapLocal = this.ninjaBootstrap;
        if (ninjaBootstrapLocal == null) {
            NinjaServletListener ninjaServletListener = this;
            synchronized (ninjaServletListener) {
                ninjaBootstrapLocal = this.ninjaBootstrap;
                if (ninjaBootstrapLocal == null) {
                    if (this.ninjaProperties == null) {
                        this.ninjaProperties = new NinjaPropertiesImpl(NinjaModeHelper.determineModeFromSystemPropertiesOrProdIfNotSet());
                    }
                    ninjaBootstrapLocal = this.ninjaBootstrap = this.createNinjaBootstrap(this.ninjaProperties, this.contextPath);
                }
            }
        }
        return ninjaBootstrapLocal.getInjector();
    }

    private Bootstrap createNinjaBootstrap(NinjaPropertiesImpl ninjaProperties, String contextPath) {
        ninjaProperties.setContextPath(contextPath);
        this.ninjaBootstrap = new NinjaServletBootstrap(ninjaProperties);
        this.ninjaBootstrap.boot();
        return this.ninjaBootstrap;
    }
}

