/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.Iterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.junit.jupiter.api.DynamicNode;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.function.ThrowingConsumer;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.Preconditions;

@API(value=API.Usage.Experimental)
public class DynamicTest
extends DynamicNode {
    private final Executable executable;

    public static DynamicTest dynamicTest(String displayName, Executable executable) {
        return new DynamicTest(displayName, executable);
    }

    public static <T> Stream<DynamicTest> stream(Iterator<T> inputGenerator, Function<? super T, String> displayNameGenerator, ThrowingConsumer<? super T> testExecutor) {
        Preconditions.notNull(inputGenerator, (String)"inputGenerator must not be null");
        Preconditions.notNull(displayNameGenerator, (String)"displayNameGenerator must not be null");
        Preconditions.notNull(testExecutor, (String)"testExecutor must not be null");
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(inputGenerator, 16), false).map(input -> DynamicTest.dynamicTest((String)displayNameGenerator.apply(input), () -> testExecutor.accept(input)));
    }

    private DynamicTest(String displayName, Executable executable) {
        super(displayName);
        this.executable = (Executable)Preconditions.notNull((Object)executable, (String)"executable must not be null");
    }

    public Executable getExecutable() {
        return this.executable;
    }
}

