/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.dispatch;

import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaConstructor;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.ParameterTypes;
import org.jruby.javasupport.proxy.JavaProxyConstructor;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;

public class CallableSelector {
    private static final boolean DEBUG = true;
    private static final CallableAcceptor Exact = new CallableAcceptor(){

        @Override
        public boolean accept(ParameterTypes types, IRubyObject[] args2) {
            return CallableSelector.exactMatch(types, args2);
        }
    };
    private static final CallableAcceptor AssignableAndPrimitivable = new CallableAcceptor(){

        @Override
        public boolean accept(ParameterTypes types, IRubyObject[] args2) {
            return CallableSelector.assignableAndPrimitivable(types, args2);
        }
    };
    private static final CallableAcceptor AssignableOrDuckable = new CallableAcceptor(){

        @Override
        public boolean accept(ParameterTypes types, IRubyObject[] args2) {
            return CallableSelector.assignableOrDuckable(types, args2);
        }
    };
    private static final CallableAcceptor AssignableAndPrimitivableWithVarargs = new CallableAcceptor(){

        @Override
        public boolean accept(ParameterTypes types, IRubyObject[] args2) {
            return CallableSelector.assignableAndPrimitivableWithVarargs(types, args2);
        }
    };
    private static Matcher EXACT = new Matcher(){

        @Override
        public boolean match(Class type2, IRubyObject arg2) {
            return type2.equals(CallableSelector.argClass(arg2)) || type2.isPrimitive() && CodegenUtils.getBoxType(type2) == CallableSelector.argClass(arg2);
        }
    };
    private static Matcher ASSIGNABLE = new Matcher(){

        @Override
        public boolean match(Class type2, IRubyObject arg2) {
            return CallableSelector.assignable(type2, arg2);
        }
    };
    private static Matcher PRIMITIVABLE = new Matcher(){

        @Override
        public boolean match(Class type2, IRubyObject arg2) {
            return CallableSelector.primitivable(type2, arg2);
        }
    };
    private static Matcher DUCKABLE = new Matcher(){

        @Override
        public boolean match(Class type2, IRubyObject arg2) {
            return CallableSelector.duckable(type2, arg2);
        }
    };
    private static final Matcher[] MATCH_SEQUENCE = new Matcher[]{EXACT, PRIMITIVABLE, ASSIGNABLE, DUCKABLE};

    public static ParameterTypes matchingCallableArityN(Ruby runtime, Map cache, ParameterTypes[] methods2, IRubyObject[] args2, int argsLength) {
        int signatureCode = CallableSelector.argsHashCode(args2);
        ParameterTypes method2 = (ParameterTypes)cache.get(signatureCode);
        if (method2 == null) {
            method2 = CallableSelector.findMatchingCallableForArgs(runtime, cache, signatureCode, methods2, args2);
        }
        return method2;
    }

    public static JavaCallable matchingCallableArityN(Ruby runtime, Map cache, JavaCallable[] methods2, IRubyObject[] args2, int argsLength) {
        int signatureCode = CallableSelector.argsHashCode(args2);
        JavaCallable method2 = (JavaCallable)cache.get(signatureCode);
        if (method2 == null) {
            method2 = (JavaCallable)CallableSelector.findMatchingCallableForArgs(runtime, cache, signatureCode, methods2, args2);
        }
        return method2;
    }

    public static JavaCallable matchingCallableArityOne(Ruby runtime, Map cache, JavaCallable[] methods2, IRubyObject arg0) {
        int signatureCode = CallableSelector.argsHashCode(arg0);
        JavaCallable method2 = (JavaCallable)cache.get(signatureCode);
        if (method2 == null) {
            method2 = (JavaCallable)CallableSelector.findMatchingCallableForArgs(runtime, cache, signatureCode, methods2, arg0);
        }
        return method2;
    }

    public static JavaCallable matchingCallableArityTwo(Ruby runtime, Map cache, JavaCallable[] methods2, IRubyObject arg0, IRubyObject arg1) {
        int signatureCode = CallableSelector.argsHashCode(arg0, arg1);
        JavaCallable method2 = (JavaCallable)cache.get(signatureCode);
        if (method2 == null) {
            method2 = (JavaCallable)CallableSelector.findMatchingCallableForArgs(runtime, cache, signatureCode, methods2, arg0, arg1);
        }
        return method2;
    }

    public static JavaCallable matchingCallableArityThree(Ruby runtime, Map cache, JavaCallable[] methods2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        int signatureCode = CallableSelector.argsHashCode(arg0, arg1, arg2);
        JavaCallable method2 = (JavaCallable)cache.get(signatureCode);
        if (method2 == null) {
            method2 = (JavaCallable)CallableSelector.findMatchingCallableForArgs(runtime, cache, signatureCode, methods2, arg0, arg1, arg2);
        }
        return method2;
    }

    public static JavaCallable matchingCallableArityFour(Ruby runtime, Map cache, JavaCallable[] methods2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        int signatureCode = CallableSelector.argsHashCode(arg0, arg1, arg2, arg3);
        JavaCallable method2 = (JavaCallable)cache.get(signatureCode);
        if (method2 == null) {
            method2 = (JavaCallable)CallableSelector.findMatchingCallableForArgs(runtime, cache, signatureCode, methods2, arg0, arg1, arg2, arg3);
        }
        return method2;
    }

    private static ParameterTypes findMatchingCallableForArgs(Ruby runtime, Map cache, int signatureCode, ParameterTypes[] methods2, IRubyObject ... args2) {
        ParameterTypes method2 = null;
        List<ParameterTypes> newFinds = CallableSelector.findCallable(methods2, args2);
        if (newFinds.size() > 0) {
            if (newFinds.size() == 1) {
                method2 = newFinds.get(0);
            } else {
                ParameterTypes mostSpecific = null;
                Class[] msTypes = null;
                boolean ambiguous = false;
                block0: for (ParameterTypes candidate : newFinds) {
                    int i2;
                    if (mostSpecific == null) {
                        mostSpecific = candidate;
                        msTypes = mostSpecific.getParameterTypes();
                        continue;
                    }
                    Class<?>[] cTypes = candidate.getParameterTypes();
                    for (i2 = 0; i2 < msTypes.length; ++i2) {
                        if (msTypes[i2] == cTypes[i2] || !msTypes[i2].isAssignableFrom(cTypes[i2])) continue;
                        mostSpecific = candidate;
                        msTypes = cTypes;
                        ambiguous = false;
                        continue block0;
                    }
                    for (i2 = 0; i2 < msTypes.length; ++i2) {
                        if (msTypes[i2] == cTypes[i2] || msTypes[i2].isAssignableFrom(cTypes[i2]) || cTypes[i2].isAssignableFrom(msTypes[i2])) {
                            ambiguous = false;
                            continue block0;
                        }
                        ambiguous = true;
                    }
                }
                method2 = mostSpecific;
                if (ambiguous) {
                    runtime.getWarnings().warn("ambiguous Java methods found, using " + ((Member)((Object)((JavaCallable)method2).accessibleObject())).getName() + CodegenUtils.prettyParams(msTypes));
                }
            }
        }
        if (method2 == null) {
            method2 = CallableSelector.findCallable(methods2, Exact, args2);
        }
        if (method2 == null) {
            method2 = CallableSelector.findCallable(methods2, AssignableAndPrimitivable, args2);
        }
        if (method2 == null) {
            method2 = CallableSelector.findCallable(methods2, AssignableOrDuckable, args2);
        }
        if (method2 == null) {
            method2 = CallableSelector.findCallable(methods2, AssignableAndPrimitivableWithVarargs, args2);
        }
        if (method2 != null) {
            cache.put(signatureCode, method2);
        }
        return method2;
    }

    private static void warnMultipleMatches(IRubyObject[] args2, List<ParameterTypes> newFinds) {
        RubyClass[] argTypes = new RubyClass[args2.length];
        for (int i2 = 0; i2 < argTypes.length; ++i2) {
            argTypes[i2] = args2[i2].getMetaClass();
        }
        StringBuilder builder = new StringBuilder("multiple Java methods for arguments (");
        boolean first2 = true;
        for (RubyClass argType : argTypes) {
            if (!first2) {
                builder.append(",");
            }
            first2 = false;
            builder.append(argType);
        }
        builder.append("), using first:");
        for (ParameterTypes types : newFinds) {
            builder.append("\n  ").append(types);
        }
        args2[0].getRuntime().getWarnings().warn(builder.toString());
    }

    private static ParameterTypes findCallable(ParameterTypes[] callables, CallableAcceptor acceptor, IRubyObject ... args2) {
        ParameterTypes bestCallable = null;
        int bestScore = -1;
        for (int k = 0; k < callables.length; ++k) {
            int currentScore;
            ParameterTypes callable = callables[k];
            if (!acceptor.accept(callable, args2) || (currentScore = CallableSelector.getExactnessScore(callable, args2)) <= bestScore) continue;
            bestCallable = callable;
            bestScore = currentScore;
        }
        return bestCallable;
    }

    private static List<ParameterTypes> findCallable(ParameterTypes[] callables, IRubyObject ... args2) {
        ArrayList<ParameterTypes> retainedCallables = new ArrayList<ParameterTypes>(callables.length);
        ArrayList<ParameterTypes> incomingCallables = new ArrayList<ParameterTypes>(Arrays.asList(callables));
        for (int currentArg = 0; currentArg < args2.length; ++currentArg) {
            retainedCallables.clear();
            for (Matcher matcher : MATCH_SEQUENCE) {
                Iterator callableIter = incomingCallables.iterator();
                while (callableIter.hasNext()) {
                    ParameterTypes callable = (ParameterTypes)callableIter.next();
                    Class<?>[] types = callable.getParameterTypes();
                    if (!matcher.match(types[currentArg], args2[currentArg])) continue;
                    callableIter.remove();
                    retainedCallables.add(callable);
                }
            }
            incomingCallables.clear();
            incomingCallables.addAll(retainedCallables);
        }
        return retainedCallables;
    }

    private static int getExactnessScore(ParameterTypes paramTypes, IRubyObject[] args2) {
        Class<?>[] types = paramTypes.getParameterTypes();
        int count2 = 0;
        if (paramTypes.isVarArgs()) {
            int nonVarargs = types.length - 1;
            ++count2;
            for (int i2 = 0; i2 < nonVarargs && i2 < args2.length; ++i2) {
                if (!types[i2].equals(CallableSelector.argClass(args2[i2]))) continue;
                ++count2;
            }
        } else {
            for (int i3 = 0; i3 < args2.length; ++i3) {
                if (!types[i3].equals(CallableSelector.argClass(args2[i3]))) continue;
                ++count2;
            }
        }
        return count2;
    }

    private static boolean exactMatch(ParameterTypes paramTypes, IRubyObject ... args2) {
        Class<?>[] types = paramTypes.getParameterTypes();
        if (args2.length != types.length) {
            return false;
        }
        for (int i2 = 0; i2 < types.length; ++i2) {
            if (EXACT.match(types[i2], args2[i2])) continue;
            return false;
        }
        return true;
    }

    private static boolean assignableAndPrimitivable(ParameterTypes paramTypes, IRubyObject ... args2) {
        Class<?>[] types = paramTypes.getParameterTypes();
        if (args2.length != types.length) {
            return false;
        }
        for (int i2 = 0; i2 < types.length; ++i2) {
            if (ASSIGNABLE.match(types[i2], args2[i2]) && PRIMITIVABLE.match(types[i2], args2[i2])) continue;
            return false;
        }
        return true;
    }

    private static boolean assignableOrDuckable(ParameterTypes paramTypes, IRubyObject ... args2) {
        Class<?>[] types = paramTypes.getParameterTypes();
        if (args2.length != types.length) {
            return false;
        }
        for (int i2 = 0; i2 < types.length; ++i2) {
            if (ASSIGNABLE.match(types[i2], args2[i2]) || DUCKABLE.match(types[i2], args2[i2])) continue;
            return false;
        }
        return true;
    }

    private static boolean assignableAndPrimitivableWithVarargs(ParameterTypes paramTypes, IRubyObject ... args2) {
        int i2;
        if (!paramTypes.isVarArgs()) {
            return false;
        }
        Class<?>[] types = paramTypes.getParameterTypes();
        Class<?> varArgArrayType = types[types.length - 1];
        Class<?> varArgType = varArgArrayType.getComponentType();
        if (args2.length == 0) {
            return types.length <= 1;
        }
        int nonVarargs = types.length - 1;
        for (i2 = args2.length - 1; i2 >= nonVarargs; --i2) {
            if (ASSIGNABLE.match(varArgType, args2[i2]) || PRIMITIVABLE.match(varArgType, args2[i2])) continue;
            return false;
        }
        for (i2 = 0; i2 < nonVarargs; ++i2) {
            if (ASSIGNABLE.match(types[i2], args2[i2]) || PRIMITIVABLE.match(types[i2], args2[i2])) continue;
            return false;
        }
        return true;
    }

    private static boolean assignable(Class type2, IRubyObject arg2) {
        return JavaClass.assignable(type2, CallableSelector.argClass(arg2));
    }

    private static boolean primitivable(Class type2, IRubyObject arg2) {
        Class argClass = CallableSelector.argClass(arg2);
        if (type2.isPrimitive()) {
            if (type2 == Integer.TYPE || type2 == Long.TYPE || type2 == Short.TYPE || type2 == Character.TYPE) {
                return argClass == Long.TYPE || argClass == Byte.TYPE || argClass == Short.TYPE || argClass == Character.TYPE || argClass == Integer.TYPE || argClass == Long.class || argClass == Byte.class || argClass == Short.class || argClass == Character.class || argClass == Integer.class;
            }
            if (type2 == Float.TYPE || type2 == Double.TYPE) {
                return argClass == Double.TYPE || argClass == Float.TYPE || argClass == Float.class || argClass == Double.class;
            }
            if (type2 == Boolean.TYPE) {
                return argClass == Boolean.TYPE || argClass == Boolean.class;
            }
        }
        return false;
    }

    private static boolean duckable(Class type2, IRubyObject arg2) {
        return JavaUtil.isDuckTypeConvertable(CallableSelector.argClass(arg2), type2);
    }

    private static int argsHashCode(IRubyObject a0) {
        return 31 + CallableSelector.classHashCode(a0);
    }

    private static int argsHashCode(IRubyObject a0, IRubyObject a1) {
        return 31 * CallableSelector.argsHashCode(a0) + CallableSelector.classHashCode(a1);
    }

    private static int argsHashCode(IRubyObject a0, IRubyObject a1, IRubyObject a2) {
        return 31 * CallableSelector.argsHashCode(a0, a1) + CallableSelector.classHashCode(a2);
    }

    private static int argsHashCode(IRubyObject a0, IRubyObject a1, IRubyObject a2, IRubyObject a3) {
        return 31 * CallableSelector.argsHashCode(a0, a1, a2) + CallableSelector.classHashCode(a3);
    }

    private static int argsHashCode(IRubyObject[] a) {
        if (a == null) {
            return 0;
        }
        int result2 = 1;
        for (IRubyObject element : a) {
            result2 = 31 * result2 + CallableSelector.classHashCode(element);
        }
        return result2;
    }

    private static int classHashCode(IRubyObject o) {
        return o == null ? 0 : o.getJavaClass().hashCode();
    }

    private static Class argClass(IRubyObject a) {
        if (a == null) {
            return Void.TYPE;
        }
        return a.getJavaClass();
    }

    public static RaiseException argTypesDoNotMatch(Ruby runtime, IRubyObject receiver2, JavaCallable[] methods2, Object ... args2) {
        Class[] argTypes = new Class[args2.length];
        for (int i2 = 0; i2 < args2.length; ++i2) {
            argTypes[i2] = CallableSelector.argClassTypeError(args2[i2]);
        }
        return CallableSelector.argumentError(runtime.getCurrentContext(), methods2, receiver2, argTypes);
    }

    private static Class argClassTypeError(Object object) {
        if (object == null) {
            return Void.TYPE;
        }
        if (object instanceof ConcreteJavaProxy) {
            return ((ConcreteJavaProxy)object).getJavaClass();
        }
        return object.getClass();
    }

    private static RaiseException argumentError(ThreadContext context, ParameterTypes[] methods2, IRubyObject receiver2, Class[] argTypes) {
        boolean constructor2 = methods2[0] instanceof JavaConstructor || methods2[0] instanceof JavaProxyConstructor;
        StringBuffer fullError = new StringBuffer();
        fullError.append("no ");
        if (constructor2) {
            fullError.append("constructor");
        } else {
            fullError.append("method '").append(((JavaMethod)methods2[0]).name().toString()).append("' ");
        }
        fullError.append("for arguments ").append(CodegenUtils.prettyParams(argTypes)).append(" on ");
        if (receiver2 instanceof RubyModule) {
            fullError.append(((RubyModule)receiver2).getName());
        } else {
            fullError.append(receiver2.getMetaClass().getRealClass().getName());
        }
        if (methods2.length > 1) {
            fullError.append("\n  available overloads:");
            for (ParameterTypes method2 : methods2) {
                fullError.append("\n    " + CodegenUtils.prettyParams(method2.getParameterTypes()));
            }
        }
        return context.runtime.newNameError(fullError.toString(), null);
    }

    private static interface Matcher {
        public boolean match(Class var1, IRubyObject var2);
    }

    private static interface CallableAcceptor {
        public boolean accept(ParameterTypes var1, IRubyObject[] var2);
    }
}

