/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;

@JRubyClass(name={"Generator"}, include={"Enumerable"})
public class Generator {
    public static void createGenerator(Ruby runtime) throws IOException {
        RubyClass cGen = runtime.defineClass("Generator", runtime.getObject(), runtime.getObject().getAllocator());
        cGen.includeModule(runtime.getEnumerable());
        cGen.defineAnnotatedMethods(Generator.class);
    }

    @JRubyMethod(name={"new"}, rest=true, frame=true, meta=true)
    public static IRubyObject new_instance(IRubyObject self, IRubyObject[] args, Block block) {
        RubyObject result = new RubyObject(self.getRuntime(), (RubyClass)self);
        result.dataWrapStruct(new GeneratorData(result));
        result.callMethod(self.getRuntime().getCurrentContext(), "initialize", args, block);
        return result;
    }

    @JRubyMethod(optional=1, frame=true, visibility=Visibility.PRIVATE)
    public static IRubyObject initialize(IRubyObject self, IRubyObject[] args, Block block) {
        GeneratorData d = (GeneratorData)self.dataGetStruct();
        self.getInstanceVariables().setInstanceVariable("@queue", self.getRuntime().newArray());
        self.getInstanceVariables().setInstanceVariable("@index", self.getRuntime().newFixnum(0));
        if (Arity.checkArgumentCount(self.getRuntime(), args, 0, 1) == 1) {
            d.setEnum(args[0]);
        } else {
            d.setProc(self.getRuntime().newProc(Block.Type.PROC, block));
        }
        return self;
    }

    @JRubyMethod(frame=true)
    public static IRubyObject yield(IRubyObject self, IRubyObject value, Block block) {
        self.getInstanceVariables().getInstanceVariable("@queue").callMethod(self.getRuntime().getCurrentContext(), "<<", value);
        GeneratorData d = (GeneratorData)self.dataGetStruct();
        d.doWait();
        return self;
    }

    @JRubyMethod(name={"end?"})
    public static IRubyObject end_p(IRubyObject self) {
        GeneratorData d = (GeneratorData)self.dataGetStruct();
        boolean emptyQueue = self.getInstanceVariables().getInstanceVariable("@queue").callMethod(self.getRuntime().getCurrentContext(), MethodIndex.EMPTY_P, "empty?").isTrue();
        return d.isEnd() && emptyQueue ? self.getRuntime().getTrue() : self.getRuntime().getFalse();
    }

    @JRubyMethod(name={"next?"})
    public static IRubyObject next_p(IRubyObject self) {
        return RuntimeHelpers.negate(RuntimeHelpers.invoke(self.getRuntime().getCurrentContext(), self, "end?"), self.getRuntime());
    }

    @JRubyMethod(name={"index", "pos"})
    public static IRubyObject index(IRubyObject self) {
        return self.getInstanceVariables().getInstanceVariable("@index");
    }

    @JRubyMethod(frame=true)
    public static IRubyObject next(IRubyObject self, Block block) {
        GeneratorData d = (GeneratorData)self.dataGetStruct();
        if (RuntimeHelpers.invoke(self.getRuntime().getCurrentContext(), self, "end?").isTrue()) {
            throw self.getRuntime().newEOFError("no more elements available");
        }
        d.generate();
        self.getInstanceVariables().setInstanceVariable("@index", self.getInstanceVariables().getInstanceVariable("@index").callMethod(self.getRuntime().getCurrentContext(), MethodIndex.OP_PLUS, "+", self.getRuntime().newFixnum(1)));
        return self.getInstanceVariables().getInstanceVariable("@queue").callMethod(self.getRuntime().getCurrentContext(), "shift");
    }

    @JRubyMethod(frame=true)
    public static IRubyObject current(IRubyObject self, Block block) {
        if (self.getInstanceVariables().getInstanceVariable("@queue").callMethod(self.getRuntime().getCurrentContext(), MethodIndex.EMPTY_P, "empty?").isTrue()) {
            throw self.getRuntime().newEOFError("no more elements available");
        }
        return self.getInstanceVariables().getInstanceVariable("@queue").callMethod(self.getRuntime().getCurrentContext(), "first");
    }

    @JRubyMethod(frame=true)
    public static IRubyObject rewind(IRubyObject self, Block block) {
        if (self.getInstanceVariables().getInstanceVariable("@index").callMethod(self.getRuntime().getCurrentContext(), "nonzero?").isTrue()) {
            GeneratorData d = (GeneratorData)self.dataGetStruct();
            self.getInstanceVariables().setInstanceVariable("@queue", self.getRuntime().newArray());
            self.getInstanceVariables().setInstanceVariable("@index", self.getRuntime().newFixnum(0));
            d.start();
        }
        return self;
    }

    @JRubyMethod(frame=true)
    public static IRubyObject each(IRubyObject self, Block block) {
        Generator.rewind(self, Block.NULL_BLOCK);
        ThreadContext ctx = self.getRuntime().getCurrentContext();
        while (Generator.next_p(self).isTrue()) {
            block.yield(ctx, Generator.next(self, Block.NULL_BLOCK));
        }
        return self;
    }

    static class GeneratorData
    implements Runnable {
        private IRubyObject gen;
        private Object mutex = new Object();
        private IRubyObject enm;
        private RubyProc proc;
        private Thread t;
        private volatile boolean end;
        private IterBlockCallback ibc;
        private boolean available = false;

        public GeneratorData(IRubyObject gen) {
            this.gen = gen;
        }

        public void setEnum(IRubyObject enm) {
            this.proc = null;
            this.enm = enm;
            this.start();
        }

        public void setProc(RubyProc proc) {
            this.proc = proc;
            this.enm = null;
            this.start();
        }

        public void start() {
            if (this.t != null) {
                this.t.interrupt();
                try {
                    this.t.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.end = false;
            this.ibc = new IterBlockCallback();
            this.t = new Thread(this);
            this.t.setDaemon(true);
            this.t.start();
            this.generate();
        }

        public boolean isEnd() {
            return this.end;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doWait() {
            this.available = true;
            if (this.proc != null) {
                boolean inter = true;
                Object object = this.mutex;
                synchronized (object) {
                    this.mutex.notifyAll();
                    while (inter) {
                        try {
                            this.mutex.wait();
                            inter = false;
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void generate() {
            if (this.proc == null) {
                boolean inter = true;
                Object object = this.mutex;
                synchronized (object) {
                    while (!this.ibc.haveValue() && !this.end) {
                        this.mutex.notifyAll();
                        inter = true;
                        while (inter) {
                            try {
                                this.mutex.wait();
                                inter = false;
                            }
                            catch (InterruptedException e) {}
                        }
                    }
                    if (this.ibc.haveValue() && this.proc == null) {
                        this.gen.callMethod(this.gen.getRuntime().getCurrentContext(), "yield", this.ibc.pop());
                    }
                }
            }
            Object object = this.mutex;
            synchronized (object) {
                while (!this.available && !this.end) {
                    boolean inter = true;
                    this.mutex.notifyAll();
                    while (inter) {
                        try {
                            this.mutex.wait(20L);
                            inter = false;
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                this.available = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ThreadContext context = this.gen.getRuntime().getCurrentContext();
            if (this.enm != null) {
                this.enm.callMethod(context, "each", IRubyObject.NULL_ARRAY, CallBlock.newCallClosure(this.enm, this.enm.getMetaClass().getRealClass(), Arity.noArguments(), this.ibc, context));
            } else {
                this.proc.call(context, new IRubyObject[]{this.gen});
            }
            this.end = true;
            Object object = this.mutex;
            synchronized (object) {
                this.mutex.notifyAll();
            }
        }

        private class IterBlockCallback
        implements BlockCallback {
            private IRubyObject obj;
            private boolean shouldSkip = false;

            private IterBlockCallback() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IRubyObject call(ThreadContext context, IRubyObject[] iargs, Block block) {
                if (this.shouldSkip) {
                    return GeneratorData.this.gen.getRuntime().getNil();
                }
                boolean inter = true;
                Object object = GeneratorData.this.mutex;
                synchronized (object) {
                    GeneratorData.this.mutex.notifyAll();
                    while (inter) {
                        try {
                            GeneratorData.this.mutex.wait();
                            inter = false;
                        }
                        catch (InterruptedException e) {
                            this.shouldSkip = true;
                            return GeneratorData.this.gen.getRuntime().getNil();
                        }
                    }
                    this.obj = iargs.length > 1 ? GeneratorData.this.gen.getRuntime().newArrayNoCopy(iargs) : iargs[0];
                    GeneratorData.this.mutex.notifyAll();
                    return GeneratorData.this.gen.getRuntime().getNil();
                }
            }

            public boolean haveValue() {
                return this.obj != null;
            }

            public IRubyObject pop() {
                IRubyObject a = this.obj;
                this.obj = null;
                return a;
            }
        }
    }

    public static class Service
    implements Library {
        public void load(Ruby runtime, boolean wrap) throws IOException {
            Generator.createGenerator(runtime);
        }
    }
}

