/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalAsgnNode
extends AssignableNode
implements INameNode {
    private String name;

    public GlobalAsgnNode(ISourcePosition position, String name, Node valueNode) {
        super(position, NodeType.GLOBALASGNNODE, valueNode);
        this.name = name;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitGlobalAsgnNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return GlobalAsgnNode.createList(this.getValueNode());
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject result = this.getValueNode().interpret(runtime, context, self, aBlock);
        runtime.getGlobalVariables().set(this.name, result);
        return result;
    }

    @Override
    public IRubyObject assign(Ruby runtime, ThreadContext context, IRubyObject self, IRubyObject value, Block block, boolean checkArity) {
        runtime.getGlobalVariables().set(this.name, value);
        return runtime.getNil();
    }
}

