/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubyUnboundMethod;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodBlock;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Method"})
public class RubyMethod
extends RubyObject {
    protected RubyModule implementationModule;
    protected String methodName;
    protected RubyModule originModule;
    protected String originName;
    protected DynamicMethod method;
    protected IRubyObject receiver;

    protected RubyMethod(Ruby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
    }

    public static RubyClass createMethodClass(Ruby runtime) {
        RubyClass methodClass = runtime.defineClass("Method", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setMethod(methodClass);
        methodClass.defineAnnotatedMethods(RubyMethod.class);
        return methodClass;
    }

    public static RubyMethod newMethod(RubyModule implementationModule, String methodName, RubyModule originModule, String originName, DynamicMethod method, IRubyObject receiver) {
        Ruby runtime = implementationModule.getRuntime();
        RubyMethod newMethod = new RubyMethod(runtime, runtime.getMethod());
        newMethod.implementationModule = implementationModule;
        newMethod.methodName = methodName;
        newMethod.originModule = originModule;
        newMethod.originName = originName;
        newMethod.method = method.getRealMethod();
        newMethod.receiver = receiver;
        return newMethod;
    }

    @JRubyMethod(name={"call", "[]"}, rest=true, frame=true)
    public IRubyObject call(ThreadContext context, IRubyObject[] args, Block block) {
        assert (args != null);
        this.method.getArity().checkArity(context.getRuntime(), args);
        return this.method.call(context, this.receiver, this.implementationModule, this.methodName, args, block);
    }

    @JRubyMethod(name={"arity"})
    public RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.method.getArity().getValue());
    }

    @JRubyMethod(name={"=="}, required=1)
    public RubyBoolean op_equal(ThreadContext context, IRubyObject other) {
        if (!(other instanceof RubyMethod)) {
            return context.getRuntime().getFalse();
        }
        RubyMethod otherMethod = (RubyMethod)other;
        return context.getRuntime().newBoolean(this.implementationModule == otherMethod.implementationModule && this.originModule == otherMethod.originModule && this.receiver == otherMethod.receiver && this.method.getRealMethod() == otherMethod.method.getRealMethod());
    }

    @JRubyMethod(name={"clone"})
    public RubyMethod rbClone() {
        return RubyMethod.newMethod(this.implementationModule, this.methodName, this.originModule, this.originName, this.method, this.receiver);
    }

    @JRubyMethod(name={"to_proc"}, frame=true)
    public IRubyObject to_proc(ThreadContext context, Block unusedBlock) {
        Ruby runtime = context.getRuntime();
        CallbackFactory f = runtime.callbackFactory(RubyMethod.class);
        Block block = MethodBlock.createMethodBlock(context, context.getCurrentScope(), f.getBlockMethod("bmcall"), this, runtime.getTopSelf());
        while (true) {
            try {
                return this.mproc(context, block);
            }
            catch (JumpException.BreakJump bj) {
                return (IRubyObject)bj.getValue();
            }
            catch (JumpException.ReturnJump rj) {
                return (IRubyObject)rj.getValue();
            }
            catch (JumpException.RetryJump rj) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject mproc(ThreadContext context, Block block) {
        try {
            context.preMproc();
            RubyProc rubyProc = RubyKernel.proc(context, context.getRuntime().getNil(), block);
            return rubyProc;
        }
        finally {
            context.postMproc();
        }
    }

    public static IRubyObject bmcall(IRubyObject blockArg, IRubyObject arg1, IRubyObject self, Block unusedBlock) {
        ThreadContext context = blockArg.getRuntime().getCurrentContext();
        if (blockArg instanceof RubyArray) {
            return ((RubyMethod)arg1).call(context, ((RubyArray)blockArg).toJavaArray(), Block.NULL_BLOCK);
        }
        return ((RubyMethod)arg1).call(context, new IRubyObject[]{blockArg}, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"unbind"}, frame=true)
    public RubyUnboundMethod unbind(Block unusedBlock) {
        RubyUnboundMethod unboundMethod = RubyUnboundMethod.newUnboundMethod(this.implementationModule, this.methodName, this.originModule, this.originName, this.method);
        unboundMethod.infectBy(this);
        return unboundMethod;
    }

    @JRubyMethod(name={"inspect", "to_s"})
    public IRubyObject inspect() {
        StringBuilder buf = new StringBuilder("#<");
        int delimeter = 35;
        buf.append(this.getMetaClass().getRealClass().getName()).append(": ");
        if (this.implementationModule.isSingleton()) {
            IRubyObject attached = ((MetaClass)this.implementationModule).getAttached();
            if (this.receiver == null) {
                buf.append(this.implementationModule.inspect().toString());
            } else if (this.receiver == attached) {
                buf.append(attached.inspect().toString());
                delimeter = 46;
            } else {
                buf.append(this.receiver.inspect().toString());
                buf.append('(').append(attached.inspect().toString()).append(')');
                delimeter = 46;
            }
        } else {
            buf.append(this.originModule.getName());
            if (this.implementationModule != this.originModule) {
                buf.append('(').append(this.implementationModule.getName()).append(')');
            }
        }
        buf.append((char)delimeter).append(this.methodName).append('>');
        RubyString str = this.getRuntime().newString(buf.toString());
        str.setTaint(this.isTaint());
        return str;
    }
}

