/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.util.Map;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import jodd.mail.MailException;
import jodd.mail.SendMailSession;
import jodd.mail.SendMailSessionProvider;
import jodd.mail.SimpleAuthenticator;

public class SmtpServer<T extends SmtpServer>
implements SendMailSessionProvider {
    public static final String MAIL_HOST = "mail.host";
    public static final String MAIL_SMTP_HOST = "mail.smtp.host";
    public static final String MAIL_SMTP_PORT = "mail.smtp.port";
    public static final String MAIL_SMTP_AUTH = "mail.smtp.auth";
    public static final String MAIL_TRANSPORT_PROTOCOL = "mail.transport.protocol";
    public static final String MAIL_SMTP_FROM = "mail.smtp.from";
    public static final String MAIL_SMTP_CONNECTIONTIMEOUT = "mail.smtp.connectiontimeout";
    public static final String MAIL_SMTP_TIMEOUT = "mail.smtp.timeout";
    public static final String MAIL_SMTP_WRITETIMEOUT = "mail.smtp.writetimeout";
    public static final String MAIL_DEBUG = "mail.debug";
    public static final String MAIL_MIME_ADDRESS_STRICT = "mail.mime.address.strict";
    protected static final String PROTOCOL_SMTP = "smtp";
    protected static final int DEFAULT_SMTP_PORT = 25;
    protected final String host;
    protected final int port;
    protected Authenticator authenticator;
    protected int timeout = 0;
    protected boolean debug = false;
    protected boolean strictAddress = true;
    private Properties additionalProperties;

    public static SmtpServer create(String host) {
        return new SmtpServer(host, 25);
    }

    public static SmtpServer create(String host, int port) {
        return new SmtpServer(host, port);
    }

    public SmtpServer(String host) {
        this.host = host;
        this.port = 25;
    }

    public SmtpServer(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public T authenticateWith(String username, String password) {
        this.authenticator = new SimpleAuthenticator(username, password);
        return (T)this;
    }

    public T authenticateWith(Authenticator authenticator) {
        this.authenticator = authenticator;
        return (T)this;
    }

    public T timeout(int timeout) {
        this.timeout = timeout;
        return (T)this;
    }

    public T debug(boolean debug) {
        this.debug = true;
        return (T)this;
    }

    public T strictAddress(boolean strictAddress) {
        this.strictAddress = strictAddress;
        return (T)this;
    }

    public T properties(Properties properties) {
        this.additionalProperties = properties;
        return (T)this;
    }

    public T property(String name, String value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new Properties();
        }
        this.additionalProperties.put(name, value);
        return (T)this;
    }

    protected Properties createSessionProperties() {
        Properties props = new Properties();
        props.setProperty(MAIL_TRANSPORT_PROTOCOL, PROTOCOL_SMTP);
        props.setProperty(MAIL_HOST, this.host);
        props.setProperty(MAIL_SMTP_HOST, this.host);
        props.setProperty(MAIL_SMTP_PORT, String.valueOf(this.port));
        if (this.authenticator != null) {
            props.setProperty(MAIL_SMTP_AUTH, "true");
        }
        if (this.timeout > 0) {
            String timeoutValue = String.valueOf(this.timeout);
            props.put(MAIL_SMTP_CONNECTIONTIMEOUT, timeoutValue);
            props.put(MAIL_SMTP_TIMEOUT, timeoutValue);
            props.put(MAIL_SMTP_WRITETIMEOUT, timeoutValue);
        }
        if (this.debug) {
            props.put(MAIL_DEBUG, "true");
        }
        if (!this.strictAddress) {
            props.put(MAIL_MIME_ADDRESS_STRICT, "false");
        }
        return props;
    }

    @Override
    public SendMailSession createSession() {
        Transport mailTransport;
        Properties sessionProperties = this.createSessionProperties();
        if (this.additionalProperties != null) {
            sessionProperties.putAll((Map<?, ?>)this.additionalProperties);
        }
        Session mailSession = Session.getInstance((Properties)sessionProperties, (Authenticator)this.authenticator);
        try {
            mailTransport = this.getTransport(mailSession);
        }
        catch (NoSuchProviderException nspex) {
            throw new MailException(nspex);
        }
        return new SendMailSession(mailSession, mailTransport);
    }

    protected Transport getTransport(Session session) throws NoSuchProviderException {
        return session.getTransport(PROTOCOL_SMTP);
    }

    public String getHost() {
        return this.host;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public int getPort() {
        return this.port;
    }

    public int getTimeout() {
        return this.timeout;
    }
}

