/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import com.sun.mail.pop3.POP3SSLStore;
import java.util.Properties;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import jodd.mail.Pop3Server;

public class Pop3SslServer
extends Pop3Server {
    protected static final String MAIL_POP3_SOCKET_FACTORY_PORT = "mail.pop3.socketFactory.port";
    protected static final String MAIL_POP3_SOCKET_FACTORY_CLASS = "mail.pop3.socketFactory.class";
    protected static final String MAIL_POP3_SOCKET_FACTORY_FALLBACK = "mail.pop3.socketFactory.fallback";
    protected static final int DEFAULT_SSL_PORT = 995;
    protected final String username;
    protected final String password;

    public Pop3SslServer(String host, String username, String password) {
        this(host, 995, username, password);
    }

    public Pop3SslServer(String host, int port, String username, String password) {
        super(host, port, username, password);
        this.username = username;
        this.password = password;
    }

    @Override
    protected Properties createSessionProperties() {
        Properties props = new Properties();
        props.setProperty("mail.pop3.port", String.valueOf(this.port));
        props.setProperty(MAIL_POP3_SOCKET_FACTORY_PORT, String.valueOf(this.port));
        props.setProperty(MAIL_POP3_SOCKET_FACTORY_CLASS, "javax.net.ssl.SSLSocketFactory");
        props.setProperty(MAIL_POP3_SOCKET_FACTORY_FALLBACK, "false");
        return props;
    }

    @Override
    protected Store getStore(Session session) throws NoSuchProviderException {
        URLName url = new URLName("pop3", this.host, this.port, "", this.username, this.password);
        return new POP3SSLStore(session, url);
    }
}

