/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.hornetq;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.HashSet;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.HornetQServers;
import org.hornetq.integration.transports.netty.NettyAcceptorFactory;
import org.hornetq.integration.transports.netty.NettyConnectorFactory;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.hornetq.HornetQTaskServerHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHornetQTaskServer
extends TaskServer {
    public static final String SERVER_TASK_COMMANDS_QUEUE = "tasksQueue";
    private static final Logger logger = LoggerFactory.getLogger(TaskServer.class);
    private HornetQServer server;
    private HornetQTaskServerHandler handler;
    private Configuration configuration;
    private boolean standalone;
    private final int port;
    volatile boolean embeddedServerRunning;
    private boolean running;
    private ClientSession session;
    private ClientConsumer consumer;

    public BaseHornetQTaskServer(HornetQTaskServerHandler handler, int port, boolean standalone) {
        this.handler = handler;
        this.port = port;
        this.standalone = standalone;
    }

    public BaseHornetQTaskServer(HornetQTaskServerHandler handler, int port, Configuration configuration, boolean standalone) {
        this.handler = handler;
        this.port = port;
        this.configuration = configuration;
        this.standalone = standalone;
    }

    public void run() {
        try {
            this.start();
            while (this.running) {
                ClientMessage clientMessage = this.consumer.receive();
                if (clientMessage == null) continue;
                Object object = this.readMessage(clientMessage);
                String clientId = clientMessage.getStringProperty("producerId");
                this.handler.messageReceived(this.session, object, clientId);
            }
        }
        catch (HornetQException e) {
            switch (e.getCode()) {
                case 102: {
                    logger.info(e.getMessage());
                    break;
                }
                default: {
                    logger.error(e.getMessage());
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Server Exception with class " + this.getClass() + " using port " + this.port, e);
        }
    }

    private Object readMessage(ClientMessage msgReceived) throws IOException {
        int bodySize = msgReceived.getBodySize();
        byte[] message = new byte[bodySize];
        msgReceived.getBodyBuffer().readBytes(message);
        ByteArrayInputStream bais = new ByteArrayInputStream(message);
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            return ois.readObject();
        }
        catch (IOException e) {
            throw new IOException("Error reading message");
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Error creating message");
        }
    }

    public void start() throws Exception {
        block4: {
            HashMap<String, Integer> connectionParams = new HashMap<String, Integer>();
            connectionParams.put("port", this.port);
            if (!this.standalone) {
                if (this.configuration == null) {
                    this.configuration = new ConfigurationImpl();
                    this.configuration.setPersistenceEnabled(false);
                    this.configuration.setSecurityEnabled(false);
                    this.configuration.setClustered(false);
                }
                TransportConfiguration transpConf = new TransportConfiguration(NettyAcceptorFactory.class.getName(), connectionParams);
                HashSet<TransportConfiguration> setTransp = new HashSet<TransportConfiguration>();
                setTransp.add(transpConf);
                this.configuration.setAcceptorConfigurations(setTransp);
                this.server = HornetQServers.newHornetQServer((Configuration)this.configuration);
                this.server.start();
                this.embeddedServerRunning = true;
            }
            TransportConfiguration transportConfiguration = new TransportConfiguration(NettyConnectorFactory.class.getCanonicalName(), connectionParams);
            ClientSessionFactory factory = HornetQClient.createClientSessionFactory((TransportConfiguration)transportConfiguration);
            this.session = factory.createSession();
            try {
                this.session.createQueue(SERVER_TASK_COMMANDS_QUEUE, SERVER_TASK_COMMANDS_QUEUE, true);
            }
            catch (HornetQException e) {
                if (e.getCode() == 101) break block4;
                logger.info(e.getMessage());
                throw new RuntimeException("Server Exception with class " + this.getClass() + " using port " + this.port, e);
            }
        }
        this.consumer = this.session.createConsumer(SERVER_TASK_COMMANDS_QUEUE);
        this.session.start();
        this.running = true;
    }

    public void stop() throws Exception {
        if (this.running) {
            this.running = false;
            this.closeAll();
        }
        if (this.embeddedServerRunning) {
            this.embeddedServerRunning = false;
            this.closeAll();
            this.server.stop();
        }
    }

    private void closeAll() throws HornetQException {
        if (!this.session.isClosed()) {
            this.session.close();
        }
        if (!this.consumer.isClosed()) {
            this.consumer.close();
        }
    }

    public boolean isRunning() {
        return this.running;
    }
}

