/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.drools.SystemEventListener;
import org.jbpm.eventmessaging.EventKeys;
import org.jbpm.task.AccessType;
import org.jbpm.task.AllowedToDelegate;
import org.jbpm.task.Attachment;
import org.jbpm.task.BooleanExpression;
import org.jbpm.task.Comment;
import org.jbpm.task.Content;
import org.jbpm.task.Deadline;
import org.jbpm.task.Deadlines;
import org.jbpm.task.Delegation;
import org.jbpm.task.EmailNotification;
import org.jbpm.task.EmailNotificationHeader;
import org.jbpm.task.Escalation;
import org.jbpm.task.Group;
import org.jbpm.task.I18NText;
import org.jbpm.task.Notification;
import org.jbpm.task.NotificationType;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.PeopleAssignments;
import org.jbpm.task.Reassignment;
import org.jbpm.task.Status;
import org.jbpm.task.StatusChange;
import org.jbpm.task.Task;
import org.jbpm.task.TaskData;
import org.jbpm.task.User;
import org.jbpm.task.UserInfo;
import org.jbpm.task.WorkItemNotification;
import org.jbpm.task.event.MessagingTaskEventListener;
import org.jbpm.task.event.TaskEventListener;
import org.jbpm.task.event.TaskEventSupport;
import org.jbpm.task.query.DeadlineSummary;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.Allowed;
import org.jbpm.task.service.Command;
import org.jbpm.task.service.CommandName;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.DefaultEscalatedDeadlineHandler;
import org.jbpm.task.service.EscalatedDeadlineHandler;
import org.jbpm.task.service.Operation;
import org.jbpm.task.service.OperationCommand;
import org.jbpm.task.service.TaskServiceSession;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.compiler.ExpressionCompiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskService {
    EntityManagerFactory emf;
    EntityManager em;
    ScheduledThreadPoolExecutor scheduler;
    private EscalatedDeadlineHandler escalatedDeadlineHandler;
    private UserInfo userInfo;
    private TaskEventSupport eventSupport;
    private EventKeys eventKeys;
    private SystemEventListener systemEventListener;
    Map<Operation, List<OperationCommand>> operations;
    private static Map<String, Class> inputs = new HashMap<String, Class>();

    public TaskService(EntityManagerFactory emf, SystemEventListener systemEventListener) {
        this(emf, systemEventListener, null);
    }

    public TaskService(EntityManagerFactory emf, SystemEventListener systemEventListener, EscalatedDeadlineHandler escalationHandler) {
        this.emf = emf;
        this.systemEventListener = systemEventListener;
        this.em = emf.createEntityManager();
        if (escalationHandler != null) {
            this.escalatedDeadlineHandler = escalationHandler;
        }
        this.eventSupport = new TaskEventSupport();
        this.eventKeys = new EventKeys();
        this.eventSupport.addEventListener(new MessagingTaskEventListener(this.eventKeys));
        this.scheduler = new ScheduledThreadPoolExecutor(3);
        long now = System.currentTimeMillis();
        for (Object object : this.em.createNamedQuery("UnescalatedDeadlines").getResultList()) {
            DeadlineSummary summary = (DeadlineSummary)object;
            this.schedule(new ScheduledTaskDeadline(summary.getTaskId(), summary.getDeadlineId(), this), summary.getDate().getTime() - now);
        }
        HashMap vars = new HashMap();
        InputStream is = null;
        for (Class<?> c = this.getClass(); c != null && (is = c.getResourceAsStream("operations-dsl.mvel")) == null; c = c.getSuperclass()) {
        }
        if (is == null) {
            throw new RuntimeException("Unable To initialise TaskService, could not find Operations DSL");
        }
        InputStreamReader reader = new InputStreamReader(is);
        try {
            this.operations = (Map)this.eval(TaskService.toString(reader), vars);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable To initialise TaskService, could not load Operations DSL");
        }
    }

    public TaskServiceSession createSession() {
        return new TaskServiceSession(this, this.emf.createEntityManager());
    }

    public void schedule(ScheduledTaskDeadline deadline, long delay) {
        this.scheduler.schedule(deadline, delay, TimeUnit.MILLISECONDS);
    }

    public Map<Operation, List<OperationCommand>> getOperations() {
        return this.operations;
    }

    public List<OperationCommand> getCommandsForOperation(Operation operation) {
        return this.operations.get((Object)operation);
    }

    public EventKeys getEventKeys() {
        return this.eventKeys;
    }

    public void addEventListener(TaskEventListener listener) {
        this.eventSupport.addEventListener(listener);
    }

    public void removeEventListener(TaskEventListener listener) {
        this.eventSupport.removeEventListener(listener);
    }

    public List<TaskEventListener> getWorkingMemoryEventListeners() {
        return this.eventSupport.getEventListeners();
    }

    public TaskEventSupport getEventSupport() {
        return this.eventSupport;
    }

    public UserInfo getUserinfo() {
        return this.userInfo;
    }

    public void setUserinfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public EntityManager getEntityManager() {
        return this.em;
    }

    public void setEscalatedDeadlineHandler(EscalatedDeadlineHandler escalatedDeadlineHandler) {
        this.escalatedDeadlineHandler = escalatedDeadlineHandler;
    }

    public void executeEscalatedDeadline(long taskId, long deadlineId) {
        EntityManager localEm = this.emf.createEntityManager();
        Task task = (Task)localEm.find(Task.class, (Object)taskId);
        Deadline deadline = (Deadline)localEm.find(Deadline.class, (Object)deadlineId);
        if (this.escalatedDeadlineHandler == null) {
            this.escalatedDeadlineHandler = new DefaultEscalatedDeadlineHandler();
        }
        this.escalatedDeadlineHandler.executeEscalatedDeadline(task, deadline, localEm, this);
        localEm.close();
    }

    public static String toString(Reader reader) throws IOException {
        int charValue;
        StringBuffer sb = new StringBuffer(1024);
        while ((charValue = reader.read()) != -1) {
            sb.append((char)charValue);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Class> getInputs() {
        Map<String, Class> map = inputs;
        synchronized (map) {
            if (inputs.isEmpty()) {
                inputs.put("AccessType", AccessType.class);
                inputs.put("AllowedToDelegate", AllowedToDelegate.class);
                inputs.put("Attachment", Attachment.class);
                inputs.put("BooleanExpression", BooleanExpression.class);
                inputs.put("Comment", Comment.class);
                inputs.put("Content", Content.class);
                inputs.put("Deadline", Deadline.class);
                inputs.put("Deadlines", Deadlines.class);
                inputs.put("Delegation", Delegation.class);
                inputs.put("EmailNotification", EmailNotification.class);
                inputs.put("EmailNotificationHeader", EmailNotificationHeader.class);
                inputs.put("Escalation", Escalation.class);
                inputs.put("Group", Group.class);
                inputs.put("I18NText", I18NText.class);
                inputs.put("Notification", Notification.class);
                inputs.put("NotificationType", NotificationType.class);
                inputs.put("OrganizationalEntity", OrganizationalEntity.class);
                inputs.put("PeopleAssignments", PeopleAssignments.class);
                inputs.put("Reassignment", Reassignment.class);
                inputs.put("Status", Status.class);
                inputs.put("StatusChange", StatusChange.class);
                inputs.put("Task", Task.class);
                inputs.put("TaskData", TaskData.class);
                inputs.put("User", User.class);
                inputs.put("UserInfo", UserInfo.class);
                inputs.put("WorkItemNotification", WorkItemNotification.class);
                inputs.put("Allowed", Allowed.class);
                inputs.put("Command", Command.class);
                inputs.put("CommandName", CommandName.class);
                inputs.put("ContentData", ContentData.class);
                inputs.put("Operation", Operation.class);
                inputs.put("Operation.Claim", Operation.class);
                inputs.put("OperationCommand", OperationCommand.class);
                inputs.put("DeadlineSummary", DeadlineSummary.class);
                inputs.put("TaskSummary", TaskSummary.class);
            }
            return inputs;
        }
    }

    public Object eval(String str, Map vars) {
        ExpressionCompiler compiler = new ExpressionCompiler(str.trim());
        ParserContext context = new ParserContext();
        context.addPackageImport("org.jbpm.task");
        context.addPackageImport("org.jbpm.task.service");
        context.addPackageImport("org.jbpm.task.query");
        context.addPackageImport("java.util");
        return MVEL.executeExpression((Object)compiler.compile(context), (Map)vars);
    }

    public static class ScheduledTaskDeadline
    implements Callable {
        private long taskId;
        private long deadlineId;
        private TaskService service;

        public ScheduledTaskDeadline(long taskId, long deadlineId, TaskService service) {
            this.taskId = taskId;
            this.deadlineId = deadlineId;
            this.service = service;
        }

        public long getTaskId() {
            return this.taskId;
        }

        public long getDeadlineId() {
            return this.deadlineId;
        }

        public Object call() throws Exception {
            try {
                this.service.executeEscalatedDeadline(this.taskId, this.deadlineId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.deadlineId ^ this.deadlineId >>> 32);
            result = 31 * result + (int)(this.taskId ^ this.taskId >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ScheduledTaskDeadline)) {
                return false;
            }
            ScheduledTaskDeadline other = (ScheduledTaskDeadline)obj;
            if (this.deadlineId != other.deadlineId) {
                return false;
            }
            return this.taskId == other.taskId;
        }
    }
}

