/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.event;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jbpm.eventmessaging.EventKey;
import org.jbpm.task.event.TaskEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskEventKey
implements EventKey,
Externalizable {
    private Class<? extends TaskEvent> event;
    private long taskId = -1L;

    public TaskEventKey() {
    }

    public TaskEventKey(Class<? extends TaskEvent> event, long taskId) {
        this.event = event;
        this.taskId = taskId;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.event.getName());
        out.writeLong(this.taskId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String className = in.readUTF();
        try {
            this.event = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (Exception e) {
            this.event = this.getClass().getClassLoader().loadClass(className);
        }
        this.taskId = in.readLong();
    }

    public Class<? extends TaskEvent> getEvent() {
        return this.event;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.event == null ? 0 : this.event.hashCode());
        result = 31 * result + (int)(this.taskId ^ this.taskId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskEventKey)) {
            return false;
        }
        TaskEventKey other = (TaskEventKey)obj;
        if (this.event == null ? other.event != null : !this.event.equals(other.event)) {
            return false;
        }
        return this.taskId == other.taskId;
    }
}

