/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.Extension;
import org.jboss.weld.Container;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.builtin.ExtensionBean;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.event.ObserverFactory;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.DeploymentStructures;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionBeanDeployer {
    private final BeanManagerImpl beanManager;
    private final Set<Extension> extensions;
    private final Deployment deployment;
    private final Map<BeanDeploymentArchive, BeanDeployment> beanDeployments;

    public ExtensionBeanDeployer(BeanManagerImpl manager, Deployment deployment, Map<BeanDeploymentArchive, BeanDeployment> beanDeployments) {
        this.beanManager = manager;
        this.extensions = new HashSet<Extension>();
        this.deployment = deployment;
        this.beanDeployments = beanDeployments;
    }

    public ExtensionBeanDeployer deployBeans() {
        ClassTransformer classTransformer = Container.instance().services().get(ClassTransformer.class);
        for (Extension extension : this.extensions) {
            WeldClass<Extension> clazz = classTransformer.loadClass(extension.getClass());
            BeanDeployment beanDeployment = DeploymentStructures.getOrCreateBeanDeployment(this.deployment, this.beanManager, this.beanDeployments, clazz.getJavaClass());
            ExtensionBean bean = new ExtensionBean(beanDeployment.getBeanManager(), clazz, extension);
            HashSet observerMethods = new HashSet();
            this.createObserverMethods(bean, beanDeployment.getBeanManager(), clazz, observerMethods);
            beanDeployment.getBeanManager().addBean(bean);
            for (ObserverMethodImpl observerMethodImpl : observerMethods) {
                observerMethodImpl.initialize();
                beanDeployment.getBeanManager().addObserver(observerMethodImpl);
            }
        }
        return this;
    }

    public void addExtensions(Iterable<Extension> extensions) {
        for (Extension extension : extensions) {
            this.addExtension(extension);
        }
    }

    public void addExtension(Extension extension) {
        this.extensions.add(extension);
    }

    protected <X> void createObserverMethods(RIBean<X> declaringBean, BeanManagerImpl beanManager, WeldClass<X> annotatedClass, Set<ObserverMethodImpl<?, ?>> observerMethods) {
        for (WeldMethod<?, X> method : annotatedClass.getDeclaredWeldMethodsWithAnnotatedParameters(Observes.class)) {
            this.createObserverMethod(declaringBean, beanManager, method, observerMethods);
        }
    }

    protected <T, X> void createObserverMethod(RIBean<X> declaringBean, BeanManagerImpl beanManager, WeldMethod<T, ? super X> method, Set<ObserverMethodImpl<?, ?>> observerMethods) {
        ObserverMethodImpl<T, ? super X> observer = ObserverFactory.create(method, declaringBean, beanManager);
        observerMethods.add(observer);
    }
}

