/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.util;

import java.io.File;
import java.util.List;

public class FileReference {
    private final File file;
    private final List<String> pathAndFile;

    public FileReference(File file, List<String> pathAndFile) {
        this.file = file;
        this.pathAndFile = pathAndFile;
    }

    public boolean hasPath() {
        return this.pathAndFile != null;
    }

    public String getFirstPart() {
        return this.pathAndFile.get(0);
    }

    public String getPath() {
        return this.getPath(0);
    }

    public String getPath(int startFrom) {
        return FileReference.getPath(startFrom, this.pathAndFile);
    }

    public static String getPath(int startFrom, List<String> pathAndFile) {
        StringBuilder path = new StringBuilder();
        int count = 0;
        for (String currentPart : pathAndFile) {
            if (count >= startFrom) {
                if (count - startFrom > 0) {
                    path.append('/');
                }
                path.append(currentPart);
            }
            ++count;
        }
        return path.toString();
    }

    public File getFile() {
        return this.file;
    }
}

