/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.instructions;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.javaswift.joss.headers.object.Etag;
import org.javaswift.joss.instructions.SegmentationPlan;
import org.javaswift.joss.instructions.SegmentationPlanByteArray;
import org.javaswift.joss.instructions.UploadPayload;

public class UploadPayloadByteArray
extends UploadPayload {
    private byte[] bytes;

    public UploadPayloadByteArray(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public HttpEntity getEntity() {
        return new ByteArrayEntity(this.bytes);
    }

    @Override
    public boolean mustBeSegmented(Long segmentationSize) {
        return (long)this.bytes.length > segmentationSize;
    }

    @Override
    public Etag getEtag() throws IOException {
        return new Etag(this.getEntity().getContent());
    }

    @Override
    public SegmentationPlan getSegmentationPlan(Long segmentationSize) throws IOException {
        return new SegmentationPlanByteArray(this.bytes, segmentationSize);
    }
}

