/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.command.impl.core.httpstatus;

import org.javaswift.joss.command.impl.core.httpstatus.HttpStatusFailCondition;
import org.javaswift.joss.command.impl.core.httpstatus.HttpStatusMatch;
import org.javaswift.joss.command.impl.core.httpstatus.HttpStatusMatcher;
import org.javaswift.joss.exception.CommandException;
import org.javaswift.joss.exception.CommandExceptionError;
import org.javaswift.joss.exception.HttpStatusExceptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpStatusChecker {
    public static final Logger LOG = LoggerFactory.getLogger(HttpStatusChecker.class);
    public static final HttpStatusChecker AUTHORIZATION_MATCHER = new HttpStatusFailCondition(new HttpStatusMatch(401));
    public static final HttpStatusChecker FORBIDDEN_MATCHER = new HttpStatusFailCondition(new HttpStatusMatch(403));
    private HttpStatusMatcher matcher;

    public HttpStatusChecker(HttpStatusMatcher matcher) {
        this.matcher = matcher;
    }

    public abstract boolean isError();

    public boolean isOk(int httpStatusCode) {
        if (this.matcher.matches(httpStatusCode)) {
            if (this.isError()) {
                HttpStatusExceptionUtil.throwException(httpStatusCode);
            }
            return true;
        }
        return false;
    }

    public static void verifyCode(HttpStatusChecker[] checkers, int httpStatusCode) {
        AUTHORIZATION_MATCHER.isOk(httpStatusCode);
        FORBIDDEN_MATCHER.isOk(httpStatusCode);
        for (HttpStatusChecker checker : checkers) {
            if (!checker.isOk(httpStatusCode)) continue;
            return;
        }
        throw new CommandException(httpStatusCode, CommandExceptionError.UNKNOWN);
    }
}

