/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.resbuilder.type.styles;

import java.util.Map;
import org.holoeverywhere.resbuilder.BuildMojo;
import org.holoeverywhere.resbuilder.FileProcesser;
import org.holoeverywhere.resbuilder.type.styles.Block;
import org.holoeverywhere.resbuilder.type.styles.TypeStyles;
import org.json.JSONObject;

public class IncludeRow {
    public String name = "";
    public IncludeType type = IncludeType.ALL;

    public IncludeRow parse(JSONObject data) {
        this.name = data.optString("name", "");
        this.type = IncludeType.find(data.optString("type", IncludeType.ALL.tag));
        return this;
    }

    public void process(TypeStyles processer, BuildMojo mojo, Map<String, Block> blocks, Map<String, Block> data) throws FileProcesser.FileProcesserException {
        this.process(processer, mojo, blocks, data, null);
    }

    public void process(TypeStyles processer, BuildMojo mojo, Map<String, Block> blocks, Map<String, Block> data, IncludeType parentIncludeType) throws FileProcesser.FileProcesserException {
        if (blocks == null || data == null) {
            return;
        }
        TypeStyles.StylesProcessResult result = mojo.processer.process(this.name).find(TypeStyles.StylesProcessResult.class);
        if (result == null) {
            return;
        }
        if (parentIncludeType == IncludeType.ONLY_BLOCKS) {
            this.type = IncludeType.ONLY_BLOCKS;
        }
        switch (this.type) {
            default: {
                data.putAll(result.data);
            }
            case ONLY_BLOCKS: 
        }
        blocks.putAll(result.blocks);
        for (IncludeRow i : result.include) {
            i.process(processer, mojo, blocks, data, this.type);
        }
    }

    public IncludeRow parseRaw(Object o) {
        if (o instanceof JSONObject) {
            return this.parse((JSONObject)o);
        }
        this.name = o.toString();
        return this;
    }

    public static enum IncludeType {
        ALL("all"),
        ONLY_BLOCKS("only blocks");

        public final String tag;

        public static IncludeType find(String tag) {
            for (IncludeType i : IncludeType.values()) {
                if (!i.tag.equals(tag)) continue;
                return i;
            }
            return null;
        }

        private IncludeType() {
            this(null);
        }

        private IncludeType(String tag) {
            this.tag = tag == null ? this.name().toLowerCase().replace('_', ' ') : tag;
        }
    }
}

