/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.tools.hbm2ddl;

import java.sql.Connection;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.envers.configuration.spi.AuditConfiguration;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaExport;

public class EnversSchemaGenerator {
    private final SchemaExport export;

    public EnversSchemaGenerator(ServiceRegistry serviceRegistry, Configuration configuration) {
        configuration = this.configureAuditing(configuration);
        this.export = new SchemaExport(serviceRegistry, configuration);
    }

    public EnversSchemaGenerator(Configuration configuration) {
        configuration = this.configureAuditing(configuration);
        this.export = new SchemaExport(configuration);
    }

    public EnversSchemaGenerator(Configuration configuration, Properties properties) throws HibernateException {
        configuration = this.configureAuditing(configuration);
        this.export = new SchemaExport(configuration, properties);
    }

    public EnversSchemaGenerator(Configuration configuration, Connection connection) throws HibernateException {
        configuration = this.configureAuditing(configuration);
        this.export = new SchemaExport(configuration, connection);
    }

    public SchemaExport export() {
        return this.export;
    }

    private Configuration configureAuditing(Configuration configuration) {
        configuration.buildMappings();
        AuditConfiguration.getFor(configuration);
        return configuration;
    }
}

