/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.configurator;

import javax.sql.DataSource;
import org.flowable.engine.cfg.AbstractProcessEngineConfigurator;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.idm.engine.IdmEngine;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.spring.SpringIdmEngineConfiguration;
import org.flowable.spring.SpringProcessEngineConfiguration;

public class SpringIdmEngineConfigurator
extends AbstractProcessEngineConfigurator {
    protected SpringIdmEngineConfiguration idmEngineConfiguration;

    public void configure(ProcessEngineConfigurationImpl processEngineConfiguration) {
        if (this.idmEngineConfiguration == null) {
            this.idmEngineConfiguration = new SpringIdmEngineConfiguration();
        }
        if (processEngineConfiguration.getDataSource() == null) {
            throw new FlowableException("A datasource is required for initializing the IDM engine ");
        }
        DataSource originalDatasource = processEngineConfiguration.getDataSource();
        this.idmEngineConfiguration.setDataSource(originalDatasource);
        this.idmEngineConfiguration.setDatabaseType(processEngineConfiguration.getDatabaseType());
        this.idmEngineConfiguration.setDatabaseCatalog(processEngineConfiguration.getDatabaseCatalog());
        this.idmEngineConfiguration.setDatabaseSchema(processEngineConfiguration.getDatabaseSchema());
        this.idmEngineConfiguration.setDatabaseSchemaUpdate(processEngineConfiguration.getDatabaseSchemaUpdate());
        this.idmEngineConfiguration.setTransactionManager(((SpringProcessEngineConfiguration)processEngineConfiguration).getTransactionManager());
        if (processEngineConfiguration.getEventDispatcher() != null) {
            this.idmEngineConfiguration.setEventDispatcher(processEngineConfiguration.getEventDispatcher());
        }
        IdmEngine idmEngine = this.idmEngineConfiguration.buildIdmEngine();
        processEngineConfiguration.setIdmEngineInitialized(true);
        processEngineConfiguration.setIdmIdentityService(idmEngine.getIdmIdentityService());
    }

    public void beforeInit(ProcessEngineConfigurationImpl processEngineConfiguration) {
    }

    public IdmEngineConfiguration getIdmEngineConfiguration() {
        return this.idmEngineConfiguration;
    }

    public SpringIdmEngineConfigurator setIdmEngineConfiguration(SpringIdmEngineConfiguration idmEngineConfiguration) {
        this.idmEngineConfiguration = idmEngineConfiguration;
        return this;
    }
}

