/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl;

import java.sql.Connection;
import java.util.Map;
import org.flowable.engine.common.api.management.TableMetaData;
import org.flowable.engine.common.api.management.TablePageQuery;
import org.flowable.engine.common.impl.cmd.CustomSqlExecution;
import org.flowable.engine.common.impl.interceptor.CommandConfig;
import org.flowable.idm.api.IdmManagementService;
import org.flowable.idm.engine.impl.ServiceImpl;
import org.flowable.idm.engine.impl.TablePageQueryImpl;
import org.flowable.idm.engine.impl.cmd.ExecuteCustomSqlCmd;
import org.flowable.idm.engine.impl.cmd.GetPropertiesCmd;
import org.flowable.idm.engine.impl.cmd.GetTableCountCmd;
import org.flowable.idm.engine.impl.cmd.GetTableMetaDataCmd;
import org.flowable.idm.engine.impl.cmd.GetTableNameCmd;
import org.flowable.idm.engine.impl.db.DbSqlSession;
import org.flowable.idm.engine.impl.db.DbSqlSessionFactory;
import org.flowable.idm.engine.impl.interceptor.Command;
import org.flowable.idm.engine.impl.interceptor.CommandContext;

public class IdmManagementServiceImpl
extends ServiceImpl
implements IdmManagementService {
    public Map<String, Long> getTableCount() {
        return this.commandExecutor.execute(new GetTableCountCmd());
    }

    public String getTableName(Class<?> entityClass) {
        return this.commandExecutor.execute(new GetTableNameCmd(entityClass));
    }

    public TableMetaData getTableMetaData(String tableName) {
        return this.commandExecutor.execute(new GetTableMetaDataCmd(tableName));
    }

    public TablePageQuery createTablePageQuery() {
        return new TablePageQueryImpl(this.commandExecutor);
    }

    public Map<String, String> getProperties() {
        return this.commandExecutor.execute(new GetPropertiesCmd());
    }

    public String databaseSchemaUpgrade(final Connection connection, final String catalog, final String schema) {
        CommandConfig config = this.commandExecutor.getDefaultConfig().transactionNotSupported();
        return this.commandExecutor.execute(config, new Command<String>(){

            @Override
            public String execute(CommandContext commandContext) {
                DbSqlSessionFactory dbSqlSessionFactory = (DbSqlSessionFactory)((Object)commandContext.getSessionFactories().get(DbSqlSession.class));
                DbSqlSession dbSqlSession = new DbSqlSession(dbSqlSessionFactory, connection, catalog, schema);
                commandContext.getSessions().put(DbSqlSession.class, dbSqlSession);
                return dbSqlSession.dbSchemaUpdate();
            }
        });
    }

    public <MapperType, ResultType> ResultType executeCustomSql(CustomSqlExecution<MapperType, ResultType> customSqlExecution) {
        Class mapperClass = customSqlExecution.getMapperClass();
        return (ResultType)this.commandExecutor.execute(new ExecuteCustomSqlCmd<MapperType, ResultType>(mapperClass, customSqlExecution));
    }
}

