/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.editor.dmn.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.dmn.model.Decision;
import org.flowable.dmn.model.DecisionRule;
import org.flowable.dmn.model.DecisionTable;
import org.flowable.dmn.model.DecisionTableOrientation;
import org.flowable.dmn.model.DmnDefinition;
import org.flowable.dmn.model.Expression;
import org.flowable.dmn.model.HitPolicy;
import org.flowable.dmn.model.InputClause;
import org.flowable.dmn.model.LiteralExpression;
import org.flowable.dmn.model.OutputClause;
import org.flowable.dmn.model.RuleInputClauseContainer;
import org.flowable.dmn.model.RuleOutputClauseContainer;
import org.flowable.dmn.model.UnaryTests;
import org.flowable.editor.dmn.converter.DmnJsonConverterUtil;

public class DmnJsonConverter {
    public static final String MODEL_NAMESPACE = "http://flowable.org/dmn";
    public static final String URI_JSON = "http://www.ecma-international.org/ecma-404/";
    protected ObjectMapper objectMapper = new ObjectMapper();

    public DmnDefinition convertToDmn(JsonNode modelNode, String modelId, int modelVersion, Date lastUpdated) {
        modelNode = DmnJsonConverterUtil.migrateModel(modelNode, this.objectMapper);
        DmnDefinition definition = new DmnDefinition();
        definition.setId("definition_" + modelId);
        definition.setName(DmnJsonConverterUtil.getValueAsString("name", modelNode));
        definition.setNamespace(MODEL_NAMESPACE);
        definition.setTypeLanguage(URI_JSON);
        Decision decision = new Decision();
        decision.setId(DmnJsonConverterUtil.getValueAsString("key", modelNode));
        decision.setName(DmnJsonConverterUtil.getValueAsString("name", modelNode));
        decision.setDescription(DmnJsonConverterUtil.getValueAsString("description", modelNode));
        definition.addDecision(decision);
        DecisionTable decisionTable = new DecisionTable();
        decisionTable.setId("decisionTable_" + DmnJsonConverterUtil.getValueAsString("id", modelNode));
        if (modelNode.has("hitIndicator")) {
            decisionTable.setHitPolicy(HitPolicy.get((String)DmnJsonConverterUtil.getValueAsString("hitIndicator", modelNode)));
        } else {
            decisionTable.setHitPolicy(HitPolicy.FIRST);
        }
        decisionTable.setPreferredOrientation(DecisionTableOrientation.RULE_AS_ROW);
        decision.setExpression((Expression)decisionTable);
        this.processDecisionTable(modelNode, definition, decisionTable);
        return definition;
    }

    public ObjectNode convertToJson(DmnDefinition definition) {
        ObjectNode modelNode = this.objectMapper.createObjectNode();
        Decision firstDecision = (Decision)definition.getDecisions().get(0);
        DecisionTable decisionTable = (DecisionTable)firstDecision.getExpression();
        modelNode.put("id", definition.getId());
        modelNode.put("key", firstDecision.getId());
        modelNode.put("name", definition.getName());
        modelNode.put("description", definition.getDescription());
        modelNode.put("hitIndicator", decisionTable.getHitPolicy().name());
        ArrayNode inputExpressionsNode = this.objectMapper.createArrayNode();
        for (Object clause : decisionTable.getInputs()) {
            LiteralExpression inputExpression = clause.getInputExpression();
            ObjectNode inputExpressionNode = this.objectMapper.createObjectNode();
            inputExpressionNode.put("id", inputExpression.getId());
            inputExpressionNode.put("type", inputExpression.getTypeRef());
            inputExpressionNode.put("label", inputExpression.getLabel());
            inputExpressionNode.put("variableId", inputExpression.getText());
            inputExpressionsNode.add((JsonNode)inputExpressionNode);
        }
        modelNode.set("inputExpressions", (JsonNode)inputExpressionsNode);
        ArrayNode outputExpressionsNode = this.objectMapper.createArrayNode();
        for (OutputClause clause : decisionTable.getOutputs()) {
            ObjectNode outputExpressionNode = this.objectMapper.createObjectNode();
            outputExpressionNode.put("id", clause.getId());
            outputExpressionNode.put("type", clause.getTypeRef());
            outputExpressionNode.put("label", clause.getLabel());
            outputExpressionNode.put("variableId", clause.getName());
            outputExpressionsNode.add((JsonNode)outputExpressionNode);
        }
        modelNode.set("outputExpressions", (JsonNode)outputExpressionsNode);
        ArrayNode rulesNode = this.objectMapper.createArrayNode();
        for (DecisionRule rule : decisionTable.getRules()) {
            ObjectNode ruleNode = this.objectMapper.createObjectNode();
            for (RuleInputClauseContainer ruleClauseContainer : rule.getInputEntries()) {
                InputClause inputClause = ruleClauseContainer.getInputClause();
                UnaryTests inputEntry = ruleClauseContainer.getInputEntry();
                ruleNode.put(inputClause.getInputExpression().getId(), inputEntry.getText());
            }
            for (RuleInputClauseContainer ruleClauseContainer : rule.getOutputEntries()) {
                OutputClause outputClause = ruleClauseContainer.getOutputClause();
                LiteralExpression outputEntry = ruleClauseContainer.getOutputEntry();
                ruleNode.put(outputClause.getId(), outputEntry.getText());
            }
            rulesNode.add((JsonNode)ruleNode);
        }
        modelNode.set("rules", (JsonNode)rulesNode);
        return modelNode;
    }

    protected void processDecisionTable(JsonNode modelNode, DmnDefinition definition, DecisionTable decisionTable) {
        if (definition == null || decisionTable == null) {
            return;
        }
        LinkedHashMap<String, InputClause> ruleInputContainerMap = new LinkedHashMap<String, InputClause>();
        LinkedHashMap<String, OutputClause> ruleOutputContainerMap = new LinkedHashMap<String, OutputClause>();
        ArrayList<String> complexExpressionIds = new ArrayList<String>();
        this.processInputExpressions(modelNode, ruleInputContainerMap, decisionTable);
        this.processOutputExpressions(modelNode, ruleOutputContainerMap, complexExpressionIds, decisionTable);
        this.processRules(modelNode, ruleInputContainerMap, ruleOutputContainerMap, complexExpressionIds, decisionTable);
        for (InputClause inputClause : decisionTable.getInputs()) {
            if (!StringUtils.isEmpty((CharSequence)inputClause.getInputExpression().getTypeRef())) continue;
            inputClause.getInputExpression().setTypeRef("string");
        }
        for (OutputClause outputClause : decisionTable.getOutputs()) {
            if (!StringUtils.isEmpty((CharSequence)outputClause.getTypeRef())) continue;
            outputClause.setTypeRef("string");
        }
    }

    protected void processInputExpressions(JsonNode modelNode, Map<String, InputClause> ruleInputContainerMap, DecisionTable decisionTable) {
        JsonNode inputExpressions = modelNode.get("inputExpressions");
        if (inputExpressions != null && !inputExpressions.isNull()) {
            for (JsonNode inputExpressionNode : inputExpressions) {
                InputClause inputClause = new InputClause();
                inputClause.setLabel(DmnJsonConverterUtil.getValueAsString("label", inputExpressionNode));
                String inputExpressionId = DmnJsonConverterUtil.getValueAsString("id", inputExpressionNode);
                LiteralExpression inputExpression = new LiteralExpression();
                inputExpression.setId("inputExpression_" + inputExpressionId);
                inputExpression.setTypeRef(DmnJsonConverterUtil.getValueAsString("type", inputExpressionNode));
                inputExpression.setLabel(DmnJsonConverterUtil.getValueAsString("label", inputExpressionNode));
                inputExpression.setText(DmnJsonConverterUtil.getValueAsString("variableId", inputExpressionNode));
                inputClause.setInputExpression(inputExpression);
                if (inputExpressionNode.get("entries") != null && !inputExpressionNode.get("entries").isNull() && inputExpressionNode.get("entries").isArray() && inputExpressionNode.get("entries").size() > 0) {
                    UnaryTests inputValues = new UnaryTests();
                    ArrayList<String> inputEntries = new ArrayList<String>();
                    for (JsonNode entriesNode : inputExpressionNode.get("entries")) {
                        inputEntries.add(entriesNode.asText());
                    }
                    inputValues.setTextValues(inputEntries);
                    inputClause.setInputValues(inputValues);
                }
                ruleInputContainerMap.put(inputExpressionId, inputClause);
                decisionTable.addInput(inputClause);
            }
        }
    }

    protected void processOutputExpressions(JsonNode modelNode, Map<String, OutputClause> ruleOutputContainerMap, List<String> complexExpressionIds, DecisionTable decisionTable) {
        JsonNode outputExpressions = modelNode.get("outputExpressions");
        if (outputExpressions != null && !outputExpressions.isNull()) {
            for (JsonNode outputExpressionNode : outputExpressions) {
                OutputClause outputClause = new OutputClause();
                String outputExpressionId = DmnJsonConverterUtil.getValueAsString("id", outputExpressionNode);
                String outputClauseId = "outputExpression_" + outputExpressionId;
                outputClause.setId(outputClauseId);
                outputClause.setLabel(DmnJsonConverterUtil.getValueAsString("label", outputExpressionNode));
                outputClause.setName(DmnJsonConverterUtil.getValueAsString("variableId", outputExpressionNode));
                outputClause.setTypeRef(DmnJsonConverterUtil.getValueAsString("type", outputExpressionNode));
                if (outputExpressionNode.get("entries") != null && !outputExpressionNode.get("entries").isNull() && outputExpressionNode.get("entries").isArray() && outputExpressionNode.get("entries").size() > 0) {
                    UnaryTests outputValues = new UnaryTests();
                    ArrayList<String> outputEntries = new ArrayList<String>();
                    for (JsonNode entriesNode : outputExpressionNode.get("entries")) {
                        outputEntries.add(entriesNode.asText());
                    }
                    outputValues.setTextValues(outputEntries);
                    outputClause.setOutputValues(outputValues);
                }
                if (outputExpressionNode.get("complexExpression") != null && !outputExpressionNode.get("complexExpression").isNull() && outputExpressionNode.get("complexExpression").asBoolean()) {
                    complexExpressionIds.add(outputExpressionId);
                }
                ruleOutputContainerMap.put(outputExpressionId, outputClause);
                decisionTable.addOutput(outputClause);
            }
        }
    }

    protected void processRules(JsonNode modelNode, Map<String, InputClause> ruleInputContainerMap, Map<String, OutputClause> ruleOutputContainerMap, List<String> complexExpressionIds, DecisionTable decisionTable) {
        JsonNode rules = modelNode.get("rules");
        if (rules != null && !rules.isNull()) {
            int ruleCounter = 1;
            for (JsonNode ruleNode : rules) {
                DecisionRule rule = new DecisionRule();
                for (String id : ruleInputContainerMap.keySet()) {
                    JsonNode expressionValueNode;
                    String operatorId = id + "_operator";
                    String expressionId = id + "_expression";
                    RuleInputClauseContainer ruleInputClauseContainer = new RuleInputClauseContainer();
                    ruleInputClauseContainer.setInputClause(ruleInputContainerMap.get(id));
                    UnaryTests inputEntry = new UnaryTests();
                    inputEntry.setId("inputEntry_" + id + "_" + ruleCounter);
                    JsonNode operatorValueNode = ruleNode.get(operatorId);
                    String operatorValue = null;
                    if (operatorValueNode != null && !operatorValueNode.isNull()) {
                        operatorValue = operatorValueNode.asText();
                    }
                    String expressionValue = (expressionValueNode = ruleNode.get(expressionId)) == null || expressionValueNode.isNull() ? "-" : expressionValueNode.asText();
                    StringBuilder stringBuilder = new StringBuilder();
                    if (StringUtils.isNotEmpty((CharSequence)operatorValue) && !"==".equals(operatorValue)) {
                        stringBuilder = new StringBuilder(operatorValue);
                        stringBuilder.append(" ");
                    }
                    if ("string".equals(ruleInputClauseContainer.getInputClause().getInputExpression().getTypeRef()) && !"-".equals(expressionValue)) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append("\"");
                        } else {
                            stringBuilder.append("\"");
                        }
                        stringBuilder.append(expressionValue);
                        stringBuilder.append("\"");
                    } else if ("date".equals(ruleInputClauseContainer.getInputClause().getInputExpression().getTypeRef()) && !"-".equals(expressionValue) && StringUtils.isNotEmpty((CharSequence)expressionValue)) {
                        stringBuilder.append("fn_date('");
                        stringBuilder.append(expressionValue);
                        stringBuilder.append("')");
                    } else {
                        stringBuilder.append(expressionValue);
                    }
                    inputEntry.setText(stringBuilder.toString());
                    ruleInputClauseContainer.setInputEntry(inputEntry);
                    rule.addInputEntry(ruleInputClauseContainer);
                }
                for (String id : ruleOutputContainerMap.keySet()) {
                    RuleOutputClauseContainer ruleOutputClauseContainer = new RuleOutputClauseContainer();
                    ruleOutputClauseContainer.setOutputClause(ruleOutputContainerMap.get(id));
                    LiteralExpression outputEntry = new LiteralExpression();
                    outputEntry.setId("outputEntry_" + id + "_" + ruleCounter);
                    if (ruleNode.has(id)) {
                        JsonNode expressionValueNode = ruleNode.get(id);
                        String expressionValue = expressionValueNode == null || expressionValueNode.isNull() ? "" : expressionValueNode.asText();
                        if (complexExpressionIds.contains(id)) {
                            outputEntry.setText(expressionValue);
                        } else if ("string".equals(ruleOutputClauseContainer.getOutputClause().getTypeRef())) {
                            outputEntry.setText("\"" + expressionValue + "\"");
                        } else if ("date".equals(ruleOutputClauseContainer.getOutputClause().getTypeRef()) && StringUtils.isNotEmpty((CharSequence)expressionValue)) {
                            outputEntry.setText("fn_date('" + expressionValue + "')");
                        } else {
                            outputEntry.setText(expressionValue);
                        }
                    } else {
                        outputEntry.setText("");
                    }
                    ruleOutputClauseContainer.setOutputEntry(outputEntry);
                    rule.addOutputEntry(ruleOutputClauseContainer);
                }
                ++ruleCounter;
                decisionTable.addRule(rule);
            }
        }
    }
}

