/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.descriptors.changetracking.MapChangeEvent;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.descriptors.changetracking.AttributeChangeListener;
import org.eclipse.persistence.internal.descriptors.changetracking.ObjectChangeListener;
import org.eclipse.persistence.internal.expressions.SQLDeleteStatement;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.indirection.TransparentIndirectionPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.MappedKeyMapContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DirectMapChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;
import org.eclipse.persistence.mappings.foundation.MapComponentMapping;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.DirectReadQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.changesets.ChangeRecord;

public class DirectMapMapping
extends DirectCollectionMapping
implements MapComponentMapping {
    public DirectMapMapping() {
        DataReadQuery query = new DataReadQuery();
        this.selectionQuery = query;
        MappedKeyMapContainerPolicy mapPolicy = new MappedKeyMapContainerPolicy(ClassConstants.Hashtable_Class);
        mapPolicy.setValueMapping(this);
        this.containerPolicy = mapPolicy;
        this.isListOrderFieldSupported = false;
    }

    @Override
    public void setContainerPolicy(ContainerPolicy containerPolicy) {
        super.setContainerPolicy(containerPolicy);
        ((MappedKeyMapContainerPolicy)containerPolicy).setValueMapping(this);
    }

    private MappedKeyMapContainerPolicy getMappedKeyMapContainerPolicy() {
        return (MappedKeyMapContainerPolicy)this.containerPolicy;
    }

    public Converter getKeyConverter() {
        return this.getMappedKeyMapContainerPolicy().getKeyConverter();
    }

    public void setKeyConverter(Converter keyConverter) {
        this.getMappedKeyMapContainerPolicy().setKeyConverter(keyConverter, this);
    }

    public void setKeyConverterClassName(String keyConverterClassName) {
        this.getMappedKeyMapContainerPolicy().setKeyConverterClassName(keyConverterClassName, this);
    }

    public void addToCollectionChangeRecord(Object newKey, Object newValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) throws DescriptorException {
        DirectMapChangeRecord collectionChangeRecord = (DirectMapChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new DirectMapChangeRecord(objectChangeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            objectChangeSet.addChange(collectionChangeRecord);
        }
        collectionChangeRecord.addAdditionChange(newKey, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object buildCloneForPartObject(Object attributeValue, Object original, CacheKey cacheKey, Object clone, AbstractSession cloningSession, Integer refreshCascade, boolean isExisting, boolean isFromSharedCache) {
        if (attributeValue == null) {
            return this.containerPolicy.containerInstance(1);
        }
        Object clonedAttributeValue = this.containerPolicy.containerInstance(this.containerPolicy.sizeFor(attributeValue));
        Object temporaryCollection = null;
        Object object = attributeValue;
        synchronized (object) {
            temporaryCollection = this.containerPolicy.cloneFor(attributeValue);
        }
        Object keysIterator = this.containerPolicy.iteratorFor(temporaryCollection);
        while (this.containerPolicy.hasNext(keysIterator)) {
            Map.Entry entry = (Map.Entry)this.containerPolicy.nextEntry(keysIterator, cloningSession);
            Object cloneKey = this.containerPolicy.buildCloneForKey(entry.getKey(), clone, cacheKey, null, cloningSession, isExisting, isFromSharedCache);
            Object cloneValue = this.buildElementClone(entry.getValue(), clone, cacheKey, refreshCascade, cloningSession, isExisting, isFromSharedCache);
            this.containerPolicy.addInto(cloneKey, cloneValue, clonedAttributeValue, cloningSession);
        }
        return clonedAttributeValue;
    }

    @Override
    public void calculateDeferredChanges(org.eclipse.persistence.internal.sessions.ChangeRecord changeRecord, AbstractSession session) {
        DirectMapChangeRecord collectionRecord = (DirectMapChangeRecord)changeRecord;
        this.compareCollectionsForChange(collectionRecord.getOriginalCollection(), collectionRecord.getLatestCollection(), collectionRecord, session);
    }

    @Override
    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map newObjects, Map unregisteredExistingObjects, Map visitedObjects, UnitOfWorkImpl uow, Set cascadeErrors) {
        Object values;
        if (this.containerPolicy.isMappedKeyMapPolicy() && (values = this.getAttributeValueFromObject(object)) != null) {
            Object iterator = this.containerPolicy.iteratorFor(values);
            while (this.containerPolicy.hasNext(iterator)) {
                Object wrappedObject = this.containerPolicy.nextEntry(iterator, uow);
                this.containerPolicy.cascadeDiscoverAndPersistUnregisteredNewObjects(wrappedObject, newObjects, unregisteredExistingObjects, visitedObjects, uow, cascadeErrors);
            }
        }
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        Object values;
        if (this.containerPolicy.isMappedKeyMapPolicy() && (values = this.getAttributeValueFromObject(object)) != null) {
            Object iterator = this.containerPolicy.iteratorFor(values);
            while (this.containerPolicy.hasNext(iterator)) {
                Object wrappedObject = this.containerPolicy.nextEntry(iterator, uow);
                this.containerPolicy.cascadePerformRemoveIfRequired(wrappedObject, uow, visitedObjects);
            }
        }
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        Object values;
        if (this.containerPolicy.isMappedKeyMapPolicy() && (values = this.getAttributeValueFromObject(object)) != null) {
            Object iterator = this.containerPolicy.iteratorFor(values);
            while (this.containerPolicy.hasNext(iterator)) {
                Object wrappedObject = this.containerPolicy.nextEntry(iterator, uow);
                this.containerPolicy.cascadeRegisterNewIfRequired(wrappedObject, uow, visitedObjects);
            }
        }
    }

    @Override
    public void compareCollectionsForChange(Object oldCollection, Object newCollection, org.eclipse.persistence.internal.sessions.ChangeRecord changeRecord, AbstractSession session) {
        HashMap originalKeyValues = new HashMap(10);
        HashMap cloneKeyValues = new HashMap(10);
        if (oldCollection != null) {
            Map backUpCollection = (Map)oldCollection;
            Object backUpIter = this.containerPolicy.iteratorFor(backUpCollection);
            while (this.containerPolicy.hasNext(backUpIter)) {
                Map.Entry entry = (Map.Entry)this.containerPolicy.nextEntry(backUpIter, session);
                originalKeyValues.put(entry.getKey(), backUpCollection.get(entry.getKey()));
            }
        }
        Map cloneObjectCollection = (Map)newCollection;
        Object cloneIter = this.containerPolicy.iteratorFor(cloneObjectCollection);
        while (this.containerPolicy.hasNext(cloneIter)) {
            Map.Entry wrappedFirstObject = (Map.Entry)this.containerPolicy.nextEntry(cloneIter, session);
            Object firstValue = wrappedFirstObject.getValue();
            Object firstKey = wrappedFirstObject.getKey();
            Object backupValue = originalKeyValues.get(firstKey);
            if (!originalKeyValues.containsKey(firstKey)) {
                cloneKeyValues.put(firstKey, cloneObjectCollection.get(firstKey));
                continue;
            }
            if (backupValue == null && firstValue != null || !backupValue.equals(firstValue)) {
                cloneKeyValues.put(firstKey, cloneObjectCollection.get(firstKey));
                continue;
            }
            originalKeyValues.remove(firstKey);
        }
        ((DirectMapChangeRecord)changeRecord).clearChanges();
        ((DirectMapChangeRecord)changeRecord).addAdditionChange(cloneKeyValues);
        ((DirectMapChangeRecord)changeRecord).addRemoveChange(originalKeyValues);
        ((DirectMapChangeRecord)changeRecord).setIsDeferred(false);
        ((DirectMapChangeRecord)changeRecord).setLatestCollection(null);
    }

    @Override
    public org.eclipse.persistence.internal.sessions.ChangeRecord compareForChange(Object clone, Object backUp, ObjectChangeSet owner, AbstractSession session) {
        Object cloneAttribute = null;
        Object backUpAttribute = null;
        cloneAttribute = this.getAttributeValueFromObject(clone);
        if (cloneAttribute != null && !this.getIndirectionPolicy().objectIsInstantiated(cloneAttribute)) {
            return null;
        }
        Map cloneObjectCollection = (Map)this.getRealCollectionAttributeValueFromObject(clone, session);
        new HashMap(10);
        new HashMap(10);
        Map backUpCollection = null;
        if (!owner.isNew()) {
            backUpAttribute = this.getAttributeValueFromObject(backUp);
            if (backUpAttribute == null && cloneAttribute == null) {
                return null;
            }
            backUpCollection = (Map)this.getRealCollectionAttributeValueFromObject(backUp, session);
        }
        DirectMapChangeRecord changeRecord = new DirectMapChangeRecord(owner);
        changeRecord.setAttribute(this.getAttributeName());
        changeRecord.setMapping(this);
        this.compareCollectionsForChange(backUpCollection, cloneObjectCollection, changeRecord, session);
        if (changeRecord.hasChanges()) {
            changeRecord.setOriginalCollection(backUpCollection);
            return changeRecord;
        }
        return null;
    }

    @Override
    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        Object firstObjectMap = this.getRealCollectionAttributeValueFromObject(firstObject, session);
        Object secondObjectMap = this.getRealCollectionAttributeValueFromObject(secondObject, session);
        return this.getMappedKeyMapContainerPolicy().compareContainers(firstObjectMap, secondObjectMap);
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        if (this.getDirectKeyField() != null) {
            this.getDirectKeyField().convertClassNamesToClasses(classLoader);
        }
    }

    @Override
    public Object createMapComponentFromRow(AbstractRecord dbRow, ObjectBuildingQuery query, CacheKey parentCacheKey, AbstractSession session, boolean isTargetProtected) {
        Object key = dbRow.get(this.getDirectField());
        if (this.getValueConverter() != null) {
            key = this.getValueConverter().convertDataValueToObjectValue(key, session);
        }
        return key;
    }

    public DatabaseField getDirectKeyField() {
        return this.getMappedKeyMapContainerPolicy().getDirectKeyField(null);
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        this.getMappedKeyMapContainerPolicy().setDescriptorForKeyMapping(this.getDescriptor());
        super.initialize(session);
        if (this.getValueConverter() != null) {
            this.getValueConverter().initialize(this, session);
        }
    }

    @Override
    protected void initializeDeleteQuery(AbstractSession session) {
        if (!this.getDeleteQuery().hasSessionName()) {
            this.getDeleteQuery().setSessionName(session.getName());
        }
        if (this.hasCustomDeleteQuery()) {
            return;
        }
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression directKeyExp = null;
        List<DatabaseField> identityFields = this.getContainerPolicy().getIdentityFieldsForMapKey();
        for (DatabaseField field : identityFields) {
            Expression fieldExpression = ((Expression)builder).getField(field).equal(builder.getParameter(field));
            directKeyExp = directKeyExp == null ? fieldExpression : directKeyExp.and(fieldExpression);
        }
        Expression expression = null;
        SQLDeleteStatement statement = new SQLDeleteStatement();
        int index = 0;
        while (index < this.getReferenceKeyFields().size()) {
            DatabaseField referenceKey = this.getReferenceKeyFields().get(index);
            DatabaseField sourceKey = this.getSourceKeyFields().get(index);
            Expression subExp1 = ((Expression)builder).getField(referenceKey);
            Expression subExp2 = builder.getParameter(sourceKey);
            Expression subExpression = subExp1.equal(subExp2);
            expression = subExpression.and(expression);
            ++index;
        }
        expression = expression.and(directKeyExp);
        statement.setWhereClause(expression);
        statement.setTable(this.getReferenceTable());
        this.getDeleteQuery().setSQLStatement(statement);
    }

    @Override
    protected void initializeInsertQuery(AbstractSession session) {
        super.initializeInsertQuery(session);
        this.getContainerPolicy().addFieldsForMapKey(this.getInsertQuery().getModifyRow());
    }

    @Override
    protected void initializeSelectionStatement(AbstractSession session) {
        if (this.selectionQuery.isReadAllQuery()) {
            ((ReadAllQuery)this.selectionQuery).addAdditionalField(this.getDirectField().clone());
        } else {
            SQLSelectStatement statement = (SQLSelectStatement)this.selectionQuery.getSQLStatement();
            statement.addTable(this.getReferenceTable());
            statement.addField(this.getDirectField().clone());
            this.getContainerPolicy().addAdditionalFieldsToQuery(this.selectionQuery, this.getAdditionalFieldsBaseExpression(this.selectionQuery));
            statement.normalize(session, null);
        }
        if (this.selectionQuery.isDirectReadQuery()) {
            ((DirectReadQuery)this.selectionQuery).setResultType(0);
        }
    }

    @Override
    public void iterateOnRealAttributeValue(DescriptorIterator iterator, Object realAttributeValue) {
        super.iterateOnRealAttributeValue(iterator, realAttributeValue);
        ContainerPolicy cp = this.getContainerPolicy();
        if (realAttributeValue != null && !iterator.shouldIterateOnPrimitives()) {
            Object iter = cp.iteratorFor(realAttributeValue);
            while (cp.hasNext(iter)) {
                Object wrappedObject = cp.nextEntry(iter, iterator.getSession());
                cp.iterateOnMapKey(iterator, wrappedObject);
            }
        }
    }

    @Override
    public void iterateOnElement(DescriptorIterator iterator, Object element) {
        super.iterateOnElement(iterator, element);
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(element);
        while (cp.hasNext(iter)) {
            Object wrappedObject = cp.nextEntry(iter, iterator.getSession());
            cp.iterateOnMapKey(iterator, wrappedObject);
        }
    }

    @Override
    public boolean isDirectMapMapping() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeChangesIntoObject(Object target, org.eclipse.persistence.internal.sessions.ChangeRecord changeRecord, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        if (this.descriptor.getCachePolicy().isProtectedIsolation() && !this.isCacheable && !targetSession.isProtectedSession()) {
            this.setAttributeValueInObject(target, this.indirectionPolicy.buildIndirectObject(new ValueHolder(null)));
            return;
        }
        Map valueOfTarget = null;
        AbstractSession session = mergeManager.getSession();
        HashMap addObjects = ((DirectMapChangeRecord)changeRecord).getAddObjects();
        HashMap removeObjects = ((DirectMapChangeRecord)changeRecord).getRemoveObjects();
        valueOfTarget = this.isAttributeValueInstantiated(target) && !changeRecord.getOwner().isNew() ? (Map)this.getRealCollectionAttributeValueFromObject(target, session) : (Map)this.containerPolicy.containerInstance(addObjects.size());
        if (!this.isAttributeValueInstantiated(target)) {
            if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                return;
            }
            Object valueOfSource = this.getRealCollectionAttributeValueFromObject(source, session);
            Object iterator = this.containerPolicy.iteratorFor(valueOfSource);
            while (this.containerPolicy.hasNext(iterator)) {
                Map.Entry entry = (Map.Entry)this.containerPolicy.nextEntry(iterator, session);
                this.containerPolicy.addInto(entry.getKey(), entry.getValue(), (Object)valueOfTarget, session);
            }
        } else {
            Object synchronizationTarget = valueOfTarget;
            if (valueOfTarget instanceof IndirectCollection) {
                synchronizationTarget = ((IndirectCollection)((Object)valueOfTarget)).getDelegateObject();
            }
            Map map = synchronizationTarget;
            synchronized (map) {
                for (Object keyToRemove : removeObjects.keySet()) {
                    this.containerPolicy.removeFrom(keyToRemove, null, valueOfTarget, session);
                }
                for (Object keyToAdd : addObjects.keySet()) {
                    Object nextItem = addObjects.get(keyToAdd);
                    if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                        if (this.containerPolicy.contains(nextItem, (Object)valueOfTarget, session)) continue;
                        this.containerPolicy.addInto(keyToAdd, nextItem, (Object)valueOfTarget, session);
                        continue;
                    }
                    this.containerPolicy.addInto(keyToAdd, nextItem, (Object)valueOfTarget, session);
                }
            }
        }
        this.setRealAttributeValueInObject(target, valueOfTarget);
    }

    @Override
    public void mergeIntoObject(Object target, boolean isTargetUnInitialized, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        DirectMapChangeRecord changeRecord;
        ObjectChangeSet changeSet;
        Map.Entry entry;
        if (this.descriptor.getCachePolicy().isProtectedIsolation() && !this.isCacheable && !targetSession.isProtectedSession()) {
            this.setAttributeValueInObject(target, this.indirectionPolicy.buildIndirectObject(new ValueHolder(null)));
            return;
        }
        if (isTargetUnInitialized && mergeManager.shouldMergeWorkingCopyIntoOriginal() && !this.isAttributeValueInstantiated(source)) {
            this.setAttributeValueInObject(target, this.getIndirectionPolicy().getOriginalIndirectionObject(this.getAttributeValueFromObject(source), targetSession));
            return;
        }
        if (!this.shouldMergeCascadeReference(mergeManager)) {
            return;
        }
        if (mergeManager.shouldRefreshRemoteObject() && this.usesIndirection()) {
            this.mergeRemoteValueHolder(target, source, mergeManager);
            return;
        }
        if (mergeManager.isForRefresh() ? !this.isAttributeValueInstantiated(target) : !this.isAttributeValueInstantiated(source)) {
            return;
        }
        Map valueOfSource = (Map)this.getRealCollectionAttributeValueFromObject(source, mergeManager.getSession());
        Object valueOfTarget = this.getRealCollectionAttributeValueFromObject(target, mergeManager.getSession());
        Object newContainer = this.containerPolicy.containerInstance(this.containerPolicy.sizeFor(valueOfSource));
        boolean fireChangeEvents = false;
        if (this.getDescriptor().getObjectChangePolicy().isObjectChangeTrackingPolicy() && target instanceof ChangeTracker && ((ChangeTracker)target)._persistence_getPropertyChangeListener() != null) {
            fireChangeEvents = true;
            Object iterator = this.containerPolicy.iteratorFor(valueOfTarget);
            while (this.containerPolicy.hasNext(iterator)) {
                entry = (Map.Entry)this.containerPolicy.nextEntry(iterator, mergeManager.getSession());
                ((ObjectChangeListener)((ChangeTracker)target)._persistence_getPropertyChangeListener()).internalPropertyChange(new MapChangeEvent(target, this.getAttributeName(), valueOfTarget, entry.getKey(), entry.getValue(), CollectionChangeEvent.REMOVE, false));
            }
            if (newContainer instanceof ChangeTracker) {
                ((ChangeTracker)newContainer)._persistence_setPropertyChangeListener(((ChangeTracker)target)._persistence_getPropertyChangeListener());
            }
            if (valueOfTarget instanceof ChangeTracker) {
                ((ChangeTracker)valueOfTarget)._persistence_setPropertyChangeListener(null);
            }
        }
        valueOfTarget = newContainer;
        Object sourceValuesIterator = this.containerPolicy.iteratorFor(valueOfSource);
        while (this.containerPolicy.hasNext(sourceValuesIterator)) {
            entry = (Map.Entry)this.containerPolicy.nextEntry(sourceValuesIterator, mergeManager.getSession());
            if (fireChangeEvents) {
                ((ObjectChangeListener)((ChangeTracker)target)._persistence_getPropertyChangeListener()).internalPropertyChange(new MapChangeEvent(target, this.getAttributeName(), valueOfTarget, entry.getKey(), entry.getValue(), CollectionChangeEvent.ADD, false));
            }
            this.containerPolicy.addInto(entry.getKey(), entry.getValue(), valueOfTarget, mergeManager.getSession());
        }
        if (fireChangeEvents && this.getDescriptor().getObjectChangePolicy().isAttributeChangeTrackingPolicy() && (changeSet = ((AttributeChangeListener)((ChangeTracker)target)._persistence_getPropertyChangeListener()).getObjectChangeSet()) != null && (changeRecord = (DirectMapChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName())) != null) {
            if (!changeRecord.isDeferred()) {
                if (!changeRecord.hasChanges()) {
                    changeSet.removeChange(this.getAttributeName());
                }
            } else {
                changeRecord.setLatestCollection(valueOfTarget);
            }
        }
        this.setRealAttributeValueInObject(target, valueOfTarget);
    }

    @Override
    public void performDataModificationEvent(Object[] event, AbstractSession session) throws DatabaseException, DescriptorException {
        super.performDataModificationEvent(event, session);
        if (event[0] == "delete" && this.containerPolicy.shouldIncludeKeyInDeleteEvent()) {
            session.deleteObject(event[3]);
        }
    }

    @Override
    public void postCalculateChanges(ChangeRecord changeRecord, UnitOfWorkImpl uow) {
        DirectMapChangeRecord mapChangeRecord = (DirectMapChangeRecord)changeRecord;
        for (Map.Entry entry : mapChangeRecord.getRemoveObjects().entrySet()) {
            this.containerPolicy.postCalculateChanges(entry.getKey(), entry.getValue(), this.referenceDescriptor, this, uow);
        }
    }

    @Override
    public void postInsert(WriteObjectQuery query) throws DatabaseException {
        DatabaseRecord databaseRow = new DatabaseRecord();
        if (this.isReadOnly()) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        if (this.containerPolicy.isEmpty(objects)) {
            return;
        }
        this.prepareTranslationRow(query.getTranslationRow(), query.getObject(), query.getDescriptor(), query.getSession());
        int index = 0;
        while (index < this.getReferenceKeyFields().size()) {
            DatabaseField referenceKey = this.getReferenceKeyFields().get(index);
            DatabaseField sourceKey = this.getSourceKeyFields().get(index);
            Object sourceKeyValue = query.getTranslationRow().get(sourceKey);
            databaseRow.put(referenceKey, sourceKeyValue);
            ++index;
        }
        Object keyIter = this.containerPolicy.iteratorFor(objects);
        while (this.containerPolicy.hasNext(keyIter)) {
            Map.Entry entry = (Map.Entry)this.containerPolicy.nextEntry(keyIter, query.getSession());
            Object value = this.getFieldValue(entry.getValue(), query.getSession());
            databaseRow.put(this.getDirectField(), value);
            ContainerPolicy.copyMapDataToRow(this.getContainerPolicy().getKeyMappingDataForWriteQuery(entry, query.getSession()), databaseRow);
            if (query.shouldCascadeOnlyDependentParts()) {
                Object[] event = new Object[]{"insert", this.getInsertQuery(), databaseRow.clone()};
                query.getSession().getCommitManager().addDataModificationEvent(this, event);
            } else {
                query.getSession().executeQuery((DatabaseQuery)this.getInsertQuery(), databaseRow);
            }
            this.getContainerPolicy().propogatePostInsert(query, entry);
        }
    }

    @Override
    protected void postUpdateWithChangeSet(WriteObjectQuery writeQuery) throws DatabaseException {
        AbstractRecord thisRow;
        ObjectChangeSet changeSet = writeQuery.getObjectChangeSet();
        DirectMapChangeRecord changeRecord = (DirectMapChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (changeRecord == null) {
            return;
        }
        int index = 0;
        while (index < this.getReferenceKeyFields().size()) {
            DatabaseField referenceKey = this.getReferenceKeyFields().get(index);
            DatabaseField sourceKey = this.getSourceKeyFields().get(index);
            Object sourceKeyValue = writeQuery.getTranslationRow().get(sourceKey);
            writeQuery.getTranslationRow().put(referenceKey, sourceKeyValue);
            ++index;
        }
        for (Map.Entry entry : changeRecord.getRemoveObjects().entrySet()) {
            thisRow = writeQuery.getTranslationRow().clone();
            ContainerPolicy.copyMapDataToRow(this.containerPolicy.getKeyMappingDataForWriteQuery(entry, writeQuery.getSession()), thisRow);
            Object[] event = null;
            if (this.containerPolicy.shouldIncludeKeyInDeleteEvent()) {
                event = new Object[4];
                event[3] = this.containerPolicy.keyFromEntry(entry);
            } else {
                event = new Object[]{"delete", this.getDeleteQuery(), thisRow};
            }
            writeQuery.getSession().getCommitManager().addDataModificationEvent(this, event);
        }
        for (Map.Entry entry : changeRecord.getAddObjects().entrySet()) {
            thisRow = writeQuery.getTranslationRow().clone();
            Object value = changeRecord.getAddObjects().get(entry.getKey());
            value = this.getFieldValue(value, writeQuery.getSession());
            ContainerPolicy.copyMapDataToRow(this.containerPolicy.getKeyMappingDataForWriteQuery(entry, writeQuery.getSession()), thisRow);
            thisRow.add(this.getDirectField(), value);
            Object[] event = new Object[]{"insert", this.getInsertQuery(), thisRow};
            writeQuery.getSession().getCommitManager().addDataModificationEvent(this, event);
        }
    }

    @Override
    public void preDelete(DeleteObjectQuery query) throws DatabaseException {
        if (this.getContainerPolicy().propagatesEventsToCollection()) {
            Object queryObject = query.getObject();
            Object values = this.getAttributeValueFromObject(queryObject);
            Object iterator = this.containerPolicy.iteratorFor(values);
            while (this.containerPolicy.hasNext(iterator)) {
                Object wrappedObject = this.containerPolicy.nextEntry(iterator, query.getSession());
                this.containerPolicy.propogatePreDelete(query, wrappedObject);
            }
        }
        super.preDelete(query);
    }

    @Override
    protected void initOrRebuildSelectQuery() {
        this.selectionQuery = this.containerPolicy.buildSelectionQueryForDirectCollectionMapping();
    }

    @Override
    public void recordPrivateOwnedRemovals(Object object, UnitOfWorkImpl uow) {
        Iterator it = (Iterator)this.containerPolicy.iteratorFor(this.getRealAttributeValueFromObject(object, uow));
        while (it.hasNext()) {
            Object clone = it.next();
            this.containerPolicy.recordPrivateOwnedRemovals(clone, this.referenceDescriptor, uow);
        }
    }

    protected void removeFromCollectionChangeRecord(Object newKey, Object newValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) throws DescriptorException {
        DirectMapChangeRecord collectionChangeRecord = (DirectMapChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new DirectMapChangeRecord(objectChangeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            objectChangeSet.addChange(collectionChangeRecord);
        }
        collectionChangeRecord.addRemoveChange(newKey, newValue);
    }

    public void setDirectKeyField(DatabaseField keyField) {
        this.getMappedKeyMapContainerPolicy().setKeyField(keyField, this.descriptor);
    }

    public void setDirectKeyFieldClassification(Class fieldType) {
        this.getDirectKeyField().setType(fieldType);
    }

    public void setDirectKeyFieldClassificationName(String fieldTypeName) {
        this.getDirectKeyField().setTypeName(fieldTypeName);
    }

    public void setDirectKeyFieldName(String fieldName) {
        this.setDirectKeyField(new DatabaseField(fieldName));
    }

    @Override
    public void updateChangeRecord(Object clone, Object newValue, Object oldValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) throws DescriptorException {
        DirectMapChangeRecord collectionChangeRecord = (DirectMapChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new DirectMapChangeRecord(objectChangeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            objectChangeSet.addChange(collectionChangeRecord);
        }
        if (collectionChangeRecord.getOriginalCollection() == null) {
            collectionChangeRecord.recreateOriginalCollection(oldValue, uow);
        }
        collectionChangeRecord.setLatestCollection(newValue);
        collectionChangeRecord.setIsDeferred(true);
        objectChangeSet.deferredDetectionRequiredOn(this.getAttributeName());
    }

    @Override
    public void updateCollectionChangeRecord(CollectionChangeEvent event, ObjectChangeSet changeSet, UnitOfWorkImpl uow) {
        if (event != null) {
            Object key = null;
            if (event.getClass().equals(ClassConstants.MapChangeEvent_Class)) {
                key = ((MapChangeEvent)event).getKey();
            }
            if (event.getChangeType() == CollectionChangeEvent.ADD) {
                this.addToCollectionChangeRecord(key, event.getNewValue(), changeSet, uow);
            } else if (event.getChangeType() == CollectionChangeEvent.REMOVE) {
                this.removeFromCollectionChangeRecord(key, event.getNewValue(), changeSet, uow);
            } else {
                throw ValidationException.wrongCollectionChangeEventType(event.getChangeType());
            }
        }
    }

    @Override
    public void useMapClass(Class concreteClass) {
        if (!Helper.classImplementsInterface(concreteClass, ClassConstants.Map_Class)) {
            throw DescriptorException.illegalContainerClass(concreteClass);
        }
        this.containerPolicy.setContainerClass(concreteClass);
    }

    public void useTransparentMap() {
        this.setIndirectionPolicy(new TransparentIndirectionPolicy());
        this.useMapClass(ClassConstants.IndirectMap_Class);
    }

    public void setKeyClass(Class keyClass) {
        TypeConversionConverter converter = new TypeConversionConverter(this);
        converter.setObjectClass(keyClass);
        this.setKeyConverter(converter);
    }

    public Class getKeyClass() {
        if (this.getKeyConverter() == null || !(this.getKeyConverter() instanceof TypeConversionConverter)) {
            return null;
        }
        return ((TypeConversionConverter)this.getKeyConverter()).getObjectClass();
    }

    public void setValueClass(Class valueClass) {
        TypeConversionConverter converter = new TypeConversionConverter(this);
        converter.setObjectClass(valueClass);
        this.setValueConverter(converter);
    }

    @Override
    public void simpleAddToCollectionChangeRecord(Object referenceKey, Object objectToAdd, ObjectChangeSet changeSet, AbstractSession session) {
        DirectMapChangeRecord collectionChangeRecord = (DirectMapChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new DirectMapChangeRecord(changeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            collectionChangeRecord.getAddObjects().put(referenceKey, objectToAdd);
            changeSet.addChange(collectionChangeRecord);
        } else if (collectionChangeRecord.getRemoveObjects().containsKey(referenceKey)) {
            collectionChangeRecord.getRemoveObjects().remove(referenceKey);
        } else {
            collectionChangeRecord.getAddObjects().put(referenceKey, objectToAdd);
        }
    }

    @Override
    public void simpleRemoveFromCollectionChangeRecord(Object referenceKey, Object objectToRemove, ObjectChangeSet changeSet, AbstractSession session) {
        DirectMapChangeRecord collectionChangeRecord = (DirectMapChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new DirectMapChangeRecord(changeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            collectionChangeRecord.getRemoveObjects().put(referenceKey, objectToRemove);
            changeSet.addChange(collectionChangeRecord);
        } else if (collectionChangeRecord.getAddObjects().containsKey(referenceKey)) {
            collectionChangeRecord.getAddObjects().remove(referenceKey);
        } else {
            collectionChangeRecord.getRemoveObjects().put(referenceKey, objectToRemove);
        }
    }

    public Class getValueClass() {
        if (!(this.getValueConverter() instanceof TypeConversionConverter)) {
            return null;
        }
        return ((TypeConversionConverter)this.getValueConverter()).getObjectClass();
    }

    @Override
    protected void executeBatchQuery(DatabaseQuery query, CacheKey parentCacheKey, Map referenceDataByKey, AbstractSession session, AbstractRecord translationRow) {
        List rows = (List)session.executeQuery(query, translationRow);
        MappedKeyMapContainerPolicy mapContainerPolicy = this.getMappedKeyMapContainerPolicy();
        for (AbstractRecord referenceRow : rows) {
            Object referenceKey = null;
            referenceKey = query.isObjectBuildingQuery() ? mapContainerPolicy.buildKey(referenceRow, (ObjectBuildingQuery)query, parentCacheKey, session, true) : mapContainerPolicy.buildKey(referenceRow, null, parentCacheKey, session, true);
            Object referenceValue = referenceRow.get(this.directField);
            Object eachCacheKey = this.extractKeyFromTargetRow(referenceRow, session);
            Object container = referenceDataByKey.get(eachCacheKey);
            if (container == null || container == Helper.NULL_VALUE) {
                container = this.containerPolicy.containerInstance();
                referenceDataByKey.put(eachCacheKey, container);
            }
            if (this.valueConverter != null) {
                referenceValue = this.valueConverter.convertDataValueToObjectValue(referenceValue, query.getSession());
            }
            this.containerPolicy.addInto(referenceKey, referenceValue, container, query.getSession());
        }
    }

    @Override
    protected Object valueFromRowInternalWithJoin(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, CacheKey parentCacheKey, AbstractSession executionSession, boolean isTargetProtected) throws DatabaseException {
        ContainerPolicy policy = this.getContainerPolicy();
        Object value = policy.containerInstance();
        ObjectBuilder objectBuilder = this.getDescriptor().getObjectBuilder();
        Object sourceKey = objectBuilder.extractPrimaryKeyFromRow(row, executionSession);
        List<AbstractRecord> rows = joinManager.getDataResultsByPrimaryKey().get(sourceKey);
        if (rows == null) {
            return this.valueFromRowInternal(row, joinManager, sourceQuery, executionSession);
        }
        HashSet<Object> directValues = new HashSet<Object>();
        Converter valueConverter = this.getValueConverter();
        int size = rows.size();
        int index = 0;
        while (index < size) {
            AbstractRecord sourceRow;
            AbstractRecord targetRow = sourceRow = rows.get(index);
            Object directKey = this.containerPolicy.buildKeyFromJoinedRow(targetRow = this.trimRowForJoin(targetRow, joinManager, executionSession), joinManager, sourceQuery, parentCacheKey, executionSession, isTargetProtected);
            if (directKey == null) {
                return this.getIndirectionPolicy().valueFromRow(value);
            }
            if (!directValues.contains(directKey)) {
                directValues.add(directKey);
                Object directValue = targetRow.get(this.directField);
                if (valueConverter != null) {
                    directValue = valueConverter.convertDataValueToObjectValue(directValue, executionSession);
                }
                policy.addInto(directKey, directValue, value, executionSession);
            }
            ++index;
        }
        return this.getIndirectionPolicy().valueFromRow(value);
    }
}

