/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.descriptors.TimestampLockingPolicy;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.AggregateChangeRecord;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.DirectToFieldChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.Session;

public class ObjectChangeSet
implements Serializable,
Comparable<ObjectChangeSet>,
org.eclipse.persistence.sessions.changesets.ObjectChangeSet {
    protected List<org.eclipse.persistence.sessions.changesets.ChangeRecord> changes;
    protected transient Map<String, ChangeRecord> attributesToChanges;
    protected boolean shouldBeDeleted;
    protected Object id;
    protected transient Class classType;
    protected String className;
    protected boolean isNew;
    protected boolean isAggregate;
    protected Object oldKey;
    protected Object newKey;
    protected transient UnitOfWorkChangeSet unitOfWorkChangeSet;
    protected transient OptimisticLockingPolicy optimisticLockingPolicy;
    protected Object initialWriteLockValue;
    protected Object writeLockValue;
    protected boolean isInvalid;
    protected transient Object cloneObject;
    protected boolean hasVersionChange;
    protected Boolean shouldModifyVersionField;
    protected boolean hasCmpPolicyForcedUpdate;
    protected boolean hasChangesFromCascadeLocking;
    protected transient Set<String> deferredSet;
    protected int cacheSynchronizationType;
    protected transient CacheKey activeCacheKey;
    protected transient ClassDescriptor descriptor;
    protected boolean shouldRecalculateAfterUpdateEvent = true;
    public static int MAX_TRIES = 18000;

    public ObjectChangeSet() {
    }

    public ObjectChangeSet(Object primaryKey, ClassDescriptor descriptor, Object cloneObject, UnitOfWorkChangeSet parent, boolean isNew) {
        this.cacheSynchronizationType = 0;
        this.cloneObject = cloneObject;
        this.isNew = isNew;
        this.shouldBeDeleted = false;
        this.id = primaryKey;
        this.classType = descriptor.getJavaClass();
        this.className = this.classType.getName();
        this.descriptor = descriptor;
        this.cacheSynchronizationType = descriptor.getCachePolicy().getCacheSynchronizationType();
        this.unitOfWorkChangeSet = parent;
        this.isAggregate = false;
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void clear(boolean clearKeys) {
        this.shouldBeDeleted = false;
        this.changes = null;
        this.attributesToChanges = null;
        this.deferredSet = null;
        if (clearKeys) {
            this.setOldKey(null);
            this.setNewKey(null);
        }
    }

    public void addChange(ChangeRecord changeRecord) {
        if (changeRecord == null) {
            return;
        }
        String attributeName = changeRecord.getAttribute();
        Map attributeToChanges = this.getAttributesToChanges();
        List<org.eclipse.persistence.sessions.changesets.ChangeRecord> changes = this.getChanges();
        ChangeRecord existingChangeRecord = (ChangeRecord)attributeToChanges.get(attributeName);
        if (existingChangeRecord != null) {
            changes.remove(existingChangeRecord);
        }
        changes.add(changeRecord);
        attributeToChanges.put(attributeName, changeRecord);
        this.dirtyUOWChangeSet();
        DatabaseMapping mapping = changeRecord.getMapping();
        OptimisticLockingPolicy olp = this.getDescriptor().getOptimisticLockingPolicy();
        if (olp != null && (olp.shouldUpdateVersionOnOwnedMappingChange() && mapping.isOwned() || olp.shouldUpdateVersionOnMappingChange())) {
            this.shouldModifyVersionField = true;
        }
    }

    public void deferredDetectionRequiredOn(String attributeName) {
        this.getDeferredSet().add(attributeName);
    }

    public boolean containsChangesFromSynchronization() {
        return this.cacheSynchronizationType == 3 || this.cacheSynchronizationType == 1;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ObjectChangeSet) {
            return this.equals((ObjectChangeSet)object);
        }
        return false;
    }

    public boolean equals(ObjectChangeSet objectChange) {
        if (this == objectChange) {
            return true;
        }
        if (this.id == null) {
            return false;
        }
        return this.id.equals(objectChange.id);
    }

    @Override
    public int compareTo(ObjectChangeSet changeSet) {
        if (this == changeSet) {
            return 0;
        }
        if (this.id == null) {
            if (changeSet.id != null) {
                return -1;
            }
            return 0;
        }
        if (changeSet.id == null) {
            return 1;
        }
        try {
            return ((Comparable)this.id).compareTo(changeSet.id);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public Map getAttributesToChanges() {
        if (this.attributesToChanges == null) {
            this.attributesToChanges = new HashMap<String, ChangeRecord>();
        }
        return this.attributesToChanges;
    }

    @Override
    public org.eclipse.persistence.sessions.changesets.ChangeRecord getChangesForAttributeNamed(String attributeName) {
        return (ChangeRecord)this.getAttributesToChanges().get(attributeName);
    }

    @Override
    public List<String> getChangedAttributeNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (org.eclipse.persistence.sessions.changesets.ChangeRecord changeRecord : this.getChanges()) {
            names.add(changeRecord.getAttribute());
        }
        return names;
    }

    @Override
    public List<org.eclipse.persistence.sessions.changesets.ChangeRecord> getChanges() {
        if (this.changes == null) {
            this.changes = new ArrayList<org.eclipse.persistence.sessions.changesets.ChangeRecord>();
        }
        return this.changes;
    }

    public Class getClassType() {
        return this.classType;
    }

    @Override
    public Class getClassType(Session session) {
        if (this.classType == null) {
            this.classType = (Class)((AbstractSession)session).getDatasourcePlatform().getConversionManager().convertObject(this.getClassName(), ClassConstants.CLASS);
        }
        return this.classType;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public Object getInitialWriteLockValue() {
        return this.initialWriteLockValue;
    }

    @Override
    public Object getOldKey() {
        return this.oldKey;
    }

    @Override
    public Object getNewKey() {
        return this.newKey;
    }

    @Override
    @Deprecated
    public Vector getPrimaryKeys() {
        if (this.id instanceof CacheId) {
            return new Vector<Object>(Arrays.asList(((CacheId)this.id).getPrimaryKey()));
        }
        Vector<Object> primaryKey = new Vector<Object>(1);
        primaryKey.add(this.id);
        return primaryKey;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    public Object getOldValue() {
        AbstractSession session = null;
        if (this.unitOfWorkChangeSet != null) {
            session = this.unitOfWorkChangeSet.getSession();
        }
        return this.getOldValue(session);
    }

    public Object getOldValue(AbstractSession session) {
        if (this.isNew) {
            return null;
        }
        if (this.changes == null || this.changes.isEmpty()) {
            return this.cloneObject;
        }
        if (this.cloneObject != null && session != null) {
            Object oldValue = this.descriptor.getObjectBuilder().buildNewInstance();
            FetchGroup fetchGroup = null;
            FetchGroupManager fetchGroupManager = this.descriptor.getFetchGroupManager();
            if (fetchGroupManager != null) {
                fetchGroup = fetchGroupManager.getObjectFetchGroup(this.cloneObject);
            }
            for (DatabaseMapping mapping : this.descriptor.getMappings()) {
                String attributeName = mapping.getAttributeName();
                if (fetchGroup != null && !fetchGroup.containsAttributeInternal(attributeName)) continue;
                ChangeRecord changeRecord = (ChangeRecord)this.getChangesForAttributeNamed(attributeName);
                if (changeRecord != null) {
                    mapping.setRealAttributeValueInObject(oldValue, changeRecord.getOldValue());
                    continue;
                }
                mapping.setAttributeValueInObject(oldValue, mapping.getAttributeValueFromObject(this.cloneObject));
            }
            return oldValue;
        }
        return null;
    }

    public int getSynchronizationType() {
        return this.cacheSynchronizationType;
    }

    public Object getTargetVersionOfSourceObject(MergeManager mergeManager, AbstractSession session) {
        return this.getTargetVersionOfSourceObject(mergeManager, session, false);
    }

    public Object getTargetVersionOfSourceObject(MergeManager mergeManager, AbstractSession targetSession, boolean shouldRead) {
        Object attributeValue = null;
        ClassDescriptor descriptor = this.getDescriptor();
        if (descriptor == null) {
            descriptor = targetSession.getDescriptor(this.getClassType(targetSession));
        }
        if (descriptor != null) {
            if (mergeManager.getSession().isUnitOfWork()) {
                if (((UnitOfWorkImpl)mergeManager.getSession()).getLifecycle() == 4) {
                    attributeValue = this.getObjectForMerge(mergeManager, targetSession, this.getId(), descriptor);
                    if (attributeValue == null) {
                        attributeValue = ((UnitOfWorkImpl)mergeManager.getSession()).getOriginalVersionOfObjectOrNull(this.getUnitOfWorkClone(), this, descriptor, targetSession);
                    }
                } else {
                    attributeValue = this.getUnitOfWorkClone();
                }
            } else {
                attributeValue = this.getObjectForMerge(mergeManager, targetSession, this.getId(), descriptor);
            }
            if (attributeValue == null && shouldRead) {
                ReadObjectQuery query = new ReadObjectQuery();
                query.setShouldUseWrapperPolicy(false);
                query.setReferenceClass(this.getClassType(targetSession));
                query.setSelectionId(this.getId());
                attributeValue = targetSession.executeQuery(query);
            }
        }
        return attributeValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObjectForMerge(MergeManager mergeManager, AbstractSession session, Object primaryKey, ClassDescriptor descriptor) {
        Object domainObject = null;
        if (primaryKey == null) {
            this.activeCacheKey = null;
            return null;
        }
        CacheKey cacheKey = session.getIdentityMapAccessorInstance().getCacheKeyForObject(primaryKey, descriptor.getJavaClass(), descriptor, true);
        if (cacheKey != null) {
            if (cacheKey.acquireReadLockNoWait()) {
                domainObject = cacheKey.getObject();
                cacheKey.releaseReadLock();
            } else {
                if (!mergeManager.isTransitionedToDeferredLocks()) {
                    session.getIdentityMapAccessorInstance().getWriteLockManager().transitionToDeferredLocks(mergeManager);
                }
                cacheKey.acquireDeferredLock();
                domainObject = cacheKey.getObject();
                int tries = 0;
                while (domainObject == null) {
                    if (++tries > MAX_TRIES) {
                        session.getParent().log(7, "cache", "entity_not_available_during_merge", new Object[]{descriptor.getJavaClassName(), cacheKey.getKey(), Thread.currentThread().getName(), cacheKey.getActiveThread()});
                        break;
                    }
                    CacheKey cacheKey2 = cacheKey;
                    synchronized (cacheKey2) {
                        if (cacheKey.isAcquired()) {
                            try {
                                cacheKey.wait(10L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        domainObject = cacheKey.getObject();
                    }
                }
                cacheKey.releaseDeferredLock();
            }
        } else {
            domainObject = mergeManager.registerExistingObjectOfReadOnlyClassInNestedTransaction(this.getUnitOfWorkClone(), descriptor, session);
        }
        this.activeCacheKey = cacheKey;
        return domainObject;
    }

    public Object getUnitOfWorkClone() {
        return this.cloneObject;
    }

    public void setUnitOfWorkClone(Object cloneObject) {
        this.cloneObject = cloneObject;
    }

    @Override
    public org.eclipse.persistence.sessions.changesets.UnitOfWorkChangeSet getUOWChangeSet() {
        return this.unitOfWorkChangeSet;
    }

    @Override
    public Object getWriteLockValue() {
        return this.writeLockValue;
    }

    @Override
    public boolean hasChangeFor(String attributeName) {
        for (org.eclipse.persistence.sessions.changesets.ChangeRecord changeRecord : this.getChanges()) {
            if (!changeRecord.getAttribute().equals(attributeName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasChanges() {
        return this.isNew || this.hasVersionChange || this.changes != null && !this.changes.isEmpty();
    }

    public boolean hasForcedChanges() {
        return this.shouldModifyVersionField != null || this.hasCmpPolicyForcedUpdate;
    }

    public void setShouldModifyVersionField(Boolean shouldModifyVersionField) {
        this.shouldModifyVersionField = shouldModifyVersionField;
        if (shouldModifyVersionField != null && shouldModifyVersionField.booleanValue()) {
            this.hasVersionChange = true;
        }
    }

    public Boolean shouldModifyVersionField() {
        return this.shouldModifyVersionField;
    }

    public void setHasCmpPolicyForcedUpdate(boolean hasCmpPolicyForcedUpdate) {
        this.hasCmpPolicyForcedUpdate = hasCmpPolicyForcedUpdate;
    }

    public boolean hasCmpPolicyForcedUpdate() {
        return this.hasCmpPolicyForcedUpdate;
    }

    public boolean hasForcedChangesFromCascadeLocking() {
        return this.hasChangesFromCascadeLocking;
    }

    public void setHasForcedChangesFromCascadeLocking(boolean newValue) {
        this.setShouldModifyVersionField(Boolean.TRUE);
        this.hasChangesFromCascadeLocking = newValue;
    }

    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        return this.getId().hashCode();
    }

    public boolean hasKeys() {
        return this.newKey != null || this.oldKey != null;
    }

    public boolean isAggregate() {
        return this.isAggregate;
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    public boolean isInvalid() {
        return this.isInvalid;
    }

    public void mergeObjectChanges(ObjectChangeSet changeSetToMergeFrom, UnitOfWorkChangeSet mergeToChangeSet, UnitOfWorkChangeSet mergeFromChangeSet) {
        if (this == changeSetToMergeFrom || this.isInvalid()) {
            return;
        }
        if (changeSetToMergeFrom.optimisticLockingPolicy != null) {
            if (this.optimisticLockingPolicy == null) {
                this.optimisticLockingPolicy = changeSetToMergeFrom.optimisticLockingPolicy;
                this.initialWriteLockValue = changeSetToMergeFrom.initialWriteLockValue;
                this.writeLockValue = changeSetToMergeFrom.writeLockValue;
            } else {
                Object writeLockValueToCompare = this.writeLockValue;
                if (writeLockValueToCompare == null) {
                    writeLockValueToCompare = this.initialWriteLockValue;
                }
                if (this.optimisticLockingPolicy.compareWriteLockValues(writeLockValueToCompare, changeSetToMergeFrom.initialWriteLockValue) != 0) {
                    this.isInvalid = true;
                    return;
                }
                if (changeSetToMergeFrom.writeLockValue != null) {
                    this.writeLockValue = changeSetToMergeFrom.writeLockValue;
                }
            }
        }
        List<org.eclipse.persistence.sessions.changesets.ChangeRecord> changesToMerge = changeSetToMergeFrom.getChanges();
        int size = changesToMerge.size();
        int index = 0;
        while (index < size) {
            ChangeRecord record = (ChangeRecord)changesToMerge.get(index);
            ChangeRecord thisRecord = (ChangeRecord)this.getChangesForAttributeNamed(record.getAttribute());
            if (thisRecord == null) {
                record.updateReferences(mergeToChangeSet, mergeFromChangeSet);
                record.setOwner(this);
                this.addChange(record);
            } else {
                thisRecord.mergeRecord(record, mergeToChangeSet, mergeFromChangeSet);
            }
            ++index;
        }
        this.shouldBeDeleted = changeSetToMergeFrom.shouldBeDeleted;
        this.setOldKey(changeSetToMergeFrom.oldKey);
        this.setNewKey(changeSetToMergeFrom.newKey);
        this.hasVersionChange = changeSetToMergeFrom.hasVersionChange;
        this.shouldModifyVersionField = changeSetToMergeFrom.shouldModifyVersionField;
        this.hasCmpPolicyForcedUpdate = changeSetToMergeFrom.hasCmpPolicyForcedUpdate;
        this.hasChangesFromCascadeLocking = changeSetToMergeFrom.hasChangesFromCascadeLocking;
        this.deferredSet = changeSetToMergeFrom.deferredSet;
    }

    public void readCompleteChangeSet(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.readIdentityInformation(stream);
        this.changes = (List)stream.readObject();
        this.oldKey = stream.readObject();
        this.newKey = stream.readObject();
    }

    public void readIdentityInformation(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.id = stream.readObject();
        this.className = (String)stream.readObject();
        this.writeLockValue = stream.readObject();
        this.initialWriteLockValue = stream.readObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int cacheSyncType;
        this.cacheSynchronizationType = cacheSyncType = stream.read();
        this.shouldBeDeleted = stream.readBoolean();
        this.isInvalid = stream.readBoolean();
        this.isNew = stream.readBoolean();
        this.isAggregate = stream.readBoolean();
        this.shouldModifyVersionField = (Boolean)stream.readObject();
        this.hasVersionChange = stream.readBoolean();
        if (this.shouldBeDeleted || cacheSyncType == 4 || cacheSyncType == 2) {
            this.readIdentityInformation(stream);
        } else {
            this.readCompleteChangeSet(stream);
        }
    }

    public void setId(Object id) {
        this.id = id;
    }

    public void setChanges(List changesList) {
        this.changes = changesList;
        this.updateUOWChangeSet();
    }

    public void setClassType(Class newValue) {
        this.classType = newValue;
    }

    public void setClassName(String newValue) {
        this.className = newValue;
    }

    public void setIsAggregate(boolean isAggregate) {
        this.isAggregate = isAggregate;
    }

    public void setIsNew(boolean newIsNew) {
        this.isNew = newIsNew;
    }

    public void setOldKey(Object key) {
        if (key == null || this.oldKey == null) {
            this.oldKey = key;
        }
    }

    public void setNewKey(Object key) {
        this.newKey = key;
    }

    public void setShouldBeDeleted(boolean newValue) {
        this.shouldBeDeleted = newValue;
    }

    public void setSynchronizationType(int type) {
        this.cacheSynchronizationType = type;
    }

    public void setUOWChangeSet(UnitOfWorkChangeSet newUnitOfWorkChangeSet) {
        this.unitOfWorkChangeSet = newUnitOfWorkChangeSet;
    }

    public void setOptimisticLockingPolicyAndInitialWriteLockValue(OptimisticLockingPolicy optimisticLockingPolicy, AbstractSession session) {
        if (optimisticLockingPolicy.supportsWriteLockValuesComparison()) {
            this.optimisticLockingPolicy = optimisticLockingPolicy;
            this.initialWriteLockValue = optimisticLockingPolicy.getWriteLockValue(this.cloneObject, this.getId(), session);
        }
    }

    public void setWriteLockValue(Object newWriteLockValue) {
        this.writeLockValue = newWriteLockValue;
        this.hasVersionChange = true;
        this.updateUOWChangeSet();
    }

    public void setInitialWriteLockValue(Object initialWriteLockValue) {
        if (this.initialWriteLockValue == null) {
            this.initialWriteLockValue = initialWriteLockValue;
        }
    }

    public boolean shouldBeDeleted() {
        return this.shouldBeDeleted;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + this.hashCode() + ", " + this.getClassName() + ")" + this.getChanges().toString();
    }

    public void updateChangeRecordForAttribute(String attributeName, Object value) {
        ChangeRecord changeRecord = (ChangeRecord)this.getChangesForAttributeNamed(attributeName);
        if (changeRecord != null) {
            changeRecord.updateChangeRecordWithNewValue(value);
        }
    }

    public void updateChangeRecordForAttributeWithMappedObject(String attributeName, Object value, AbstractSession session) {
        ClassDescriptor descriptor;
        ObjectChangeSet referenceChangeSet = (ObjectChangeSet)this.getUOWChangeSet().getObjectChangeSetForClone(value);
        if (referenceChangeSet == null && (descriptor = session.getDescriptor(value.getClass())) != null) {
            referenceChangeSet = descriptor.getObjectBuilder().createObjectChangeSet(value, (UnitOfWorkChangeSet)this.getUOWChangeSet(), false, session);
        }
        this.updateChangeRecordForAttribute(attributeName, referenceChangeSet);
    }

    public void updateChangeRecordForAttribute(DatabaseMapping mapping, Object value, AbstractSession session, Object oldValue) {
        String attributeName = mapping.getAttributeName();
        ChangeRecord changeRecord = (ChangeRecord)this.getChangesForAttributeNamed(attributeName);
        if (mapping.isDirectToFieldMapping()) {
            value = ((AbstractDirectMapping)mapping).getObjectValue(value, session);
        }
        if (changeRecord != null) {
            changeRecord.updateChangeRecordWithNewValue(value);
        } else if (mapping.isDirectToFieldMapping()) {
            changeRecord = new DirectToFieldChangeRecord(this);
            changeRecord.setAttribute(attributeName);
            changeRecord.setMapping(mapping);
            ((DirectToFieldChangeRecord)changeRecord).setNewValue(value);
            ((DirectToFieldChangeRecord)changeRecord).setOldValue(oldValue);
            this.addChange(changeRecord);
        }
    }

    public void updateReferences(UnitOfWorkChangeSet localChangeSet, UnitOfWorkChangeSet mergingChangeSet) {
        int size = this.getChanges().size();
        int index = 0;
        while (index < size) {
            ChangeRecord record = (ChangeRecord)this.getChanges().get(index);
            record.updateReferences(localChangeSet, mergingChangeSet);
            record.setOwner(this);
            ++index;
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.write(this.cacheSynchronizationType);
        stream.writeBoolean(this.shouldBeDeleted);
        stream.writeBoolean(this.isInvalid);
        stream.writeBoolean(this.isNew);
        stream.writeBoolean(this.isAggregate);
        stream.writeObject(this.shouldModifyVersionField);
        stream.writeBoolean(this.hasVersionChange);
        if (this.shouldBeDeleted || this.cacheSynchronizationType == 4 || this.cacheSynchronizationType == 2) {
            this.writeIdentityInformation(stream);
        } else {
            this.writeCompleteChangeSet(stream);
        }
    }

    public void writeIdentityInformation(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.id);
        stream.writeObject(this.className);
        stream.writeObject(this.writeLockValue);
        stream.writeObject(this.initialWriteLockValue);
    }

    public void writeCompleteChangeSet(ObjectOutputStream stream) throws IOException {
        AbstractSession unitOfWork;
        if (this.isNew && (this.changes == null || this.changes.isEmpty()) && !(unitOfWork = this.unitOfWorkChangeSet.getSession()).isRemoteUnitOfWork()) {
            ClassDescriptor descriptor = this.getDescriptor();
            if (unitOfWork != null && descriptor != null) {
                FetchGroup fetchGroup = null;
                if (descriptor.hasFetchGroupManager()) {
                    fetchGroup = descriptor.getFetchGroupManager().getObjectFetchGroup(this.cloneObject);
                }
                Vector<DatabaseMapping> mappings = descriptor.getMappings();
                int mappingsSize = mappings.size();
                int index = 0;
                while (index < mappingsSize) {
                    DatabaseMapping mapping = (DatabaseMapping)mappings.get(index);
                    if (fetchGroup == null || fetchGroup.containsAttributeInternal(mapping.getAttributeName())) {
                        this.addChange(mapping.compareForChange(this.cloneObject, this.cloneObject, this, unitOfWork));
                    }
                    ++index;
                }
            }
        }
        this.writeIdentityInformation(stream);
        stream.writeObject(this.changes);
        stream.writeObject(this.oldKey);
        stream.writeObject(this.newKey);
    }

    public void postSerialize(Object clone, UnitOfWorkChangeSet uowChangeSet, AbstractSession session) {
        this.unitOfWorkChangeSet = uowChangeSet;
        if (clone != null) {
            this.cloneObject = clone;
            if (this.descriptor == null) {
                this.descriptor = session.getDescriptor(clone);
                this.classType = clone.getClass();
            }
        }
        if (this.attributesToChanges == null && this.changes != null) {
            for (ChangeRecord changeRecord : this.changes) {
                this.getAttributesToChanges().put(changeRecord.getAttribute(), changeRecord);
            }
        }
        if (!(this.changes == null || this.descriptor == null || clone != null && this.descriptor.isAggregateDescriptor())) {
            for (ChangeRecord changeRecord : this.changes) {
                AggregateChangeRecord aggregate;
                ObjectChangeSet aggregateCacheSet;
                DatabaseMapping mapping = this.descriptor.getObjectBuilder().getMappingForAttributeName(changeRecord.getAttribute());
                changeRecord.setMapping(mapping);
                if (mapping == null || !mapping.isAggregateObjectMapping() || (aggregateCacheSet = (ObjectChangeSet)(aggregate = (AggregateChangeRecord)changeRecord).getChangedObject()) == null) continue;
                aggregateCacheSet.setDescriptor(mapping.getReferenceDescriptor());
                aggregateCacheSet.postSerialize(null, uowChangeSet, session);
            }
        }
    }

    public Set<String> getDeferredSet() {
        if (this.deferredSet == null) {
            this.deferredSet = new HashSet<String>();
        }
        return this.deferredSet;
    }

    public boolean hasDeferredAttributes() {
        return this.deferredSet != null && !this.deferredSet.isEmpty();
    }

    protected void dirtyUOWChangeSet() {
        UnitOfWorkChangeSet unitOfWorkChangeSet = (UnitOfWorkChangeSet)this.getUOWChangeSet();
        if (unitOfWorkChangeSet != null) {
            unitOfWorkChangeSet.setHasChanges(true);
        }
    }

    protected void updateUOWChangeSet() {
        if (this.getUOWChangeSet() != null) {
            ((UnitOfWorkChangeSet)this.getUOWChangeSet()).setHasChanges(this.hasChanges());
        }
    }

    protected void rebuildWriteLockValueFromUserFormat(ClassDescriptor descriptor, AbstractSession session) {
        if (descriptor.getOptimisticLockingPolicy() instanceof TimestampLockingPolicy) {
            this.writeLockValue = session.getPlatform(descriptor.getJavaClass()).getConversionManager().convertObject(this.writeLockValue, ClassConstants.JavaSqlTimestamp_Class);
            this.initialWriteLockValue = session.getPlatform(descriptor.getJavaClass()).getConversionManager().convertObject(this.initialWriteLockValue, ClassConstants.JavaSqlTimestamp_Class);
        } else if (descriptor.getOptimisticLockingPolicy() instanceof VersionLockingPolicy) {
            this.writeLockValue = session.getPlatform(descriptor.getJavaClass()).getConversionManager().convertObject(this.writeLockValue, ClassConstants.BIGDECIMAL);
            this.initialWriteLockValue = session.getPlatform(descriptor.getJavaClass()).getConversionManager().convertObject(this.initialWriteLockValue, ClassConstants.BIGDECIMAL);
        }
    }

    public void removeChange(String attributeName) {
        org.eclipse.persistence.sessions.changesets.ChangeRecord record = this.getChangesForAttributeNamed(attributeName);
        if (record != null) {
            this.getChanges().remove(record);
            this.attributesToChanges.remove(attributeName);
        }
    }

    protected void removeFromIdentityMap(AbstractSession session) {
        session.getIdentityMapAccessor().removeFromIdentityMap(this.getId(), this.getClassType(session));
    }

    public boolean shouldInvalidateObject(Object original, AbstractSession session) {
        if (this.optimisticLockingPolicy == null) {
            return false;
        }
        if (session.isRemoteSession()) {
            return false;
        }
        if (this.isInvalid()) {
            return true;
        }
        Object originalWriteLockValue = this.optimisticLockingPolicy.getWriteLockValue(original, this.getId(), session);
        if (this.initialWriteLockValue == null) {
            return this.hasChanges();
        }
        return originalWriteLockValue != null && this.optimisticLockingPolicy.compareWriteLockValues(this.initialWriteLockValue, originalWriteLockValue) != 0;
    }

    public CacheKey getActiveCacheKey() {
        return this.activeCacheKey;
    }

    public void setActiveCacheKey(CacheKey activeCacheKey) {
        this.activeCacheKey = activeCacheKey;
    }

    @Override
    public boolean shouldRecalculateAfterUpdateEvent() {
        return this.shouldRecalculateAfterUpdateEvent;
    }

    @Override
    public void setShouldRecalculateAfterUpdateEvent(boolean shouldRecalculateAfterUpdateEvent) {
        this.shouldRecalculateAfterUpdateEvent = shouldRecalculateAfterUpdateEvent;
    }
}

