/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.mux;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.util.BlockingCallback;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.common.extensions.mux.MuxChannel;
import org.eclipse.jetty.websocket.common.extensions.mux.Muxer;

public class HttpTransportOverMux
implements HttpTransport {
    private static final Logger LOG = Log.getLogger(HttpTransportOverMux.class);
    private final BlockingCallback streamBlocker = new BlockingCallback();

    public HttpTransportOverMux(Muxer muxer, MuxChannel channel) {
    }

    @Override
    public void completed() {
        LOG.debug("completed", new Object[0]);
    }

    @Override
    public void send(HttpGenerator.ResponseInfo info, ByteBuffer responseBodyContent, boolean lastContent) throws IOException {
        this.send(info, responseBodyContent, lastContent, this.streamBlocker);
        try {
            this.streamBlocker.block();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EofException(e);
        }
    }

    @Override
    public void send(HttpGenerator.ResponseInfo info, ByteBuffer responseBodyContent, boolean lastContent, Callback callback) {
        if (!lastContent) {
            // empty if block
        }
        if (info.getContentLength() > 0L) {
            // empty if block
        }
    }
}

