/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.CloseStatus;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.SuspendToken;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.WebSocketRemoteEndpoint;
import org.eclipse.jetty.websocket.common.events.EventDriver;

@ManagedObject
public class WebSocketSession
extends ContainerLifeCycle
implements Session,
IncomingFrames {
    private static final Logger LOG = Log.getLogger(WebSocketSession.class);
    private final URI requestURI;
    private final EventDriver websocket;
    private final LogicalConnection connection;
    private ExtensionFactory extensionFactory;
    private long maximumMessageSize;
    private String protocolVersion;
    private Map<String, String[]> parameterMap = new HashMap<String, String[]>();
    private WebSocketRemoteEndpoint remote;
    private IncomingFrames incomingHandler;
    private OutgoingFrames outgoingHandler;
    private WebSocketPolicy policy;
    private UpgradeRequest upgradeRequest;
    private UpgradeResponse upgradeResponse;

    public WebSocketSession(URI requestURI, EventDriver websocket, LogicalConnection connection) {
        if (requestURI == null) {
            throw new RuntimeException("Request URI cannot be null");
        }
        this.requestURI = requestURI;
        this.websocket = websocket;
        this.connection = connection;
        this.outgoingHandler = connection;
        this.incomingHandler = websocket;
        MultiMap<String> params = new MultiMap<String>();
        String query = requestURI.getQuery();
        if (StringUtil.isNotBlank(query)) {
            UrlEncoded.decodeTo(query, params, StringUtil.__UTF8_CHARSET, -1);
        }
        for (String name : params.keySet()) {
            List<String> valueList = params.getValues(name);
            String[] valueArr = new String[valueList.size()];
            valueArr = valueList.toArray(valueArr);
            this.parameterMap.put(name, valueArr);
        }
    }

    @Override
    public void close() throws IOException {
        this.connection.close();
    }

    @Override
    public void close(CloseStatus closeStatus) {
        this.close(closeStatus.getCode(), closeStatus.getPhrase());
    }

    @Override
    public void close(int statusCode, String reason) {
        this.connection.close(statusCode, reason);
        this.notifyClose(statusCode, reason);
    }

    @Override
    public void disconnect() {
        this.connection.disconnect();
        this.notifyClose(1006, "Harsh disconnect");
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        super.dump(out, indent);
        out.append(indent).append(" +- incomingHandler : ");
        if (this.incomingHandler instanceof Dumpable) {
            ((Dumpable)((Object)this.incomingHandler)).dump(out, indent + "    ");
        } else {
            out.append(this.incomingHandler.toString()).append('\n');
        }
        out.append(indent).append(" +- outgoingHandler : ");
        if (this.outgoingHandler instanceof Dumpable) {
            ((Dumpable)((Object)this.outgoingHandler)).dump(out, indent + "    ");
        } else {
            out.append(this.outgoingHandler.toString()).append('\n');
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebSocketSession other = (WebSocketSession)obj;
        return !(this.connection == null ? other.connection != null : !this.connection.equals(other.connection));
    }

    public LogicalConnection getConnection() {
        return this.connection;
    }

    public ExtensionFactory getExtensionFactory() {
        return this.extensionFactory;
    }

    @Override
    public long getIdleTimeout() {
        return this.connection.getMaxIdleTimeout();
    }

    @ManagedAttribute(readonly=true)
    public IncomingFrames getIncomingHandler() {
        return this.incomingHandler;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.connection.getLocalAddress();
    }

    @Override
    public long getMaximumMessageSize() {
        return this.maximumMessageSize;
    }

    @ManagedAttribute(readonly=true)
    public OutgoingFrames getOutgoingHandler() {
        return this.outgoingHandler;
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public RemoteEndpoint getRemote() {
        if (!this.isOpen()) {
            throw new WebSocketException("Session has not been opened yet");
        }
        return this.remote;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.remote.getInetSocketAddress();
    }

    @Override
    public UpgradeRequest getUpgradeRequest() {
        return this.upgradeRequest;
    }

    @Override
    public UpgradeResponse getUpgradeResponse() {
        return this.upgradeResponse;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.connection == null ? 0 : this.connection.hashCode());
        return result;
    }

    @Override
    public void incomingError(WebSocketException e) {
        if (this.connection.getIOState().isInputClosed()) {
            return;
        }
        this.websocket.incomingError(e);
    }

    @Override
    public void incomingFrame(Frame frame) {
        if (this.connection.getIOState().isInputClosed()) {
            return;
        }
        this.incomingHandler.incomingFrame(frame);
    }

    @Override
    public boolean isOpen() {
        if (this.connection == null) {
            return false;
        }
        return this.connection.isOpen();
    }

    @Override
    public boolean isSecure() {
        if (this.upgradeRequest == null) {
            throw new IllegalStateException("No valid UpgradeRequest yet");
        }
        URI requestURI = this.upgradeRequest.getRequestURI();
        return "wss".equalsIgnoreCase(requestURI.getScheme());
    }

    public void notifyClose(int statusCode, String reason) {
        this.websocket.onClose(new CloseInfo(statusCode, reason));
    }

    public void open() {
        if (this.remote != null) {
            return;
        }
        this.remote = new WebSocketRemoteEndpoint(this.connection, this.outgoingHandler);
        this.websocket.openSession(this);
        if (LOG.isDebugEnabled()) {
            LOG.debug("open -> {}", this.dump());
        }
    }

    public void setExtensionFactory(ExtensionFactory extensionFactory) {
        this.extensionFactory = extensionFactory;
    }

    @Override
    public void setIdleTimeout(long ms) {
        this.connection.setMaxIdleTimeout(ms);
    }

    @Override
    public void setMaximumMessageSize(long length) {
        this.maximumMessageSize = length;
    }

    public void setOutgoingHandler(OutgoingFrames outgoing) {
        this.outgoingHandler = outgoing;
    }

    public void setPolicy(WebSocketPolicy policy) {
        this.policy = policy;
    }

    public void setUpgradeRequest(UpgradeRequest request) {
        this.upgradeRequest = request;
    }

    public void setUpgradeResponse(UpgradeResponse response) {
        this.upgradeResponse = response;
    }

    @Override
    public SuspendToken suspend() {
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WebSocketSession[");
        builder.append("websocket=").append(this.websocket);
        builder.append(",behavior=").append((Object)this.policy.getBehavior());
        builder.append(",connection=").append(this.connection);
        builder.append(",remote=").append(this.remote);
        builder.append(",incoming=").append(this.incomingHandler);
        builder.append(",outgoing=").append(this.outgoingHandler);
        builder.append("]");
        return builder.toString();
    }
}

