/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.UnsupportedEncodingException;
import java.net.HttpCookie;
import java.net.URLEncoder;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpReceiver;
import org.eclipse.jetty.client.HttpSender;
import org.eclipse.jetty.client.TimeoutCompleteListener;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpConnection
extends AbstractConnection
implements Connection {
    private static final Logger LOG = Log.getLogger(HttpConnection.class);
    private static final HttpField CHUNKED_FIELD = new HttpField(HttpHeader.TRANSFER_ENCODING, HttpHeaderValue.CHUNKED);
    private final AtomicReference<HttpExchange> exchange = new AtomicReference();
    private final HttpClient client;
    private final HttpDestination destination;
    private final HttpSender sender;
    private final HttpReceiver receiver;
    private long idleTimeout;

    public HttpConnection(HttpClient client, EndPoint endPoint, HttpDestination destination) {
        super(endPoint, client.getExecutor(), client.isDispatchIO());
        this.client = client;
        this.destination = destination;
        this.sender = new HttpSender(this);
        this.receiver = new HttpReceiver(this);
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public HttpDestination getDestination() {
        return this.destination;
    }

    @Override
    public void onOpen() {
        super.onOpen();
        this.fillInterested();
    }

    @Override
    protected boolean onReadTimeout() {
        LOG.debug("{} idle timeout", this);
        HttpExchange exchange = this.getExchange();
        if (exchange != null) {
            this.idleTimeout();
        } else {
            this.destination.remove(this);
        }
        return true;
    }

    protected void idleTimeout() {
        this.receiver.idleTimeout();
    }

    @Override
    public void send(Request request, Response.CompleteListener listener) {
        ArrayList<Response.ResponseListener> listeners = new ArrayList<Response.ResponseListener>(2);
        if (request.getTimeout() > 0L) {
            TimeoutCompleteListener timeoutListener = new TimeoutCompleteListener(request);
            timeoutListener.schedule(this.client.getScheduler());
            listeners.add(timeoutListener);
        }
        if (listener != null) {
            listeners.add(listener);
        }
        HttpConversation conversation = this.client.getConversation(request.getConversationID(), true);
        HttpExchange exchange = new HttpExchange(conversation, this.getDestination(), request, listeners);
        this.send(exchange);
    }

    public void send(HttpExchange exchange) {
        Request request = exchange.getRequest();
        this.normalizeRequest(request);
        EndPoint endPoint = this.getEndPoint();
        this.idleTimeout = endPoint.getIdleTimeout();
        endPoint.setIdleTimeout(request.getIdleTimeout());
        this.associate(exchange);
        this.sender.send(exchange);
    }

    private void normalizeRequest(Request request) {
        HttpField acceptEncodingField;
        Authentication.Result authnResult;
        Fields fields;
        String path;
        if (request.getMethod() == null) {
            request.method(HttpMethod.GET);
        }
        if (request.getVersion() == null) {
            request.version(HttpVersion.HTTP_1_1);
        }
        if (request.getIdleTimeout() <= 0L) {
            request.idleTimeout(this.client.getIdleTimeout(), TimeUnit.MILLISECONDS);
        }
        HttpMethod method = request.getMethod();
        HttpVersion version = request.getVersion();
        HttpFields headers = request.getHeaders();
        ContentProvider content = request.getContent();
        if (request.getAgent() == null) {
            headers.put(this.client.getUserAgentField());
        }
        if ((path = request.getPath()).trim().length() == 0) {
            path = "/";
            request.path(path);
        }
        if (this.destination.isProxied() && HttpMethod.CONNECT != request.getMethod()) {
            path = request.getURI().toString();
            request.path(path);
        }
        if (!(fields = request.getParams()).isEmpty()) {
            StringBuilder params = new StringBuilder();
            Iterator<Fields.Field> fieldIterator = fields.iterator();
            while (fieldIterator.hasNext()) {
                Fields.Field field = fieldIterator.next();
                String[] values = field.values();
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        params.append("&");
                    }
                    params.append(field.name()).append("=");
                    params.append(this.urlEncode(values[i]));
                }
                if (!fieldIterator.hasNext()) continue;
                params.append("&");
            }
            if (method == HttpMethod.POST && request.getContent() != null) {
                method = HttpMethod.GET;
            }
            switch (method) {
                case GET: {
                    path = path + "?";
                    path = path + params.toString();
                    request.path(path);
                    break;
                }
                case POST: {
                    request.header(HttpHeader.CONTENT_TYPE, MimeTypes.Type.FORM_ENCODED.asString());
                    request.content(new StringContentProvider(params.toString()));
                }
            }
        }
        if (version.getVersion() > 10 && !headers.containsKey(HttpHeader.HOST.asString())) {
            headers.put(this.getDestination().getHostField());
        }
        if (content != null) {
            long contentLength = content.getLength();
            if (contentLength >= 0L) {
                if (!headers.containsKey(HttpHeader.CONTENT_LENGTH.asString())) {
                    headers.put(HttpHeader.CONTENT_LENGTH, String.valueOf(contentLength));
                }
            } else if (!headers.containsKey(HttpHeader.TRANSFER_ENCODING.asString())) {
                headers.put(CHUNKED_FIELD);
            }
        }
        List<HttpCookie> cookies = this.client.getCookieStore().get(request.getURI());
        StringBuilder cookieString = null;
        for (int i = 0; i < cookies.size(); ++i) {
            if (cookieString == null) {
                cookieString = new StringBuilder();
            }
            if (i > 0) {
                cookieString.append("; ");
            }
            HttpCookie cookie = cookies.get(i);
            cookieString.append(cookie.getName()).append("=").append(cookie.getValue());
        }
        if (cookieString != null) {
            request.header(HttpHeader.COOKIE.asString(), cookieString.toString());
        }
        if ((authnResult = this.client.getAuthenticationStore().findAuthenticationResult(request.getURI())) != null) {
            authnResult.apply(request);
        }
        if (!headers.containsKey(HttpHeader.ACCEPT_ENCODING.asString()) && (acceptEncodingField = this.client.getAcceptEncodingField()) != null) {
            headers.put(acceptEncodingField);
        }
    }

    private String urlEncode(String value) {
        String encoding = "UTF-8";
        try {
            return URLEncoder.encode(value, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedCharsetException(encoding);
        }
    }

    public HttpExchange getExchange() {
        return this.exchange.get();
    }

    protected void associate(HttpExchange exchange) {
        if (!this.exchange.compareAndSet(null, exchange)) {
            throw new UnsupportedOperationException("Pipelined requests not supported");
        }
        exchange.setConnection(this);
        LOG.debug("{} associated to {}", exchange, this);
    }

    protected HttpExchange disassociate() {
        HttpExchange exchange = this.exchange.getAndSet(null);
        if (exchange != null) {
            exchange.setConnection(null);
        }
        LOG.debug("{} disassociated from {}", exchange, this);
        return exchange;
    }

    @Override
    public void onFillable() {
        HttpExchange exchange = this.getExchange();
        if (exchange != null) {
            this.receive();
        } else {
            this.close();
        }
    }

    protected void receive() {
        this.receiver.receive();
    }

    public void complete(HttpExchange exchange, boolean success) {
        HttpExchange existing = this.disassociate();
        if (existing == exchange) {
            exchange.awaitTermination();
            this.getEndPoint().setIdleTimeout(this.idleTimeout);
            LOG.debug("{} disassociated from {}", exchange, this);
            if (success) {
                HttpFields responseHeaders = exchange.getResponse().getHeaders();
                Enumeration<String> values = responseHeaders.getValues(HttpHeader.CONNECTION.asString(), ",");
                if (values != null) {
                    while (values.hasMoreElements()) {
                        if (!"close".equalsIgnoreCase(values.nextElement())) continue;
                        this.close();
                        return;
                    }
                }
                this.destination.release(this);
            } else {
                this.close();
            }
        } else if (existing != null) {
            throw new IllegalStateException();
        }
    }

    public boolean abort(Throwable cause) {
        this.sender.abort(cause);
        return this.receiver.abort(cause);
    }

    public void proceed(boolean proceed) {
        this.sender.proceed(proceed);
    }

    @Override
    public void close() {
        this.destination.remove(this);
        this.getEndPoint().shutdownOutput();
        LOG.debug("{} oshut", this);
        this.getEndPoint().close();
        LOG.debug("{} closed", this);
    }

    @Override
    public String toString() {
        return String.format("%s@%x(l:%s <-> r:%s)", HttpConnection.class.getSimpleName(), this.hashCode(), this.getEndPoint().getLocalAddress(), this.getEndPoint().getRemoteAddress());
    }
}

