/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.struts;

import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.RequestUtils;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.create.AbstractCreator;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.util.FakeHttpServletRequest;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrutsCreator
extends AbstractCreator
implements Creator {
    private String formBean = null;
    private ModuleConfig moduleConfig = null;
    private Method getInstanceMethod;
    private Method getModuleNameMethod;
    private Method getModuleConfigMethod;
    private static final Log log = LogFactory.getLog(StrutsCreator.class);

    public StrutsCreator() {
        try {
            Class<?> moduleUtilsClass = LocalUtil.classForName("org.apache.struts.util.ModuleUtils");
            this.getInstanceMethod = moduleUtilsClass.getMethod("getInstance", new Class[0]);
            this.getModuleNameMethod = moduleUtilsClass.getMethod("getModuleName", String.class, ServletContext.class);
            this.getModuleConfigMethod = moduleUtilsClass.getMethod("getModuleConfig", String.class, ServletContext.class);
            log.debug((Object)"Using Struts 1.2 based ModuleUtils code");
        }
        catch (Exception ex) {
            this.getInstanceMethod = null;
            this.getModuleNameMethod = null;
            this.getModuleConfigMethod = null;
            log.debug((Object)"Failed to find Struts 1.2 ModuleUtils code. Falling back to 1.1 based code");
        }
    }

    public void setFormBean(String formBean) {
        this.formBean = formBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> getType() {
        StrutsCreator strutsCreator = this;
        synchronized (strutsCreator) {
            if (this.moduleConfig == null) {
                WebContext wc = WebContextFactory.get();
                if (this.getInstanceMethod != null) {
                    try {
                        Object utils = this.getInstanceMethod.invoke(null, new Object[0]);
                        String moduleName = (String)this.getModuleNameMethod.invoke(utils, "/", wc.getServletContext());
                        this.moduleConfig = (ModuleConfig)this.getModuleConfigMethod.invoke(utils, moduleName, wc.getServletContext());
                    }
                    catch (Exception ex) {
                        throw new IllegalArgumentException(ex.getMessage());
                    }
                } else {
                    HttpServletRequest request = wc.getHttpServletRequest();
                    if (request == null) {
                        log.warn((Object)"Using a FakeHttpServletRequest as part of setup");
                        request = new FakeHttpServletRequest();
                    }
                    this.moduleConfig = RequestUtils.getModuleConfig((HttpServletRequest)request, (ServletContext)wc.getServletContext());
                }
            }
        }
        try {
            return LocalUtil.classForName(this.moduleConfig.findFormBeanConfig(this.formBean).getType());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException(Messages.getString("Creator.ClassNotFound", this.moduleConfig.findFormBeanConfig(this.formBean).getType()));
        }
    }

    @Override
    public Object getInstance() throws InstantiationException {
        ActionForm formInstance = (ActionForm)WebContextFactory.get().getSession().getAttribute(this.formBean);
        if (formInstance == null) {
            throw new InstantiationException(Messages.getString("Creator.IllegalAccess"));
        }
        return formInstance;
    }
}

