/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.extend.TypeHintContext;
import org.directwebremoting.util.JavascriptUtil;
import org.directwebremoting.util.LocalUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureParser {
    private Map<String, String> classImports = new HashMap<String, String>();
    private List<String> packageImports = new ArrayList<String>();
    private ConverterManager converterManager;
    private CreatorManager creatorManager;
    public static final Log log = LogFactory.getLog(SignatureParser.class);

    public SignatureParser(ConverterManager converterManager, CreatorManager creatorManager) {
        this.converterManager = converterManager;
        this.creatorManager = creatorManager;
        this.packageImports.add("java.lang");
    }

    public void parse(String sigtext) {
        try {
            log.debug((Object)"Parsing extra type info: ");
            String reply = JavascriptUtil.stripMultiLineComments(sigtext);
            String process = reply = JavascriptUtil.stripSingleLineComments(reply);
            process = process.replace('\n', ' ');
            process = process.replace('\r', ' ');
            process = process.replace('\t', ' ');
            StringTokenizer st = new StringTokenizer(process, ";");
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                if ((line = line.trim()).length() == 0) continue;
                if (line.startsWith("import ")) {
                    this.parseImportLine(line);
                    continue;
                }
                this.parseDeclarationLine(line);
            }
        }
        catch (Exception ex) {
            log.error((Object)"Unexpected Error", (Throwable)ex);
        }
    }

    private void parseImportLine(String line) {
        String shortcut = line.substring(7, line.length());
        shortcut = shortcut.trim();
        if (line.endsWith(".*")) {
            shortcut = shortcut.substring(0, shortcut.length() - 2);
            this.packageImports.add(shortcut);
        } else {
            int lastDot = line.lastIndexOf(46);
            if (lastDot == -1) {
                log.error((Object)("Missing . from import statement: " + line));
                return;
            }
            String leaf = line.substring(lastDot + 1);
            this.classImports.put(leaf, shortcut);
        }
    }

    private void parseDeclarationLine(String line) {
        int openBrace = line.indexOf(40);
        int closeBrace = line.indexOf(41);
        if (openBrace == -1) {
            log.error((Object)("Missing ( in declaration: " + line));
            return;
        }
        if (closeBrace == -1) {
            log.error((Object)("Missing ) in declaration: " + line));
            return;
        }
        if (openBrace > closeBrace) {
            log.error((Object)("( Must come before ) in declaration: " + line));
            return;
        }
        String classMethod = line.substring(0, openBrace).trim();
        Method method = this.findMethod(classMethod);
        if (method == null) {
            return;
        }
        String paramDecl = line.substring(openBrace + 1, closeBrace);
        String[] paramNames = SignatureParser.split(paramDecl);
        if (method.getParameterTypes().length != paramNames.length) {
            log.error((Object)("Parameter mismatch parsing signatures section in dwr.xml on line: " + line));
            log.info((Object)("- Reflected method had: " + method.getParameterTypes().length + " parameters: " + method.toString()));
            log.info((Object)("- Signatures section had: " + paramNames.length + " parameters"));
            log.info((Object)"- This can be caused by method overloading which is not supported by Javascript or DWR");
            return;
        }
        for (int i = 0; i < paramNames.length; ++i) {
            String[] genericList = SignatureParser.getGenericParameterTypeList(paramNames[i]);
            for (int j = 0; j < genericList.length; ++j) {
                String type = genericList[j].trim();
                Class<?> clazz = this.findClass(type);
                if (clazz != null) {
                    TypeHintContext thc = new TypeHintContext(this.converterManager, method, i).createChildContext(j);
                    this.converterManager.setExtraTypeInfo(thc, clazz);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("- " + thc + " = " + clazz.getName()));
                    continue;
                }
                log.warn((Object)("Missing class (" + type + ") while parsing signature section on line: " + line));
            }
        }
    }

    private Class<?> findClass(String type) {
        String itype = type;
        if (itype.indexOf(46) != -1) {
            log.debug((Object)("Inner class detected: " + itype));
            itype = itype.replace('.', '$');
        }
        try {
            String full = this.classImports.get(itype);
            if (full == null) {
                full = itype;
            }
            return LocalUtil.classForName(full);
        }
        catch (Exception ex) {
            for (String pkg : this.packageImports) {
                String lookup = pkg + '.' + itype;
                try {
                    return LocalUtil.classForName(lookup);
                }
                catch (Exception ex2) {
                }
            }
            Creator creator = this.creatorManager.getCreator(type);
            if (creator != null) {
                return creator.getType();
            }
            log.error((Object)("Failed to find class: '" + itype + "' from <signature> block."));
            log.info((Object)"- Looked in the following class imports:");
            for (Map.Entry<String, String> entry : this.classImports.entrySet()) {
                log.info((Object)("  - " + entry.getKey() + " -> " + entry.getValue()));
            }
            log.info((Object)"- Looked in the following package imports:");
            for (String pkg : this.packageImports) {
                log.info((Object)("  - " + pkg));
            }
            return null;
        }
    }

    private static String[] getGenericParameterTypeList(String paramName) {
        int openGeneric = paramName.indexOf(60);
        if (openGeneric == -1) {
            log.debug((Object)("No < in paramter declaration: " + paramName));
            return new String[0];
        }
        int closeGeneric = paramName.lastIndexOf(62);
        if (closeGeneric == -1) {
            log.error((Object)("Missing > in generic declaration: " + paramName));
            return new String[0];
        }
        String generics = paramName.substring(openGeneric + 1, closeGeneric);
        StringTokenizer st = new StringTokenizer(generics, ",");
        String[] types = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            types[i] = st.nextToken();
            ++i;
        }
        return types;
    }

    private Method findMethod(String classMethod) {
        Method[] methods;
        int lastDot;
        String classMethodChop = classMethod;
        int lastSpace = classMethodChop.lastIndexOf(32);
        if (lastSpace >= 0) {
            classMethodChop = classMethodChop.substring(lastSpace);
        }
        if ((lastDot = classMethodChop.lastIndexOf(46)) == -1) {
            log.error((Object)("Missing . to separate class name and method: " + classMethodChop));
            return null;
        }
        String className = classMethodChop.substring(0, lastDot).trim();
        String methodName = classMethodChop.substring(lastDot + 1).trim();
        Class<?> clazz = this.findClass(className);
        if (clazz == null) {
            return null;
        }
        Method method = null;
        for (Method test : methods = clazz.getMethods()) {
            if (!test.getName().equals(methodName)) continue;
            if (method == null) {
                method = test;
                continue;
            }
            log.warn((Object)"Setting extra type info to overloaded methods may fail with <parameter .../>");
        }
        if (method == null) {
            log.error((Object)("Unable to find method called: " + methodName + " on type: " + clazz.getName()));
        }
        return method;
    }

    private static String[] split(String paramDecl) {
        ArrayList<String> params = new ArrayList<String>();
        boolean inGeneric = false;
        int start = 0;
        for (int i = 0; i < paramDecl.length(); ++i) {
            char c = paramDecl.charAt(i);
            if (c == '<') {
                if (inGeneric) {
                    log.error((Object)("Found < while parsing generic section: " + paramDecl));
                    break;
                }
                inGeneric = true;
            }
            if (c == '>') {
                if (!inGeneric) {
                    log.error((Object)("Found > while not parsing generic section: " + paramDecl));
                    break;
                }
                inGeneric = false;
            }
            if (inGeneric || c != ',') continue;
            String param = paramDecl.substring(start, i);
            params.add(param);
            start = i + 1;
        }
        String param = paramDecl.substring(start, paramDecl.length());
        params.add(param);
        return params.toArray(new String[params.size()]);
    }
}

