/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.create;

import java.io.File;
import java.io.RandomAccessFile;
import javax.servlet.ServletContext;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.create.AbstractCreator;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptedCreator
extends AbstractCreator
implements Creator {
    private static final Log log = LogFactory.getLog(ScriptedCreator.class);
    private Class<?> clazz = null;
    private String language = null;
    private String scriptSrc = null;
    private String scriptPath = null;
    private boolean reloadable = true;
    private boolean useDynamicClasses = false;
    private long scriptModified = -1L;
    private String cachedScript;

    public ScriptedCreator() {
        this.setCacheable(false);
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public boolean isReloadable() {
        return this.reloadable;
    }

    public void setReloadable(boolean reloadable) {
        this.reloadable = reloadable;
        if (reloadable) {
            this.setCacheable(false);
        }
    }

    public boolean isUseDynamicClasses() {
        return this.useDynamicClasses;
    }

    public void setUseDynamicClasses(boolean useDynamicClasses) {
        this.useDynamicClasses = useDynamicClasses;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public void setScriptPath(String scriptPath) {
        if (this.scriptSrc != null) {
            throw new IllegalArgumentException(Messages.getString("ScriptCreator.MultipleScript"));
        }
        this.scriptPath = scriptPath;
    }

    private boolean scriptUpdated() {
        if (null == this.scriptPath) {
            return false;
        }
        ServletContext sc = WebContextFactory.get().getServletContext();
        File scriptFile = new File(sc.getRealPath(this.scriptPath));
        if (this.scriptModified < scriptFile.lastModified()) {
            log.debug((Object)"Script has been updated.");
            this.clazz = null;
            return true;
        }
        return false;
    }

    public String getScript() throws InstantiationException {
        String string;
        if (this.scriptSrc != null) {
            return this.scriptSrc;
        }
        if (this.scriptPath == null) {
            throw new InstantiationException(Messages.getString("ScriptedCreator.MissingScript"));
        }
        if (!(this.cachedScript == null || this.reloadable && this.scriptUpdated())) {
            return this.cachedScript;
        }
        log.debug((Object)("Loading Script from Path: " + this.scriptPath));
        RandomAccessFile in = null;
        try {
            ServletContext sc = WebContextFactory.get().getServletContext();
            File scriptFile = new File(sc.getRealPath(this.scriptPath));
            this.scriptModified = scriptFile.lastModified();
            in = new RandomAccessFile(scriptFile, "r");
            byte[] bytes = new byte[(int)in.length()];
            in.readFully(bytes);
            string = this.cachedScript = new String(bytes);
        }
        catch (Exception ex) {
            try {
                log.error((Object)ex.getMessage(), (Throwable)ex);
                throw new InstantiationException(Messages.getString("ScriptCreator.MissingScript"));
            }
            catch (Throwable throwable) {
                LocalUtil.close(in);
                throw throwable;
            }
        }
        LocalUtil.close(in);
        return string;
    }

    public void setScript(String scriptSrc) {
        if (this.scriptPath != null) {
            throw new IllegalArgumentException(Messages.getString("ScriptCreator.MultipleScript"));
        }
        if (scriptSrc == null || scriptSrc.trim().length() == 0) {
            throw new IllegalArgumentException(Messages.getString("ScriptedCreator.MissingScript"));
        }
        this.scriptSrc = scriptSrc;
    }

    public void setClass(String classname) {
        try {
            this.clazz = LocalUtil.classForName(classname);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException(Messages.getString("Creator.ClassNotFound", classname));
        }
    }

    @Override
    public Class<?> getType() {
        if (this.clazz == null || this.reloadable && this.scriptUpdated()) {
            try {
                this.clazz = this.getInstance().getClass();
            }
            catch (InstantiationException ex) {
                log.error((Object)"Failed to instansiate object to detect type.", (Throwable)ex);
                return Object.class;
            }
        }
        return this.clazz;
    }

    @Override
    public Object getInstance() throws InstantiationException {
        try {
            if (this.useDynamicClasses && this.clazz != null) {
                return this.clazz.newInstance();
            }
            BSFManager bsfman = new BSFManager();
            try {
                WebContext context = WebContextFactory.get();
                bsfman.declareBean("context", (Object)context, context.getClass());
            }
            catch (BSFException ex) {
                log.warn((Object)("Failed to register WebContext with scripting engine: " + ex.getMessage()));
            }
            return bsfman.eval(this.language, null == this.scriptPath ? "dwr.xml" : this.scriptPath, 0, 0, (Object)this.getScript());
        }
        catch (Exception ex) {
            throw new InstantiationException(Messages.getString("ScriptedCreator.IllegalAccess", ex.getMessage()));
        }
    }
}

