/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.dwrp.MapOutboundVariable;
import org.directwebremoting.dwrp.ObjectJsonOutboundVariable;
import org.directwebremoting.dwrp.ObjectNonJsonOutboundVariable;
import org.directwebremoting.dwrp.ParseUtil;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.extend.TypeHintContext;
import org.directwebremoting.util.JavascriptUtil;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapConverter
implements Converter {
    private static boolean sentNonStringWarning = false;
    private ConverterManager converterManager = null;
    private static final Log log = LogFactory.getLog(MapConverter.class);

    @Override
    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    @Override
    public Object convertInbound(Class<?> paramType, InboundVariable data, InboundContext inctx) throws MarshallException {
        String value = data.getValue();
        if (value.trim().equals("null")) {
            return null;
        }
        if (!value.startsWith("{")) {
            throw new IllegalArgumentException(Messages.getString("MapConverter.FormatError", "{"));
        }
        if (!value.endsWith("}")) {
            throw new IllegalArgumentException(Messages.getString("MapConverter.FormatError", "}"));
        }
        value = value.substring(1, value.length() - 1);
        try {
            Map map = !paramType.isInterface() && !Modifier.isAbstract(paramType.getModifiers()) ? (Map)paramType.newInstance() : new HashMap();
            TypeHintContext thc = inctx.getCurrentTypeHintContext();
            TypeHintContext keyThc = thc.createChildContext(0);
            Class<?> keyType = keyThc.getExtraTypeInfo();
            TypeHintContext valThc = thc.createChildContext(1);
            Class<?> valType = valThc.getExtraTypeInfo();
            inctx.addConverted(data, paramType, map);
            InboundContext incx = data.getLookup();
            StringTokenizer st = new StringTokenizer(value, ",");
            int size = st.countTokens();
            for (int i = 0; i < size; ++i) {
                String token = st.nextToken();
                if (token.trim().length() == 0) continue;
                int colonpos = token.indexOf(":");
                if (colonpos == -1) {
                    throw new MarshallException(paramType, Messages.getString("MapConverter.MissingSeparator", ":", token));
                }
                String valStr = token.substring(colonpos + 1).trim();
                String[] splitIv = ParseUtil.splitInbound(valStr);
                String splitIvValue = splitIv[1];
                String splitIvType = splitIv[0];
                InboundVariable valIv = new InboundVariable(incx, null, splitIvType, splitIvValue);
                valIv.dereference();
                Object val = this.converterManager.convertInbound(valType, valIv, inctx, valThc);
                String keyStr = token.substring(0, colonpos).trim();
                InboundVariable keyIv = new InboundVariable(incx, null, "string", keyStr);
                keyIv.dereference();
                Object key = this.converterManager.convertInbound(keyType, keyIv, inctx, keyThc);
                map.put(key, val);
            }
            return map;
        }
        catch (MarshallException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MarshallException(paramType, (Throwable)ex);
        }
    }

    @Override
    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) throws MarshallException {
        HashMap<String, OutboundVariable> ovs = LocalUtil.classNewInstance("OrderedConvertOutbound", "java.util.LinkedHashMap", Map.class);
        if (ovs == null) {
            ovs = new HashMap<String, OutboundVariable>();
        }
        MapOutboundVariable ov = outctx.isJsonMode() ? new ObjectJsonOutboundVariable() : new ObjectNonJsonOutboundVariable(outctx, null);
        outctx.put(data, ov);
        Map map = (Map)data;
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(key instanceof String) && !sentNonStringWarning) {
                log.warn((Object)("--Javascript does not support non string keys. Converting '" + key.getClass().getName() + "' using toString()"));
                sentNonStringWarning = true;
            }
            String outkey = JavascriptUtil.escapeJavaScript(key.toString());
            OutboundVariable nested = this.converterManager.convertOutbound(value, outctx);
            ovs.put(outkey, nested);
        }
        ov.setChildren(ovs);
        return ov;
    }
}

