/*
 * Decompiled with CFR 0.152.
 */
package jsx3.xml;

import java.util.Iterator;
import java.util.LinkedList;
import jsx3.xml.CdfDocument;
import jsx3.xml.Record;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node
implements Iterable<Record> {
    protected String id;
    protected Node parentNode;
    protected CdfDocument document;
    protected LinkedList<Record> children = new LinkedList();

    protected Node(String id) {
        this.id = id;
    }

    protected Node() {
    }

    @Override
    public Iterator<Record> iterator() {
        return this.children.iterator();
    }

    public void insertRecord(int position, Record newRecord) {
        this.children.add(position, newRecord);
        if (newRecord.getOwnerDocument() != null) {
            newRecord.getParentNode().removeRecord(newRecord);
        }
        newRecord.joinDocument(this);
    }

    public void replaceRecord(Record newRecord, Record oldRecord) {
        int index = this.children.indexOf(oldRecord);
        if (index == -1) {
            this.appendRecord(newRecord);
        } else {
            this.removeRecord(oldRecord);
            this.insertRecord(index, oldRecord);
        }
    }

    public void removeRecord(Record oldRecord) {
        boolean removed = this.children.remove(oldRecord);
        if (removed) {
            oldRecord.leaveDocument();
        }
    }

    public void appendRecord(Record newRecord) {
        if (newRecord.getOwnerDocument() != null) {
            newRecord.getParentNode().removeRecord(newRecord);
        }
        newRecord.joinDocument(this);
        this.children.add(newRecord);
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    public CdfDocument getOwnerDocument() {
        return this.document;
    }

    public void clear() {
        for (Record record : this.children) {
            this.removeRecord(record);
        }
    }

    protected void joinDocument(Node parent) {
        this.document = parent.getOwnerDocument();
        this.parentNode = parent;
    }

    protected void leaveDocument() {
        this.document = null;
        this.parentNode = null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return 37829 + this.id.hashCode();
    }

    protected static final String indent(int depth) {
        StringBuilder reply = new StringBuilder(depth * 2);
        for (int i = 0; i < depth; ++i) {
            reply.append("  ");
        }
        return reply.toString();
    }
}

