/*
 * Decompiled with CFR 0.152.
 */
package daverog.jsonld.tree;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.output.ByteArrayOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtils {
    public static String toN3String(Model model) {
        return ModelUtils.toString(model, "N3");
    }

    public static String toString(Model model, String lang) {
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter((OutputStream)boas);
        model.write((Writer)writer, lang);
        try {
            boas.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Graph serialisation error");
        }
        return boas.toString();
    }

    public static Model createJenaModel(String rdfContent) {
        return ModelUtils.createJenaModel(rdfContent, "TTL");
    }

    public static Model createJenaModel(String rdfContent, String lang) {
        StringReader reader = new StringReader(rdfContent);
        Model model = ModelFactory.createDefaultModel();
        model.read((Reader)reader, null, lang);
        return model;
    }

    public static List<Resource> getSubjectsByPredicateAndObject(Model model, String predicatePrefix, String predicateValue, String objectPrefix, String objectValue) {
        Property predicate = model.createProperty(predicatePrefix, predicateValue);
        Property object = model.createProperty(objectPrefix, objectValue);
        return ModelUtils.getSubjectsByPredicateAndObject(model, predicate, object);
    }

    public static Resource getSubjectByPredicateAndObject(Model model, String predicatePrefix, String predicateValue, String objectValue) {
        Property object;
        Property predicate = model.createProperty(predicatePrefix, predicateValue);
        List<Resource> subjects = ModelUtils.getSubjectsByPredicateAndObject(model, predicate, object = model.createProperty(objectValue));
        if (subjects.size() > 0) {
            return subjects.get(0);
        }
        return null;
    }

    private static List<Resource> getSubjectsByPredicateAndObject(Model model, Property predicate, Property object) {
        ArrayList<Resource> subjects = new ArrayList<Resource>();
        SimpleSelector selector = new SimpleSelector(null, predicate, (RDFNode)object);
        StmtIterator it = model.listStatements((Selector)selector);
        Resource resource = null;
        while (it.hasNext()) {
            Statement statement = it.nextStatement();
            resource = statement.getSubject();
            subjects.add(resource);
        }
        return subjects;
    }

    public static String getObjectValueFromSubjectByPredicate(Model model, Resource subject, String predicatePrefix, String predicateName) {
        String value = "";
        Property p = model.createProperty(predicatePrefix, predicateName);
        Statement statement = subject.getProperty(p);
        if (statement == null) {
            return null;
        }
        RDFNode resource = statement.getObject();
        value = resource.isLiteral() ? statement.getString() : resource.toString();
        return value;
    }
}

