/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;
import org.datanucleus.maven.AbstractDataNucleusMojo;

public abstract class AbstractEnhancerMojo
extends AbstractDataNucleusMojo {
    private static final String TOOL_NAME_DATANUCLEUS_ENHANCER = "org.datanucleus.enhancer.DataNucleusEnhancer";
    protected boolean quiet;
    protected boolean alwaysDetachable;
    protected boolean generatePK;
    protected boolean generateConstructor;
    protected boolean detachListener;
    protected String useFileListFile;

    @Override
    protected void executeDataNucleusTool(List pluginArtifacts, List files) throws CommandLineException, MojoExecutionException {
        this.enhance(pluginArtifacts, files);
    }

    protected void enhance(List pluginArtifacts, List files) throws CommandLineException, MojoExecutionException {
        ArrayList<String> cpEntries = new ArrayList<String>();
        for (Artifact artifact : pluginArtifacts) {
            try {
                String artifactPath = artifact.getFile().getCanonicalPath();
                if (cpEntries.contains(artifactPath)) continue;
                cpEntries.add(artifactPath);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error while creating the canonical path for '" + artifact.getFile() + "'.", (Exception)e);
            }
        }
        for (String entry : this.getUniqueClasspathElements()) {
            if (cpEntries.contains(entry)) continue;
            cpEntries.add(entry);
        }
        StringBuffer cpBuffer = new StringBuffer();
        Iterator it = cpEntries.iterator();
        while (it.hasNext()) {
            cpBuffer.append((String)it.next());
            if (!it.hasNext()) continue;
            cpBuffer.append(File.pathSeparator);
        }
        if (this.fork) {
            Commandline cl = new Commandline();
            cl.setExecutable("java");
            cl.createArg().setValue("-cp");
            cl.createArg().setValue(cpBuffer.toString());
            URL log4jURL = this.getLog4JConfiguration();
            if (log4jURL != null) {
                cl.createArg().setValue("-Dlog4j.configuration=" + log4jURL);
            } else {
                URL jdkLogURL = this.getJdkLogConfiguration();
                if (jdkLogURL != null) {
                    cl.createArg().setValue("-Djava.util.logging.config.file=" + jdkLogURL);
                }
            }
            cl.createArg().setValue(TOOL_NAME_DATANUCLEUS_ENHANCER);
            this.prepareModeSpecificCommandLineArguments(cl, null);
            if (this.quiet) {
                cl.createArg().setValue("-q");
            } else if (this.verbose) {
                cl.createArg().setValue("-v");
            }
            boolean usingPU = false;
            if (this.persistenceUnitName != null && this.persistenceUnitName.trim().length() > 0) {
                usingPU = true;
                cl.createArg().setLine("-pu " + this.persistenceUnitName);
            }
            cl.createArg().setLine("-api " + this.api);
            if (this.alwaysDetachable) {
                cl.createArg().setValue("-alwaysDetachable");
            }
            if (!this.generatePK) {
                cl.createArg().setLine("-generatePK false");
            }
            if (!this.generateConstructor) {
                cl.createArg().setLine("-generateConstructor false");
            }
            if (this.detachListener) {
                cl.createArg().setLine("-detachListener true");
            }
            if (!usingPU) {
                if (this.determineUseFileListFile()) {
                    File fileListFile = AbstractEnhancerMojo.writeFileListFile(files);
                    cl.createArg().setLine("-flf \"" + fileListFile.getAbsolutePath() + '\"');
                } else {
                    for (File file : files) {
                        cl.createArg().setValue(file.getAbsolutePath());
                    }
                }
            }
            this.executeCommandLine(cl);
        } else {
            ArrayList<String> args = new ArrayList<String>();
            this.prepareModeSpecificCommandLineArguments(null, args);
            if (this.quiet) {
                args.add("-q");
            } else if (this.verbose) {
                args.add("-v");
            }
            boolean usingPU = false;
            if (this.persistenceUnitName != null && this.persistenceUnitName.trim().length() > 0) {
                usingPU = true;
                args.add("-pu");
                args.add(this.persistenceUnitName);
            }
            args.add("-api");
            args.add(this.api);
            if (this.alwaysDetachable) {
                args.add("-alwaysDetachable");
            }
            if (!this.generatePK) {
                args.add("-generatePK");
                args.add("false");
            }
            if (!this.generateConstructor) {
                args.add("-generateConstructor");
                args.add("false");
            }
            if (this.detachListener) {
                args.add("-detachListener");
                args.add("true");
            }
            if (!usingPU) {
                for (File file : files) {
                    args.add(file.getAbsolutePath());
                }
            }
            this.executeInJvm(TOOL_NAME_DATANUCLEUS_ENHANCER, args, cpEntries, this.quiet);
        }
    }

    protected abstract void prepareModeSpecificCommandLineArguments(Commandline var1, List var2);

    @Override
    protected String getToolName() {
        return TOOL_NAME_DATANUCLEUS_ENHANCER;
    }

    protected boolean determineUseFileListFile() {
        if (this.useFileListFile != null) {
            if ("true".equalsIgnoreCase(this.useFileListFile)) {
                return true;
            }
            if ("false".equalsIgnoreCase(this.useFileListFile)) {
                return false;
            }
            if (!"auto".equalsIgnoreCase(this.useFileListFile)) {
                System.err.println("WARNING: useFileListFile is an unknown value! Falling back to default!");
            }
        }
        return File.separatorChar == '\\';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File writeFileListFile(Collection<File> files) {
        try {
            File fileListFile = File.createTempFile("enhancer-", ".flf");
            System.out.println("Writing fileListFile: " + fileListFile);
            try (FileOutputStream out = new FileOutputStream(fileListFile);
                 OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, "UTF-8");){
                for (File file : files) {
                    w.write(file.getAbsolutePath());
                    w.write(10);
                }
            }
            return fileListFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

