/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer.asm;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jdo.spi.StateManager;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.enhancer.AbstractClassEnhancer;
import org.datanucleus.enhancer.ClassField;
import org.datanucleus.enhancer.DataNucleusEnhancer;
import org.datanucleus.enhancer.asm.JdoClassAdapter;
import org.datanucleus.enhancer.asm.JdoClassChecker;
import org.datanucleus.enhancer.asm.method.InitFieldFlags;
import org.datanucleus.enhancer.asm.method.InitFieldNames;
import org.datanucleus.enhancer.asm.method.InitFieldTypes;
import org.datanucleus.enhancer.asm.method.InitPersistenceCapableSuperclass;
import org.datanucleus.enhancer.asm.method.JdoCopyField;
import org.datanucleus.enhancer.asm.method.JdoCopyFields;
import org.datanucleus.enhancer.asm.method.JdoCopyKeyFieldsFromObjectId;
import org.datanucleus.enhancer.asm.method.JdoCopyKeyFieldsFromObjectId2;
import org.datanucleus.enhancer.asm.method.JdoCopyKeyFieldsToObjectId;
import org.datanucleus.enhancer.asm.method.JdoCopyKeyFieldsToObjectId2;
import org.datanucleus.enhancer.asm.method.JdoGetInheritedFieldCount;
import org.datanucleus.enhancer.asm.method.JdoGetManagedFieldCount;
import org.datanucleus.enhancer.asm.method.JdoGetObjectId;
import org.datanucleus.enhancer.asm.method.JdoGetPersistenceManager;
import org.datanucleus.enhancer.asm.method.JdoGetTransactionalObjectId;
import org.datanucleus.enhancer.asm.method.JdoGetVersion;
import org.datanucleus.enhancer.asm.method.JdoIsDeleted;
import org.datanucleus.enhancer.asm.method.JdoIsDetached;
import org.datanucleus.enhancer.asm.method.JdoIsDirty;
import org.datanucleus.enhancer.asm.method.JdoIsNew;
import org.datanucleus.enhancer.asm.method.JdoIsPersistent;
import org.datanucleus.enhancer.asm.method.JdoIsTransactional;
import org.datanucleus.enhancer.asm.method.JdoMakeDirty;
import org.datanucleus.enhancer.asm.method.JdoNewInstance1;
import org.datanucleus.enhancer.asm.method.JdoNewInstance2;
import org.datanucleus.enhancer.asm.method.JdoNewObjectIdInstance1;
import org.datanucleus.enhancer.asm.method.JdoNewObjectIdInstance2;
import org.datanucleus.enhancer.asm.method.JdoPreSerialize;
import org.datanucleus.enhancer.asm.method.JdoProvideField;
import org.datanucleus.enhancer.asm.method.JdoProvideFields;
import org.datanucleus.enhancer.asm.method.JdoReplaceDetachedState;
import org.datanucleus.enhancer.asm.method.JdoReplaceField;
import org.datanucleus.enhancer.asm.method.JdoReplaceFields;
import org.datanucleus.enhancer.asm.method.JdoReplaceFlags;
import org.datanucleus.enhancer.asm.method.JdoReplaceStateManager;
import org.datanucleus.enhancer.asm.method.JdoSuperClone;
import org.datanucleus.enhancer.asm.method.LoadClass;
import org.datanucleus.enhancer.asm.primarykey.PrimaryKeyGenerator;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.util.Localiser;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ASMClassEnhancer
extends AbstractClassEnhancer {
    protected static Localiser LOCALISER_CORE = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)ObjectManagerFactoryImpl.class.getClassLoader());
    protected String inputResourceName;
    protected byte[] inputBytes;
    protected final Class cls;
    protected byte[] classBytes = null;
    protected byte[] pkClassBytes = null;
    protected String asmClassName = null;
    protected String classDescriptor = null;

    public ASMClassEnhancer(ClassMetaData cmd, ClassLoaderResolver clr, MetaDataManager mmgr) {
        super(cmd, clr, mmgr);
        this.cls = clr.classForName(cmd.getFullClassName());
        this.asmClassName = cmd.getFullClassName().replace('.', '/');
        this.classDescriptor = Type.getDescriptor((Class)this.cls);
        this.inputResourceName = "/" + this.className.replace('.', '/') + ".class";
    }

    public ASMClassEnhancer(ClassMetaData cmd, ClassLoaderResolver clr, MetaDataManager mmgr, byte[] classBytes) {
        super(cmd, clr, mmgr);
        this.cls = clr.classForName(cmd.getFullClassName());
        this.asmClassName = cmd.getFullClassName().replace('.', '/');
        this.classDescriptor = Type.getDescriptor((Class)this.cls);
        this.inputBytes = classBytes;
    }

    public static String getClassNameForFileName(String filename) {
        MyClassVisitor vis = new MyClassVisitor();
        try {
            new ClassReader((InputStream)new FileInputStream(filename)).accept((ClassVisitor)vis, 0);
            return vis.getClassName();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public Class getClassEnhanced() {
        return this.cls;
    }

    public String getASMClassName() {
        return this.asmClassName;
    }

    public String getClassDescriptor() {
        return this.classDescriptor;
    }

    protected void initialiseMethodsList() {
        if (this.cmd.getPersistenceCapableSuperclass() == null) {
            this.methodsToAdd.add(JdoCopyKeyFieldsFromObjectId.getInstance(this));
            this.methodsToAdd.add(JdoCopyKeyFieldsFromObjectId2.getInstance(this));
            this.methodsToAdd.add(JdoCopyKeyFieldsToObjectId.getInstance(this));
            this.methodsToAdd.add(JdoCopyKeyFieldsToObjectId2.getInstance(this));
            this.methodsToAdd.add(JdoGetObjectId.getInstance(this));
            this.methodsToAdd.add(JdoGetVersion.getInstance(this));
            this.methodsToAdd.add(JdoPreSerialize.getInstance(this));
            this.methodsToAdd.add(JdoGetPersistenceManager.getInstance(this));
            this.methodsToAdd.add(JdoGetTransactionalObjectId.getInstance(this));
            this.methodsToAdd.add(JdoIsDeleted.getInstance(this));
            this.methodsToAdd.add(JdoIsDirty.getInstance(this));
            this.methodsToAdd.add(JdoIsNew.getInstance(this));
            this.methodsToAdd.add(JdoIsPersistent.getInstance(this));
            this.methodsToAdd.add(JdoIsTransactional.getInstance(this));
            this.methodsToAdd.add(JdoMakeDirty.getInstance(this));
            this.methodsToAdd.add(JdoNewObjectIdInstance1.getInstance(this));
            this.methodsToAdd.add(JdoNewObjectIdInstance2.getInstance(this));
            this.methodsToAdd.add(JdoProvideFields.getInstance(this));
            this.methodsToAdd.add(JdoReplaceFields.getInstance(this));
            this.methodsToAdd.add(JdoReplaceFlags.getInstance(this));
            this.methodsToAdd.add(JdoReplaceStateManager.getInstance(this));
        }
        if (this.requiresDetachable()) {
            this.methodsToAdd.add(JdoReplaceDetachedState.getInstance(this));
        }
        if (this.cmd.isDetachable() && this.cmd.getPersistenceCapableSuperclass() != null) {
            this.methodsToAdd.add(JdoMakeDirty.getInstance(this));
        }
        this.methodsToAdd.add(JdoIsDetached.getInstance(this));
        this.methodsToAdd.add(JdoNewInstance1.getInstance(this));
        this.methodsToAdd.add(JdoNewInstance2.getInstance(this));
        this.methodsToAdd.add(JdoReplaceField.getInstance(this));
        this.methodsToAdd.add(JdoProvideField.getInstance(this));
        this.methodsToAdd.add(JdoCopyField.getInstance(this));
        this.methodsToAdd.add(JdoCopyFields.getInstance(this));
        this.methodsToAdd.add(InitFieldNames.getInstance(this));
        this.methodsToAdd.add(InitFieldTypes.getInstance(this));
        this.methodsToAdd.add(InitFieldFlags.getInstance(this));
        this.methodsToAdd.add(JdoGetInheritedFieldCount.getInstance(this));
        this.methodsToAdd.add(JdoGetManagedFieldCount.getInstance(this));
        this.methodsToAdd.add(InitPersistenceCapableSuperclass.getInstance(this));
        this.methodsToAdd.add(LoadClass.getInstance(this));
        this.methodsToAdd.add(JdoSuperClone.getInstance(this));
    }

    protected void initialiseFieldsList() {
        if (this.cmd.getPersistenceCapableSuperclass() == null) {
            this.fieldsToAdd.add(new ClassField(this, "jdoStateManager", 132, StateManager.class));
            this.fieldsToAdd.add(new ClassField(this, "jdoFlags", 132, Byte.TYPE));
        }
        if (this.requiresDetachable()) {
            this.fieldsToAdd.add(new ClassField(this, "jdoDetachedState", 4, Object[].class));
        }
        this.fieldsToAdd.add(new ClassField(this, "jdoFieldFlags", 26, byte[].class));
        this.fieldsToAdd.add(new ClassField(this, "jdoPersistenceCapableSuperclass", 26, Class.class));
        this.fieldsToAdd.add(new ClassField(this, "jdoFieldTypes", 26, Class[].class));
        this.fieldsToAdd.add(new ClassField(this, "jdoFieldNames", 26, String[].class));
        this.fieldsToAdd.add(new ClassField(this, "jdoInheritedFieldCount", 26, Integer.TYPE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enhance() {
        if (this.cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE && this.cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_AWARE) {
            return false;
        }
        this.initialise();
        if (this.checkClassIsEnhanced(false)) {
            DataNucleusEnhancer.LOGGER.info((Object)LOCALISER.msg("Enhancer.ClassIsAlreadyEnhanced", (Object)this.className));
            return true;
        }
        try {
            if (this.cmd.getIdentityType() == IdentityType.APPLICATION && this.cmd.getObjectidClass() == null && this.cmd.getNoOfPrimaryKeyMembers() > 1) {
                if (this.hasOption("generate-primary-key")) {
                    String pkClassName = this.cmd.getFullClassName() + AbstractClassMetaData.GENERATED_PK_SUFFIX;
                    if (DataNucleusEnhancer.LOGGER.isDebugEnabled()) {
                        DataNucleusEnhancer.LOGGER.debug((Object)LOCALISER.msg("Enhancer.GeneratePrimaryKey", (Object)this.cmd.getFullClassName(), (Object)pkClassName));
                    }
                    this.cmd.setObjectIdClass(pkClassName);
                    PrimaryKeyGenerator pkGen = new PrimaryKeyGenerator((AbstractClassMetaData)this.cmd, this);
                    this.pkClassBytes = pkGen.generate();
                } else {
                    throw new InvalidMetaDataException(LOCALISER_CORE, "044065", (Object)this.cmd.getFullClassName(), (Object)this.cmd.getNoOfPrimaryKeyMembers());
                }
            }
            ClassWriter cw = new ClassWriter(1);
            JdoClassAdapter cv = new JdoClassAdapter((ClassVisitor)cw, this);
            ClassReader cr = null;
            InputStream classReaderInputStream = null;
            try {
                if (this.inputBytes != null) {
                    cr = new ClassReader(this.inputBytes);
                } else {
                    classReaderInputStream = this.clr.getResource(this.inputResourceName, null).openStream();
                    cr = new ClassReader(classReaderInputStream);
                }
                cr.accept((ClassVisitor)cv, 0);
                this.classBytes = cw.toByteArray();
            }
            finally {
                if (classReaderInputStream != null) {
                    classReaderInputStream.close();
                }
            }
        }
        catch (Exception e) {
            DataNucleusEnhancer.LOGGER.error((Object)"Error thrown enhancing with ASMClassEnhancer", (Throwable)e);
            return false;
        }
        this.update = true;
        return true;
    }

    public byte[] getClassBytes() {
        return this.classBytes;
    }

    public byte[] getPrimaryKeyClassBytes() {
        return this.pkClassBytes;
    }

    public boolean validate() {
        if (this.cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE && this.cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_AWARE) {
            return false;
        }
        this.initialise();
        return this.checkClassIsEnhanced(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkClassIsEnhanced(boolean logErrors) {
        try {
            JdoClassChecker checker = new JdoClassChecker(this, logErrors);
            InputStream classReaderInputStream = null;
            try {
                ClassReader cr = null;
                if (this.inputBytes != null) {
                    cr = new ClassReader(this.inputBytes);
                } else {
                    classReaderInputStream = this.clr.getResource(this.inputResourceName, null).openStream();
                    cr = new ClassReader(classReaderInputStream);
                }
                cr.accept((ClassVisitor)checker, 0);
            }
            finally {
                if (classReaderInputStream != null) {
                    classReaderInputStream.close();
                }
            }
            return checker.isEnhanced();
        }
        catch (Exception e) {
            DataNucleusEnhancer.LOGGER.error((Object)"Error thrown enhancing with ASMClassEnhancer", (Throwable)e);
            return false;
        }
    }

    public static class MyClassVisitor
    implements ClassVisitor {
        String className = null;

        public String getClassName() {
            return this.className;
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        public void visit(int version, int access, String name, String sig, String supername, String[] intfs) {
            this.className = name.replace('/', '.');
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return null;
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return null;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] excpts) {
            return null;
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitOuterClass(String owner, String name, String desc) {
        }

        public void visitSource(String source, String debug) {
        }

        public void visitEnd() {
        }
    }
}

