/*
 * Decompiled with CFR 0.152.
 */
package org.crazycake.shiro;

import java.io.UnsupportedEncodingException;
import org.crazycake.shiro.RedisSerializer;
import org.crazycake.shiro.SerializationException;

public class StringSerializer
implements RedisSerializer<String> {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private String charset = "UTF-8";

    @Override
    public byte[] serialize(String s) throws SerializationException {
        try {
            return s == null ? null : s.getBytes(this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializationException("serialize error, string=" + s, e);
        }
    }

    @Override
    public String deserialize(byte[] bytes) throws SerializationException {
        try {
            return bytes == null ? null : new String(bytes, this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializationException("deserialize error", e);
        }
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }
}

