/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.archiver.ArchiveFilterException;
import org.codehaus.plexus.archiver.ArchiveFinalizer;
import org.codehaus.plexus.archiver.ArchivedFileSet;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.DotDirectiveArchiveFinalizer;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.FilterEnabled;
import org.codehaus.plexus.archiver.FinalizerEnabled;
import org.codehaus.plexus.archiver.ResourceIterator;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.util.DefaultArchivedFileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.archiver.util.FilterSupport;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.components.io.filemappers.PrefixFileMapper;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.resources.PlexusIoArchivedResourceCollection;
import org.codehaus.plexus.components.io.resources.PlexusIoFileResource;
import org.codehaus.plexus.components.io.resources.PlexusIoProxyResourceCollection;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.components.io.resources.PlexusIoResourceCollection;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;

public abstract class AbstractArchiver
extends AbstractLogEnabled
implements Archiver,
Contextualizable,
FilterEnabled,
FinalizerEnabled {
    public static final int DEFAULT_DIR_MODE = 16877;
    public static final int DEFAULT_FILE_MODE = 33188;
    private Logger logger;
    private File destFile;
    private List resources = new ArrayList();
    private int defaultFileMode = 33188;
    private boolean includeEmptyDirs = true;
    private int defaultDirectoryMode = 16877;
    private boolean forced = true;
    private FilterSupport filterSupport;
    private List finalizers;
    private File dotFileDirectory;
    private ArchiverManager archiverManager;

    public void setDefaultFileMode(int mode) {
        this.defaultFileMode = mode & 0xFFF | 0x8000;
    }

    public int getDefaultFileMode() {
        return this.defaultFileMode;
    }

    public void setDefaultDirectoryMode(int mode) {
        this.defaultDirectoryMode = mode & 0xFFF | 0x4000;
    }

    public int getDefaultDirectoryMode() {
        return this.defaultDirectoryMode;
    }

    public boolean getIncludeEmptyDirs() {
        return this.includeEmptyDirs;
    }

    public void setIncludeEmptyDirs(boolean includeEmptyDirs) {
        this.includeEmptyDirs = includeEmptyDirs;
    }

    public void addDirectory(File directory) throws ArchiverException {
        this.addDirectory(directory, "");
    }

    public void addDirectory(File directory, String prefix) throws ArchiverException {
        this.addDirectory(directory, prefix, null, null);
    }

    public void addDirectory(File directory, String[] includes, String[] excludes) throws ArchiverException {
        this.addDirectory(directory, "", includes, excludes);
    }

    public void addDirectory(File directory, String prefix, String[] includes, String[] excludes) throws ArchiverException {
        DefaultFileSet fileSet = new DefaultFileSet();
        fileSet.setDirectory(directory);
        fileSet.setPrefix(prefix);
        fileSet.setIncludes(includes);
        fileSet.setExcludes(excludes);
        fileSet.setIncludingEmptyDirectories(this.includeEmptyDirs);
        this.addFileSet(fileSet);
    }

    public void addFileSet(FileSet fileSet) throws ArchiverException {
        PlexusIoFileResource res;
        int i;
        File directory;
        DirectoryScanner scanner = new DirectoryScanner();
        if (fileSet.getIncludes() != null) {
            scanner.setIncludes(fileSet.getIncludes());
        }
        if (fileSet.getExcludes() != null) {
            scanner.setExcludes(fileSet.getExcludes());
        }
        if ((directory = fileSet.getDirectory()) == null) {
            throw new ArchiverException("The file sets base directory is null.");
        }
        if (!directory.isDirectory()) {
            throw new ArchiverException(directory.getAbsolutePath() + " isn't a directory.");
        }
        String basedir = directory.getAbsolutePath();
        scanner.setBasedir(basedir);
        scanner.scan();
        String prefix = fileSet.getPrefix();
        FileSelector[] fileSelectors = fileSet.getFileSelectors();
        if (fileSet.isIncludingEmptyDirectories()) {
            String[] dirs = scanner.getIncludedDirectories();
            for (i = 0; i < dirs.length; ++i) {
                String name = dirs[i];
                String sourceDir = name.replace('\\', '/');
                File dir = new File(basedir, sourceDir);
                res = new PlexusIoFileResource(dir);
                if (!this.isSelected(fileSelectors, (PlexusIoResource)res)) continue;
                String targetDir = PrefixFileMapper.getMappedFileName((String)prefix, (String)sourceDir);
                this.resources.add(ArchiveEntry.createDirectoryEntry(targetDir, (PlexusIoResource)res, this.getDefaultDirectoryMode()));
            }
        }
        String[] files = scanner.getIncludedFiles();
        for (i = 0; i < files.length; ++i) {
            String file = files[i];
            String sourceFile = file.replace('\\', '/');
            File source = new File(basedir, sourceFile);
            res = new PlexusIoFileResource(source, sourceFile);
            if (!this.isSelected(fileSelectors, (PlexusIoResource)res)) continue;
            String targetFile = PrefixFileMapper.getMappedFileName((String)prefix, (String)sourceFile);
            this.addResource((PlexusIoResource)res, targetFile, this.getDefaultFileMode());
        }
    }

    private boolean isSelected(FileSelector[] fileSelectors, PlexusIoResource fileInfo) throws ArchiverException {
        if (fileSelectors != null) {
            for (int i = 0; i < fileSelectors.length; ++i) {
                try {
                    if (fileSelectors[i].isSelected((FileInfo)fileInfo)) continue;
                    return false;
                }
                catch (IOException e) {
                    throw new ArchiverException("Failed to check, whether " + fileInfo.getName() + " is selected.", e);
                }
            }
        }
        return true;
    }

    public void addFile(File inputFile, String destFileName) throws ArchiverException {
        this.addFile(inputFile, destFileName, this.getDefaultFileMode());
    }

    protected ArchiveEntry asArchiveEntry(PlexusIoResource resource, String destFileName, int permissions) throws ArchiverException {
        if (!resource.isExisting()) {
            throw new ArchiverException(resource.getName() + " not found.");
        }
        if (resource.isFile()) {
            return ArchiveEntry.createFileEntry(destFileName, resource, permissions);
        }
        return ArchiveEntry.createDirectoryEntry(destFileName, resource, permissions);
    }

    protected ArchiveEntry asArchiveEntry(PlexusIoResourceCollection collection, PlexusIoResource resource) throws ArchiverException {
        try {
            String destFileName = collection.getName(resource);
            int permissions = resource.isFile() ? this.getDefaultFileMode() : this.getDefaultDirectoryMode();
            return this.asArchiveEntry(resource, destFileName, permissions);
        }
        catch (IOException e) {
            throw new ArchiverException(e.getMessage(), e);
        }
    }

    public void addResource(PlexusIoResource resource, String destFileName, int permissions) throws ArchiverException {
        this.resources.add(this.asArchiveEntry(resource, destFileName, permissions));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addFile(File inputFile, String destFileName, int permissions) throws ArchiverException {
        FileInputStream fileStream;
        block8: {
            if (!inputFile.isFile()) throw new ArchiverException(inputFile.getAbsolutePath() + " isn't a file.");
            if (!inputFile.exists()) {
                throw new ArchiverException(inputFile.getAbsolutePath() + " isn't a file.");
            }
            fileStream = null;
            destFileName = destFileName.replace('\\', '/');
            try {
                if (this.filterSupport != null) {
                    fileStream = new FileInputStream(inputFile);
                    if (this.include(fileStream, destFileName)) {
                        this.resources.add(ArchiveEntry.createFileEntry(destFileName, inputFile, permissions));
                    }
                    break block8;
                }
                this.resources.add(ArchiveEntry.createFileEntry(destFileName, inputFile, permissions));
            }
            catch (IOException e) {
                try {
                    throw new ArchiverException("Failed to determine inclusion status for: " + inputFile, e);
                    catch (ArchiveFilterException e2) {
                        throw new ArchiverException("Failed to determine inclusion status for: " + inputFile, e2);
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.close(fileStream);
                    throw throwable;
                }
            }
        }
        IOUtil.close((InputStream)fileStream);
    }

    public ResourceIterator getResources() throws ArchiverException {
        return new ResourceIterator(){
            private final Iterator archiveEntryIter;
            private boolean currentArchiveEntryValid;
            private PlexusIoResourceCollection plexusIoResourceCollection;
            private Iterator plexusIoResourceIter;
            private ArchiveEntry archiveEntry;
            {
                this.archiveEntryIter = AbstractArchiver.this.resources.iterator();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean hasNext() throws ArchiverException {
                if (!this.currentArchiveEntryValid) {
                    block9: {
                        if (this.plexusIoResourceIter == null) {
                            if (this.archiveEntryIter.hasNext()) {
                                Object o = this.archiveEntryIter.next();
                                if (o instanceof ArchiveEntry) {
                                    this.archiveEntry = (ArchiveEntry)o;
                                    break block9;
                                } else {
                                    if (!(o instanceof PlexusIoResourceCollection)) throw new IllegalStateException("Invalid object type: " + o.getClass().getName());
                                    this.plexusIoResourceCollection = (PlexusIoResourceCollection)o;
                                    try {
                                        this.plexusIoResourceIter = this.plexusIoResourceCollection.getResources();
                                        return this.hasNext();
                                    }
                                    catch (IOException e) {
                                        throw new ArchiverException(e.getMessage(), e);
                                    }
                                }
                            }
                            this.archiveEntry = null;
                        } else {
                            if (!this.plexusIoResourceIter.hasNext()) {
                                this.plexusIoResourceIter = null;
                                return this.hasNext();
                            }
                            PlexusIoResource resource = (PlexusIoResource)this.plexusIoResourceIter.next();
                            this.archiveEntry = AbstractArchiver.this.asArchiveEntry(this.plexusIoResourceCollection, resource);
                        }
                    }
                    this.currentArchiveEntryValid = true;
                }
                if (this.archiveEntry == null) return false;
                return true;
            }

            public ArchiveEntry next() throws ArchiverException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.currentArchiveEntryValid = false;
                return this.archiveEntry;
            }
        };
    }

    public Map getFiles() {
        try {
            HashMap<String, ArchiveEntry> map = new HashMap<String, ArchiveEntry>();
            ResourceIterator iter = this.getResources();
            while (iter.hasNext()) {
                ArchiveEntry entry = iter.next();
                if (!this.includeEmptyDirs && entry.getType() != 1) continue;
                map.put(entry.getName(), entry);
            }
            return map;
        }
        catch (ArchiverException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public File getDestFile() {
        return this.destFile;
    }

    public void setDestFile(File destFile) {
        this.destFile = destFile;
        if (destFile != null) {
            destFile.getParentFile().mkdirs();
        }
    }

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = super.getLogger() != null ? super.getLogger() : new ConsoleLogger(1, "console");
        }
        return this.logger;
    }

    public Map getDirs() {
        try {
            HashMap<String, ArchiveEntry> map = new HashMap<String, ArchiveEntry>();
            ResourceIterator iter = this.getResources();
            while (iter.hasNext()) {
                ArchiveEntry entry = iter.next();
                if (entry.getType() != 2) continue;
                map.put(entry.getName(), entry);
            }
            return map;
        }
        catch (ArchiverException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    protected PlexusIoResourceCollection asResourceCollection(ArchivedFileSet fileSet) throws ArchiverException {
        PlexusIoResourceCollection resources;
        File archiveFile = fileSet.getArchive();
        try {
            resources = this.archiverManager.getResourceCollection(archiveFile);
        }
        catch (NoSuchArchiverException e) {
            throw new ArchiverException("Error adding archived file-set. PlexusIoResourceCollection not found for: " + archiveFile, e);
        }
        if (!(resources instanceof PlexusIoArchivedResourceCollection)) {
            throw new ArchiverException("Expected " + PlexusIoArchivedResourceCollection.class.getName() + ", got " + resources.getClass().getName());
        }
        ((PlexusIoArchivedResourceCollection)resources).setFile(fileSet.getArchive());
        PlexusIoProxyResourceCollection proxy = new PlexusIoProxyResourceCollection();
        proxy.setSrc(resources);
        proxy.setExcludes(fileSet.getExcludes());
        proxy.setIncludes(fileSet.getIncludes());
        proxy.setIncludingEmptyDirectories(fileSet.isIncludingEmptyDirectories());
        proxy.setCaseSensitive(fileSet.isCaseSensitive());
        proxy.setPrefix(fileSet.getPrefix());
        proxy.setUsingDefaultExcludes(fileSet.isUsingDefaultExcludes());
        proxy.setFileSelectors(fileSet.getFileSelectors());
        return proxy;
    }

    public void addResources(PlexusIoResourceCollection collection) throws ArchiverException {
        this.resources.add(collection);
    }

    public void addArchivedFileSet(ArchivedFileSet fileSet) throws ArchiverException {
        PlexusIoResourceCollection resourceCollection = this.asResourceCollection(fileSet);
        this.addResources(resourceCollection);
    }

    public void addArchivedFileSet(File archiveFile, String prefix, String[] includes, String[] excludes) throws ArchiverException {
        DefaultArchivedFileSet fileSet = new DefaultArchivedFileSet();
        fileSet.setArchive(archiveFile);
        fileSet.setPrefix(prefix);
        fileSet.setIncludes(includes);
        fileSet.setExcludes(excludes);
        fileSet.setIncludingEmptyDirectories(this.includeEmptyDirs);
        this.addArchivedFileSet(fileSet);
    }

    public void addArchivedFileSet(File archiveFile, String prefix) throws ArchiverException {
        this.addArchivedFileSet(archiveFile, prefix, null, null);
    }

    public void addArchivedFileSet(File archiveFile, String[] includes, String[] excludes) throws ArchiverException {
        this.addArchivedFileSet(archiveFile, null, includes, excludes);
    }

    public void addArchivedFileSet(File archiveFile) throws ArchiverException {
        this.addArchivedFileSet(archiveFile, null, null, null);
    }

    public void contextualize(Context context) throws ContextException {
        PlexusContainer container = (PlexusContainer)context.get((Object)"plexus");
        try {
            this.archiverManager = (ArchiverManager)container.lookup(ArchiverManager.ROLE);
        }
        catch (ComponentLookupException e) {
            throw new ContextException("Error retrieving ArchiverManager instance: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean isForced() {
        return this.forced;
    }

    public void setForced(boolean forced) {
        this.forced = forced;
    }

    public void setArchiveFilters(List filters) {
        this.filterSupport = new FilterSupport(filters, this.getLogger());
    }

    public void addArchiveFinalizer(ArchiveFinalizer finalizer) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList();
        }
        this.finalizers.add(finalizer);
    }

    public void setArchiveFinalizers(List archiveFinalizers) {
        this.finalizers = archiveFinalizers;
    }

    public void setDotFileDirectory(File dotFileDirectory) {
        this.dotFileDirectory = dotFileDirectory;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isUptodate() throws ArchiverException {
        File zipFile = this.getDestFile();
        long destTimestamp = zipFile.lastModified();
        if (destTimestamp == 0L) {
            this.getLogger().debug("isUp2date: false (Destination " + zipFile.getPath() + " not found.)");
            return false;
        }
        Iterator it = this.resources.iterator();
        if (!it.hasNext()) {
            this.getLogger().debug("isUp2date: false (No input files.)");
            return false;
        }
        while (it.hasNext()) {
            void var6_5;
            long l;
            Object o = it.next();
            if (o instanceof ArchiveEntry) {
                l = ((ArchiveEntry)o).getResource().getLastModified();
            } else if (o instanceof PlexusIoResourceCollection) {
                try {
                    l = ((PlexusIoResourceCollection)o).getLastModified();
                }
                catch (IOException e) {
                    throw new ArchiverException(e.getMessage(), e);
                }
            } else {
                throw new IllegalStateException("Invalid object type: " + o.getClass().getName());
            }
            if (var6_5 == 0L) {
                this.getLogger().debug("isUp2date: false (Resource with unknown modification date found.)");
                return false;
            }
            if (var6_5 <= destTimestamp) continue;
            this.getLogger().debug("isUp2date: false (Resource with newer modification date found.)");
            return false;
        }
        this.getLogger().debug("isUp2date: true");
        return true;
    }

    protected boolean checkForced() throws ArchiverException {
        if (!this.isForced() && this.isSupportingForced() && this.isUptodate()) {
            this.getLogger().debug("Archive " + this.getDestFile() + " is uptodate.");
            return false;
        }
        return true;
    }

    public boolean isSupportingForced() {
        return false;
    }

    protected List getArchiveFinalizers() {
        return this.finalizers;
    }

    protected void runArchiveFinalizers() throws ArchiverException {
        if (this.finalizers != null) {
            Iterator it = this.finalizers.iterator();
            while (it.hasNext()) {
                ArchiveFinalizer finalizer = (ArchiveFinalizer)it.next();
                finalizer.finalizeArchiveCreation(this);
            }
        }
    }

    private boolean include(InputStream in, String path) throws ArchiveFilterException {
        return this.filterSupport == null || this.filterSupport.include(in, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createArchive() throws ArchiverException, IOException {
        this.validate();
        try {
            try {
                if (this.dotFileDirectory != null) {
                    this.addArchiveFinalizer(new DotDirectiveArchiveFinalizer(this.dotFileDirectory));
                }
                this.runArchiveFinalizers();
                this.execute();
            }
            finally {
                this.close();
            }
        }
        catch (IOException e) {
            String msg = "Problem creating " + this.getArchiveType() + ": " + e.getMessage();
            StringBuffer revertBuffer = new StringBuffer();
            if (!this.revert(revertBuffer)) {
                msg = msg + revertBuffer.toString();
            }
            throw new ArchiverException(msg, e);
        }
        finally {
            this.cleanUp();
        }
    }

    protected boolean hasVirtualFiles() {
        if (this.finalizers != null) {
            Iterator it = this.finalizers.iterator();
            while (it.hasNext()) {
                ArchiveFinalizer finalizer = (ArchiveFinalizer)it.next();
                List virtualFiles = finalizer.getVirtualFiles();
                if (virtualFiles == null || virtualFiles.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean revert(StringBuffer messageBuffer) {
        return true;
    }

    protected void validate() throws ArchiverException, IOException {
    }

    protected abstract String getArchiveType();

    protected abstract void close() throws IOException;

    protected void cleanUp() {
        this.resources.clear();
    }

    protected abstract void execute() throws ArchiverException, IOException;
}

