/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.util.freemarker;

import freemarker.core.TemplateElement;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.util.Enumeration;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;

public final class Templates {
    private static final Logger LOGGER = Logger.getLogger(Templates.class);
    public static final Configuration MAIN_CFG = new Configuration();
    public static final Configuration MOBILE_CFG = new Configuration();

    private Templates() {
    }

    public static boolean hasExpression(Template template, String expression) {
        TemplateElement rootTreeNode = template.getRootTreeNode();
        return Templates.hasExpression(template, expression, rootTreeNode);
    }

    private static boolean hasExpression(Template template, String expression, TemplateElement templateElement) {
        String canonicalForm = templateElement.getCanonicalForm();
        if (canonicalForm.startsWith(expression)) {
            LOGGER.log(Level.TRACE, "Template has expression[nodeName={0}, expression={1}]", templateElement.getNodeName(), expression);
            return true;
        }
        Enumeration children = templateElement.children();
        while (children.hasMoreElements()) {
            TemplateElement nextElement = (TemplateElement)children.nextElement();
            if (!Templates.hasExpression(template, expression, nextElement)) continue;
            return true;
        }
        return false;
    }

    public static Template getTemplate(String templateDirName, String templateName) {
        try {
            try {
                if ("mobile".equals(templateDirName)) {
                    return MOBILE_CFG.getTemplate(templateName);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.ERROR, "Can not load mobile template[templateDirName={0}, templateName={1}]", templateDirName, templateName);
                return null;
            }
            return MAIN_CFG.getTemplate(templateName);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARN, "Gets template[name={0}] failed: [{1}]", templateName, e.getMessage());
            return null;
        }
    }

    static {
        MAIN_CFG.setDefaultEncoding("UTF-8");
        MOBILE_CFG.setDefaultEncoding("UTF-8");
    }
}

