/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.taskqueue.local;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.taskqueue.Task;
import org.b3log.latke.urlfetch.HTTPRequest;
import org.b3log.latke.urlfetch.HTTPResponse;
import org.b3log.latke.urlfetch.URLFetchService;
import org.b3log.latke.urlfetch.URLFetchServiceFactory;

public final class LocalTaskRunner
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(LocalTaskRunner.class);
    private Task task;
    private Integer retryLimit;
    private URLFetchService urlFetchService;

    public LocalTaskRunner(Task task, Integer retryLimit) {
        this.task = task;
        this.retryLimit = retryLimit;
    }

    @Override
    public void run() {
        this.urlFetchService = URLFetchServiceFactory.getURLFetchService();
        HTTPRequest httpRequest = new HTTPRequest();
        try {
            httpRequest.setURL(new URL(Latkes.getServer() + Latkes.getContextPath() + this.task.getURL()));
            httpRequest.setRequestMethod(this.task.getRequestMethod());
            httpRequest.setPayload(this.task.getPayload());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        Integer retry = 0;
        while (retry < this.retryLimit && !this.doUrlFetch(httpRequest)) {
            Integer n = retry;
            Integer n2 = retry = Integer.valueOf(retry + 1);
            try {
                Thread.sleep(new Integer("1000").intValue());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean doUrlFetch(HTTPRequest httpRequest) {
        HTTPResponse httpResponse = null;
        try {
            httpResponse = this.urlFetchService.fetch(httpRequest);
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "The task[{0}] throw exception {1}", this.task.getURL(), e.getMessage());
            return false;
        }
        Integer beginCode = 200;
        Integer endCode = 299;
        if (httpResponse.getResponseCode() >= beginCode && httpResponse.getResponseCode() <= endCode) {
            return true;
        }
        LOGGER.log(Level.INFO, "The task[{0}] not success, the return code is [{1}]", this.task.getURL(), httpResponse.getResponseCode());
        return false;
    }
}

