/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.taskqueue;

import org.b3log.latke.logging.Logger;
import org.b3log.latke.taskqueue.TaskQueueService;

public final class TaskQueueServiceFactory {
    private static final Logger LOGGER = Logger.getLogger(TaskQueueServiceFactory.class);
    private static final TaskQueueService TASK_QUEUE_SERVICE;

    private TaskQueueServiceFactory() {
    }

    public static TaskQueueService getTaskQueueService() {
        return TASK_QUEUE_SERVICE;
    }

    static {
        LOGGER.info("Constructing task queue service....");
        try {
            Class<?> serviceClass = Class.forName("org.b3log.latke.taskqueue.local.LocalTaskQueueService");
            TASK_QUEUE_SERVICE = (TaskQueueService)serviceClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Can not initialize task queue service!", e);
        }
        LOGGER.info("Constructed task queue service");
    }
}

