/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.servlet.handler;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.ioc.LatkeBeanManager;
import org.b3log.latke.ioc.Lifecycle;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HttpControl;
import org.b3log.latke.servlet.advice.AfterRequestProcessAdvice;
import org.b3log.latke.servlet.advice.BeforeRequestProcessAdvice;
import org.b3log.latke.servlet.advice.RequestProcessAdviceException;
import org.b3log.latke.servlet.advice.RequestReturnAdviceException;
import org.b3log.latke.servlet.annotation.After;
import org.b3log.latke.servlet.annotation.Before;
import org.b3log.latke.servlet.handler.Handler;
import org.b3log.latke.servlet.handler.MatchResult;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.servlet.renderer.JSONRenderer;
import org.json.JSONObject;

public class AdviceHandler
implements Handler {
    private static final Logger LOGGER = Logger.getLogger(AdviceHandler.class);

    @Override
    public void handle(HTTPRequestContext context, HttpControl httpControl) throws Exception {
        MatchResult result = (MatchResult)httpControl.data("MATCH_RESULT");
        Map args = (Map)httpControl.data("PREPARE_ARGS");
        Method invokeHolder = result.getProcessorInfo().getInvokeHolder();
        Class<?> processorClass = invokeHolder.getDeclaringClass();
        List<AbstractHTTPResponseRenderer> rendererList = result.getRendererList();
        LatkeBeanManager beanManager = Lifecycle.getBeanManager();
        List<Class<? extends BeforeRequestProcessAdvice>> beforeAdviceClassList = this.getBeforeList(invokeHolder, processorClass);
        try {
            BeforeRequestProcessAdvice binstance = null;
            for (Class<? extends BeforeRequestProcessAdvice> clz : beforeAdviceClassList) {
                binstance = beanManager.getReference(clz);
                binstance.doAdvice(context, args);
            }
        }
        catch (RequestReturnAdviceException re) {
            return;
        }
        catch (RequestProcessAdviceException e) {
            JSONObject exception = e.getJsonObject();
            String msg = exception.optString("msg");
            LOGGER.log(Level.WARN, "Occured an exception before request processing [errMsg={0}]", msg);
            int statusCode = exception.optInt("sc", -1);
            if (-1 != statusCode && 200 != statusCode) {
                HttpServletResponse response = context.getResponse();
                response.sendError(statusCode, msg);
            } else {
                JSONRenderer ret = new JSONRenderer();
                ret.setJSONObject(exception);
                context.setRenderer(ret);
            }
            return;
        }
        for (AbstractHTTPResponseRenderer renderer : rendererList) {
            renderer.preRender(context, args);
        }
        httpControl.nextHandler();
        for (int j = rendererList.size() - 1; j >= 0; --j) {
            rendererList.get(j).postRender(context, httpControl.data("INVOKE_RESULT"));
        }
        List<Class<? extends AfterRequestProcessAdvice>> afterAdviceClassList = this.getAfterList(invokeHolder, processorClass);
        for (Class<? extends AfterRequestProcessAdvice> clz : afterAdviceClassList) {
            AfterRequestProcessAdvice instance = beanManager.getReference(clz);
            instance.doAdvice(context, httpControl.data("INVOKE_RESULT"));
        }
    }

    private List<Class<? extends BeforeRequestProcessAdvice>> getBeforeList(Method invokeHolder, Class<?> processorClass) {
        Class<? extends BeforeRequestProcessAdvice>[] ac;
        ArrayList<Class<? extends BeforeRequestProcessAdvice>> beforeAdviceClassList = new ArrayList<Class<? extends BeforeRequestProcessAdvice>>();
        if (processorClass.isAnnotationPresent(Before.class)) {
            ac = processorClass.getAnnotation(Before.class).adviceClass();
            beforeAdviceClassList.addAll(Arrays.asList(ac));
        }
        if (invokeHolder.isAnnotationPresent(Before.class)) {
            ac = invokeHolder.getAnnotation(Before.class).adviceClass();
            beforeAdviceClassList.addAll(Arrays.asList(ac));
        }
        return beforeAdviceClassList;
    }

    private List<Class<? extends AfterRequestProcessAdvice>> getAfterList(Method invokeHolder, Class<?> processorClass) {
        Class<? extends AfterRequestProcessAdvice>[] ac;
        ArrayList<Class<? extends AfterRequestProcessAdvice>> afterAdviceClassList = new ArrayList<Class<? extends AfterRequestProcessAdvice>>();
        if (invokeHolder.isAnnotationPresent(After.class)) {
            ac = invokeHolder.getAnnotation(After.class).adviceClass();
            afterAdviceClassList.addAll(Arrays.asList(ac));
        }
        if (processorClass.isAnnotationPresent(After.class)) {
            ac = processorClass.getAnnotation(After.class).adviceClass();
            afterAdviceClassList.addAll(Arrays.asList(ac));
        }
        return afterAdviceClassList;
    }
}

