/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.servlet;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang.StringUtils;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.util.AntPathMatcher;

public final class ClassPathResolver {
    private static final Logger LOGGER = Logger.getLogger(ClassPathResolver.class);
    private static final String JAR_URL_SEPARATOR = "!/";
    private static final String FILE_URL_PREFIX = "file:";
    public static final String URL_PROTOCOL_VFS = "vfs";

    private ClassPathResolver() {
    }

    public static Set<URL> getResources(String locationPattern) {
        HashSet<URL> result = new HashSet<URL>();
        String scanRootPath = ClassPathResolver.getRootPath(locationPattern);
        String subPattern = locationPattern.substring(scanRootPath.length());
        Set<URL> rootDirResources = ClassPathResolver.getResourcesFromRoot(scanRootPath);
        for (URL rootDirResource : rootDirResources) {
            LOGGER.log(Level.INFO, "RootDirResource [protocol={0}, path={1}]", rootDirResource.getProtocol(), rootDirResource.getPath());
            if (ClassPathResolver.isJarURL(rootDirResource)) {
                result.addAll(ClassPathResolver.doFindPathMatchingJarResources(rootDirResource, subPattern));
                continue;
            }
            if (rootDirResource.getProtocol().startsWith(URL_PROTOCOL_VFS)) {
                result.addAll(VfsResourceMatchingDelegate.findMatchingResources(rootDirResource, subPattern));
                continue;
            }
            result.addAll(ClassPathResolver.doFindPathMatchingFileResources(rootDirResource, subPattern));
        }
        return result;
    }

    private static String getRootPath(String locationPattern) {
        int rootDirEnd = locationPattern.length();
        while (AntPathMatcher.isPattern(locationPattern.substring(0, rootDirEnd))) {
            rootDirEnd = locationPattern.lastIndexOf(47, rootDirEnd - 2) + 1;
        }
        return locationPattern.substring(0, rootDirEnd);
    }

    private static Set<URL> getResourcesFromRoot(String rootPath) {
        LinkedHashSet<URL> rets = new LinkedHashSet<URL>();
        String path = rootPath;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        try {
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(path);
            URL url = null;
            while (resources.hasMoreElements()) {
                url = resources.nextElement();
                rets.add(url);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.ERROR, "get the ROOT Rescources error", e);
        }
        return rets;
    }

    private static boolean isJarURL(URL rootDirResource) {
        String protocol = rootDirResource.getProtocol();
        return "jar".equals(protocol) || "zip".equals(protocol) || "wsjar".equals(protocol) || "code-source".equals(protocol) && rootDirResource.getPath().contains(JAR_URL_SEPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<? extends URL> doFindPathMatchingJarResources(URL rootDirResource, String subPattern) {
        LinkedHashSet<URL> result = new LinkedHashSet<URL>();
        JarFile jarFile = null;
        String rootEntryPath = null;
        boolean newJarFile = false;
        try {
            String jarFileUrl;
            URLConnection con = rootDirResource.openConnection();
            if (con instanceof JarURLConnection) {
                JarURLConnection jarCon = (JarURLConnection)con;
                jarCon.setUseCaches(false);
                jarFile = jarCon.getJarFile();
                jarFileUrl = jarCon.getJarFileURL().toExternalForm();
                JarEntry jarEntry = jarCon.getJarEntry();
                rootEntryPath = jarEntry != null ? jarEntry.getName() : "";
            } else {
                String urlFile = rootDirResource.getFile();
                int separatorIndex = urlFile.indexOf(JAR_URL_SEPARATOR);
                if (separatorIndex != -1) {
                    jarFileUrl = urlFile.substring(0, separatorIndex);
                    rootEntryPath = urlFile.substring(separatorIndex + JAR_URL_SEPARATOR.length());
                    jarFile = ClassPathResolver.getJarFile(jarFileUrl);
                } else {
                    jarFile = new JarFile(urlFile);
                    jarFileUrl = urlFile;
                    rootEntryPath = "";
                }
                newJarFile = true;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.ERROR, "reslove jar File error", e);
            return result;
        }
        try {
            if (!"".equals(rootEntryPath) && !rootEntryPath.endsWith("/")) {
                rootEntryPath = rootEntryPath + "/";
            }
            Object entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryPath = entry.getName();
                String relativePath = null;
                if (!entryPath.startsWith(rootEntryPath) || !AntPathMatcher.match(subPattern, relativePath = entryPath.substring(rootEntryPath.length()))) continue;
                if (relativePath.startsWith("/")) {
                    relativePath = relativePath.substring(1);
                }
                result.add(new URL(rootDirResource, relativePath));
            }
            entries = result;
            return entries;
        }
        catch (IOException e) {
            LOGGER.log(Level.ERROR, "parse the JarFile error", e);
        }
        finally {
            if (newJarFile) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARN, " occur error when closing jarFile", e);
                }
            }
        }
        return result;
    }

    private static JarFile getJarFile(String jarFileUrl) throws IOException {
        if (jarFileUrl.startsWith(FILE_URL_PREFIX)) {
            try {
                return new JarFile(ClassPathResolver.toURI(jarFileUrl).getSchemeSpecificPart());
            }
            catch (URISyntaxException ex) {
                return new JarFile(jarFileUrl.substring(FILE_URL_PREFIX.length()));
            }
        }
        return new JarFile(jarFileUrl);
    }

    private static Collection<? extends URL> doFindPathMatchingFileResources(URL rootDirResource, String subPattern) {
        File rootFile = null;
        LinkedHashSet<URL> rets = new LinkedHashSet<URL>();
        try {
            rootFile = new File(rootDirResource.toURI());
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.ERROR, "cat not resolve the rootFile", e);
            throw new RuntimeException("cat not resolve the rootFile", e);
        }
        String fullPattern = StringUtils.replace((String)rootFile.getAbsolutePath(), (String)File.separator, (String)"/");
        if (!subPattern.startsWith("/")) {
            fullPattern = fullPattern + "/";
        }
        final String filePattern = fullPattern + StringUtils.replace((String)subPattern, (String)File.separator, (String)"/");
        Collection files = FileUtils.listFiles((File)rootFile, (IOFileFilter)new IOFileFilter(){

            public boolean accept(File dir, String name) {
                return true;
            }

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return false;
                }
                return AntPathMatcher.match(filePattern, StringUtils.replace((String)file.getAbsolutePath(), (String)File.separator, (String)"/"));
            }
        }, (IOFileFilter)TrueFileFilter.INSTANCE);
        try {
            for (File file : files) {
                rets.add(file.toURI().toURL());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "convert file to URL error", e);
            throw new RuntimeException("convert file to URL error", e);
        }
        return rets;
    }

    private static URI toURI(String location) throws URISyntaxException {
        return new URI(StringUtils.replace((String)location, (String)" ", (String)"%20"));
    }

    private static class PatternVirtualFileVisitor {
        private final String subPattern;
        private final String rootPath;
        private final Set<URL> resources = new LinkedHashSet<URL>();

        PatternVirtualFileVisitor(String rootPath, String subPattern) {
            this.subPattern = subPattern;
            this.rootPath = rootPath.length() == 0 || rootPath.endsWith("/") ? rootPath : rootPath + "/";
        }

        public Set<URL> getResources() {
            return this.resources;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("sub-pattern: ").append(this.subPattern);
            sb.append(", resources: ").append(this.resources);
            return sb.toString();
        }
    }

    private static final class VfsResourceMatchingDelegate {
        private VfsResourceMatchingDelegate() {
        }

        public static Set<URL> findMatchingResources(URL rootUrl, String locationPattern) {
            throw new UnsupportedOperationException("JBoss VFS not supported yet!");
        }
    }
}

