/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository.jdbc;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.b3log.latke.Keys;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.CompositeFilter;
import org.b3log.latke.repository.DBKeyGenerator;
import org.b3log.latke.repository.Filter;
import org.b3log.latke.repository.FilterOperator;
import org.b3log.latke.repository.KeyGenerator;
import org.b3log.latke.repository.Projection;
import org.b3log.latke.repository.PropertyFilter;
import org.b3log.latke.repository.Query;
import org.b3log.latke.repository.Repository;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.repository.SortDirection;
import org.b3log.latke.repository.TimeMillisKeyGenerator;
import org.b3log.latke.repository.Transaction;
import org.b3log.latke.repository.jdbc.JDBCRepositoryException;
import org.b3log.latke.repository.jdbc.JdbcFactory;
import org.b3log.latke.repository.jdbc.JdbcTransaction;
import org.b3log.latke.repository.jdbc.util.Connections;
import org.b3log.latke.repository.jdbc.util.JdbcRepositories;
import org.b3log.latke.repository.jdbc.util.JdbcUtil;
import org.b3log.latke.util.CollectionUtils;
import org.b3log.latke.util.Strings;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class JdbcRepository
implements Repository {
    public static final String REPOSITORY_CACHE_NAME = "repositoryCache";
    public static final ThreadLocal<JdbcTransaction> TX = new InheritableThreadLocal<JdbcTransaction>();
    public static final ThreadLocal<Connection> CONN = new ThreadLocal();
    private static final Logger LOGGER = Logger.getLogger(JdbcRepository.class);
    private static final KeyGenerator<?> KEY_GEN;
    private final String name;
    private boolean writable = true;

    public JdbcRepository(String name) {
        this.name = name;
    }

    public static void dispose() {
        Connection connection;
        JdbcTransaction jdbcTransaction = TX.get();
        if (null != jdbcTransaction && jdbcTransaction.getConnection() != null) {
            jdbcTransaction.dispose();
        }
        if (null != (connection = CONN.get())) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                throw new RuntimeException("Close connection failed", e);
            }
            finally {
                CONN.set(null);
            }
        }
    }

    @Override
    public String add(JSONObject jsonObject) throws RepositoryException {
        JdbcTransaction currentTransaction = TX.get();
        if (null == currentTransaction) {
            throw new RepositoryException("Invoking add() outside a transaction");
        }
        Connection connection = this.getConnection();
        ArrayList<Object> paramList = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        String id = null;
        try {
            id = this.buildAddSql(jsonObject, paramList, sql);
            JdbcUtil.executeSql(sql.toString(), paramList, connection);
        }
        catch (SQLException se) {
            LOGGER.log(Level.ERROR, "add:" + se.getMessage(), se);
            throw new JDBCRepositoryException(se);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "add:" + e.getMessage(), e);
            throw new RepositoryException(e);
        }
        return id;
    }

    private String buildAddSql(JSONObject jsonObject, List<Object> paramlist, StringBuilder sql) throws Exception {
        String ret = null;
        if (!jsonObject.has(Keys.OBJECT_ID)) {
            if (!(KEY_GEN instanceof DBKeyGenerator)) {
                ret = (String)KEY_GEN.gen();
                jsonObject.put(Keys.OBJECT_ID, ret);
            }
        } else {
            ret = jsonObject.getString(Keys.OBJECT_ID);
        }
        this.setProperties(jsonObject, paramlist, sql);
        return ret;
    }

    private void setProperties(JSONObject jsonObject, List<Object> paramlist, StringBuilder sql) throws Exception {
        Iterator keys = jsonObject.keys();
        StringBuilder insertString = new StringBuilder();
        StringBuilder wildcardString = new StringBuilder();
        boolean isFirst = true;
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (isFirst) {
                insertString.append("(").append(key);
                wildcardString.append("(?");
                isFirst = false;
            } else {
                insertString.append(",").append(key);
                wildcardString.append(",?");
            }
            Object value = jsonObject.get(key);
            paramlist.add(value);
            if (keys.hasNext()) continue;
            insertString.append(")");
            wildcardString.append(")");
        }
        sql.append("insert into ").append(this.getName()).append((CharSequence)insertString).append(" values ").append((CharSequence)wildcardString);
    }

    @Override
    public void update(String id, JSONObject jsonObject) throws RepositoryException {
        if (Strings.isEmptyOrNull(id)) {
            return;
        }
        JdbcTransaction currentTransaction = TX.get();
        if (null == currentTransaction) {
            throw new RepositoryException("Invoking update() outside a transaction");
        }
        JSONObject oldJsonObject = this.get(id);
        Connection connection = this.getConnection();
        ArrayList<Object> paramList = new ArrayList<Object>();
        StringBuilder sqlBuilder = new StringBuilder();
        try {
            this.update(id, oldJsonObject, jsonObject, paramList, sqlBuilder);
            String sql = sqlBuilder.toString();
            if (Strings.isEmptyOrNull(sql)) {
                return;
            }
            JdbcUtil.executeSql(sql, paramList, connection);
        }
        catch (SQLException se) {
            LOGGER.log(Level.ERROR, "update:" + se.getMessage(), se);
            throw new JDBCRepositoryException(se);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "update:" + e.getMessage(), e);
            throw new RepositoryException(e);
        }
    }

    private void update(String id, JSONObject oldJsonObject, JSONObject jsonObject, List<Object> paramList, StringBuilder sql) throws JSONException {
        JSONObject needUpdateJsonObject = this.getNeedUpdateJsonObject(oldJsonObject, jsonObject);
        if (needUpdateJsonObject.length() == 0) {
            LOGGER.log(Level.INFO, "nothing to update [{0}] for repository [{1}]", id, this.getName());
            return;
        }
        this.setUpdateProperties(id, needUpdateJsonObject, paramList, sql);
    }

    private void setUpdateProperties(String id, JSONObject needUpdateJsonObject, List<Object> paramList, StringBuilder sql) throws JSONException {
        Iterator keys = needUpdateJsonObject.keys();
        boolean isFirst = true;
        StringBuilder wildcardString = new StringBuilder();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (isFirst) {
                wildcardString.append(" set ").append(key).append("=?");
                isFirst = false;
            } else {
                wildcardString.append(",").append(key).append("=?");
            }
            paramList.add(needUpdateJsonObject.get(key));
        }
        sql.append("update ").append(this.getName()).append((CharSequence)wildcardString).append(" where ").append(JdbcRepositories.getDefaultKeyName()).append("=").append("?");
        paramList.add(id);
    }

    private JSONObject getNeedUpdateJsonObject(JSONObject oldJsonObject, JSONObject jsonObject) throws JSONException {
        if (null == oldJsonObject) {
            return jsonObject;
        }
        JSONObject needUpdateJsonObject = new JSONObject();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (jsonObject.get(key) == null && oldJsonObject.get(key) == null) {
                needUpdateJsonObject.put(key, jsonObject.get(key));
                continue;
            }
            if (jsonObject.optString(key).equals(oldJsonObject.optString(key))) continue;
            needUpdateJsonObject.put(key, jsonObject.get(key));
        }
        return needUpdateJsonObject;
    }

    @Override
    public void remove(String id) throws RepositoryException {
        if (Strings.isEmptyOrNull(id)) {
            return;
        }
        JdbcTransaction currentTransaction = TX.get();
        if (null == currentTransaction) {
            throw new RepositoryException("Invoking remove() outside a transaction");
        }
        StringBuilder sql = new StringBuilder();
        Connection connection = this.getConnection();
        try {
            this.remove(id, sql);
            JdbcUtil.executeSql(sql.toString(), connection);
        }
        catch (SQLException se) {
            LOGGER.log(Level.ERROR, "remove:" + se.getMessage(), se);
            throw new JDBCRepositoryException(se);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "remove:" + e.getMessage(), e);
            throw new RepositoryException(e);
        }
    }

    private void remove(String id, StringBuilder sql) {
        sql.append("delete from ").append(this.getName()).append(" where ").append(JdbcRepositories.getDefaultKeyName()).append("='").append(id).append("'");
    }

    @Override
    public JSONObject get(String id) throws RepositoryException {
        JSONObject ret = null;
        StringBuilder sql = new StringBuilder();
        Connection connection = this.getConnection();
        try {
            this.get(sql);
            ArrayList<Object> paramList = new ArrayList<Object>();
            paramList.add(id);
            ret = JdbcUtil.queryJsonObject(sql.toString(), paramList, connection, this.getName());
        }
        catch (SQLException e) {
            throw new JDBCRepositoryException(e);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "get:" + e.getMessage(), e);
            throw new RepositoryException(e);
        }
        return ret;
    }

    private void get(StringBuilder sql) {
        sql.append("select * from ").append(this.getName()).append(" where ").append(JdbcRepositories.getDefaultKeyName()).append("=").append("?");
    }

    @Override
    public Map<String, JSONObject> get(Iterable<String> ids) throws RepositoryException {
        HashMap<String, JSONObject> map = new HashMap<String, JSONObject>();
        for (String id : ids) {
            JSONObject jsonObject = this.get(id);
            map.put(jsonObject.optString(JdbcRepositories.getDefaultKeyName()), jsonObject);
        }
        return map;
    }

    @Override
    public boolean has(String id) throws RepositoryException {
        return null != this.get(id);
    }

    @Override
    public JSONObject get(Query query) throws RepositoryException {
        JSONObject ret = new JSONObject();
        int currentPageNum = query.getCurrentPageNum();
        int pageSize = query.getPageSize();
        int pageCount = -1;
        if (null != query.getPageCount()) {
            pageCount = query.getPageCount();
        }
        StringBuilder sql = new StringBuilder();
        Connection connection = this.getConnection();
        ArrayList<Object> paramList = new ArrayList<Object>();
        try {
            Map<String, Object> paginationCnt = this.get(currentPageNum, pageSize, pageCount, query, sql, paramList);
            JSONObject pagination = new JSONObject();
            int pageCnt = (Integer)paginationCnt.get("paginationPageCount");
            pagination.put("paginationPageCount", pageCnt);
            pagination.put("paginationRecordCount", paginationCnt.get("paginationRecordCount"));
            ret.put("pagination", pagination);
            if (0 == pageCnt) {
                ret.put("rslts", new JSONArray());
                return ret;
            }
            JSONArray jsonResults = JdbcUtil.queryJsonArray(sql.toString(), paramList, connection, this.getName());
            ret.put("rslts", jsonResults);
        }
        catch (SQLException e) {
            throw new JDBCRepositoryException(e);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "query: " + e.getMessage(), e);
            throw new RepositoryException(e);
        }
        return ret;
    }

    @Override
    public List<JSONObject> select(String statement, Object ... params) throws RepositoryException {
        Connection connection = this.getConnection();
        try {
            JSONArray jsonResults = null == params || 0 == params.length ? JdbcUtil.queryJsonArray(statement, Collections.emptyList(), connection, this.getName()) : JdbcUtil.queryJsonArray(statement, Arrays.asList(params), connection, this.getName());
            return CollectionUtils.jsonArrayToList(jsonResults);
        }
        catch (SQLException e) {
            throw new JDBCRepositoryException(e);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "query: " + e.getMessage(), e);
            throw new RepositoryException(e);
        }
    }

    private Map<String, Object> get(int currentPageNum, int pageSize, int pageCount, Query query, StringBuilder sql, List<Object> paramList) throws RepositoryException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        int pageCnt = pageCount;
        int recordCnt = 0;
        StringBuilder selectSql = new StringBuilder();
        StringBuilder filterSql = new StringBuilder();
        StringBuilder orderBySql = new StringBuilder();
        this.getSelectSql(selectSql, query.getProjections());
        this.getFilterSql(filterSql, paramList, query.getFilter());
        this.getOrderBySql(orderBySql, query.getSorts());
        if (-1 == pageCount) {
            StringBuilder countSql = new StringBuilder("select count(" + JdbcRepositories.getDefaultKeyName() + ") from ").append(this.getName());
            if (StringUtils.isNotBlank((String)filterSql.toString())) {
                countSql.append(" where ").append((CharSequence)filterSql);
            }
            if (0 == (recordCnt = (int)this.count(countSql, paramList))) {
                ret.put("paginationPageCount", 0);
                ret.put("paginationRecordCount", 0);
                return ret;
            }
            pageCnt = (int)Math.ceil((double)recordCnt / (double)pageSize);
        }
        ret.put("paginationPageCount", pageCnt);
        ret.put("paginationRecordCount", recordCnt);
        this.getQuerySql(currentPageNum, pageSize, selectSql, filterSql, orderBySql, sql);
        return ret;
    }

    private void getSelectSql(StringBuilder selectSql, Set<Projection> projections) {
        selectSql.append(" select ");
        if (projections == null || projections.isEmpty()) {
            selectSql.append(" * ");
            return;
        }
        this.concatProjections(projections, selectSql);
    }

    private void concatProjections(Set<Projection> projections, StringBuilder selectSql) {
        for (Projection projection : projections) {
            selectSql.append(projection.getKey()).append(",");
        }
        this.deleteLastChar(selectSql);
    }

    private void deleteLastChar(StringBuilder selectSql) {
        selectSql.setLength(Math.max(selectSql.length() - 1, 0));
    }

    private void getQuerySql(int currentPageNum, int pageSize, StringBuilder selectSql, StringBuilder filterSql, StringBuilder orderBySql, StringBuilder sql) {
        int start = (currentPageNum - 1) * pageSize;
        int end = start + pageSize;
        sql.append(JdbcFactory.createJdbcFactory().queryPage(start, end, selectSql.toString(), filterSql.toString(), orderBySql.toString(), this.getName()));
    }

    private void getFilterSql(StringBuilder filterSql, List<Object> paramList, Filter filter) throws RepositoryException {
        if (null == filter) {
            return;
        }
        if (filter instanceof PropertyFilter) {
            this.processPropertyFilter(filterSql, paramList, (PropertyFilter)filter);
        } else {
            this.processCompositeFilter(filterSql, paramList, (CompositeFilter)filter);
        }
    }

    private void getOrderBySql(StringBuilder orderBySql, Map<String, SortDirection> sorts) {
        boolean isFirst = true;
        for (Map.Entry<String, SortDirection> sort : sorts.entrySet()) {
            if (isFirst) {
                orderBySql.append(" order by ");
                isFirst = false;
            } else {
                orderBySql.append(",");
            }
            String querySortDirection = sort.getValue().equals((Object)SortDirection.ASCENDING) ? "asc" : "desc";
            orderBySql.append(sort.getKey()).append(" ").append(querySortDirection);
        }
    }

    @Override
    public List<JSONObject> getRandomly(int fetchSize) throws RepositoryException {
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        StringBuilder sql = new StringBuilder();
        Connection connection = this.getConnection();
        this.getRandomly(fetchSize, sql);
        try {
            JSONArray jsonArray = JdbcUtil.queryJsonArray(sql.toString(), new ArrayList<Object>(), connection, this.getName());
            for (int i = 0; i < jsonArray.length(); ++i) {
                jsonObjects.add(jsonArray.getJSONObject(i));
            }
        }
        catch (SQLException se) {
            LOGGER.log(Level.ERROR, "getRandomly:" + se.getMessage(), se);
            throw new JDBCRepositoryException(se);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "getRandomly:" + e.getMessage(), e);
            throw new RepositoryException(e);
        }
        return jsonObjects;
    }

    private void getRandomly(int fetchSize, StringBuilder sql) {
        sql.append(JdbcFactory.createJdbcFactory().getRandomlySql(this.getName(), fetchSize));
    }

    @Override
    public long count() throws RepositoryException {
        StringBuilder sql = new StringBuilder("select count(" + JdbcRepositories.getDefaultKeyName() + ") from ").append(this.getName());
        return this.count(sql, new ArrayList<Object>());
    }

    @Override
    public long count(Query query) throws RepositoryException {
        StringBuilder countSql = new StringBuilder("select count(" + JdbcRepositories.getDefaultKeyName() + ") from ").append(this.getName());
        ArrayList<Object> paramList = new ArrayList<Object>();
        StringBuilder filterSql = new StringBuilder();
        this.getFilterSql(filterSql, paramList, query.getFilter());
        if (StringUtils.isNotBlank((String)filterSql.toString())) {
            countSql.append(" where ").append((CharSequence)filterSql);
        }
        return (int)this.count(countSql, paramList);
    }

    private long count(StringBuilder sql, List<Object> paramList) throws RepositoryException {
        long count;
        Connection connection = this.getConnection();
        try {
            JSONObject jsonObject = JdbcUtil.queryJsonObject(sql.toString(), paramList, connection, this.getName());
            count = jsonObject.getLong(jsonObject.keys().next().toString());
        }
        catch (SQLException se) {
            LOGGER.log(Level.ERROR, "count:" + se.getMessage(), se);
            throw new JDBCRepositoryException(se);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "count :" + e.getMessage(), e);
            throw new RepositoryException(e);
        }
        return count;
    }

    @Override
    public String getName() {
        String tableNamePrefix = StringUtils.isNotBlank((String)Latkes.getLocalProperty("jdbc.tablePrefix")) ? Latkes.getLocalProperty("jdbc.tablePrefix") + "_" : "";
        return tableNamePrefix + this.name;
    }

    @Override
    public Transaction beginTransaction() {
        JdbcTransaction ret = TX.get();
        if (null != ret) {
            LOGGER.log(Level.DEBUG, "There is a transaction[isActive={0}] in current thread", ret.isActive());
            if (ret.isActive()) {
                return TX.get();
            }
        }
        try {
            ret = new JdbcTransaction();
        }
        catch (SQLException e) {
            LOGGER.log(Level.ERROR, "Failed to initialize JDBC transaction", e);
            throw new IllegalStateException("Begin a transaction failed");
        }
        TX.set(ret);
        return ret;
    }

    @Override
    public boolean hasTransactionBegun() {
        return null != TX.get();
    }

    @Override
    public boolean isWritable() {
        return this.writable;
    }

    @Override
    public void setWritable(boolean writable) {
        this.writable = writable;
    }

    private Connection getConnection() {
        JdbcTransaction jdbcTransaction = TX.get();
        if (null != jdbcTransaction && jdbcTransaction.isActive()) {
            return jdbcTransaction.getConnection();
        }
        Connection ret = CONN.get();
        try {
            if (null != ret && !ret.isClosed()) {
                return ret;
            }
            ret = Connections.getConnection();
            CONN.set(ret);
        }
        catch (SQLException e) {
            LOGGER.log(Level.ERROR, "Gets connection failed", e);
        }
        return ret;
    }

    private void processPropertyFilter(StringBuilder filterSql, List<Object> paramList, PropertyFilter propertyFilter) throws RepositoryException {
        String filterOperator;
        switch (propertyFilter.getOperator()) {
            case EQUAL: {
                filterOperator = "=";
                break;
            }
            case GREATER_THAN: {
                filterOperator = ">";
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                filterOperator = ">=";
                break;
            }
            case LESS_THAN: {
                filterOperator = "<";
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                filterOperator = "<=";
                break;
            }
            case NOT_EQUAL: {
                filterOperator = "!=";
                break;
            }
            case IN: {
                filterOperator = "in";
                break;
            }
            case LIKE: {
                filterOperator = " like ";
                break;
            }
            case NOT_LIKE: {
                filterOperator = " not like ";
                break;
            }
            default: {
                throw new RepositoryException("Unsupported filter operator [" + (Object)((Object)propertyFilter.getOperator()) + "]");
            }
        }
        if (FilterOperator.IN != propertyFilter.getOperator()) {
            filterSql.append(propertyFilter.getKey()).append(filterOperator).append("?");
            paramList.add(propertyFilter.getValue());
        } else {
            Collection objects = (Collection)propertyFilter.getValue();
            boolean isSubFist = true;
            if (objects != null && !objects.isEmpty()) {
                filterSql.append(propertyFilter.getKey()).append(" in ");
                Iterator obs = objects.iterator();
                while (obs.hasNext()) {
                    if (isSubFist) {
                        filterSql.append("(");
                        isSubFist = false;
                    } else {
                        filterSql.append(",");
                    }
                    filterSql.append("?");
                    paramList.add(obs.next());
                    if (obs.hasNext()) continue;
                    filterSql.append(") ");
                }
            } else {
                filterSql.append("1!=1");
            }
        }
    }

    private void processCompositeFilter(StringBuilder filterSql, List<Object> paramList, CompositeFilter compositeFilter) throws RepositoryException {
        List<Filter> subFilters = compositeFilter.getSubFilters();
        if (2 > subFilters.size()) {
            throw new RepositoryException("At least two sub filters in a composite filter");
        }
        filterSql.append("(");
        Iterator<Filter> iterator = subFilters.iterator();
        block4: while (iterator.hasNext()) {
            Filter filter = iterator.next();
            if (filter instanceof PropertyFilter) {
                this.processPropertyFilter(filterSql, paramList, (PropertyFilter)filter);
            } else {
                this.processCompositeFilter(filterSql, paramList, (CompositeFilter)filter);
            }
            if (!iterator.hasNext()) continue;
            switch (compositeFilter.getOperator()) {
                case AND: {
                    filterSql.append(" and ");
                    continue block4;
                }
                case OR: {
                    filterSql.append(" or ");
                    continue block4;
                }
            }
            throw new RepositoryException("Unsupported composite filter [operator=" + (Object)((Object)compositeFilter.getOperator()) + "]");
        }
        filterSql.append(")");
    }

    static {
        String value = Latkes.getLocalProperty("keyGen");
        if (Strings.isEmptyOrNull(value) || "org.b3log.latke.repository.TimeMillisKeyGenerator".equals(value)) {
            KEY_GEN = new TimeMillisKeyGenerator();
        } else if ("DB".equals(value)) {
            KEY_GEN = new DBKeyGenerator();
        } else {
            try {
                Class<?> keyGenClass = Class.forName(value);
                Constructor<?> constructor = keyGenClass.getConstructor(new Class[0]);
                KEY_GEN = (KeyGenerator)constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can not load key generator with the specified class name [" + value + ']', e);
            }
        }
    }
}

