/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.b3log.latke.Latkes;
import org.b3log.latke.event.AbstractEventListener;
import org.b3log.latke.event.Event;
import org.b3log.latke.event.EventException;
import org.b3log.latke.event.EventManager;
import org.b3log.latke.ioc.inject.Inject;
import org.b3log.latke.ioc.inject.Named;
import org.b3log.latke.ioc.inject.Singleton;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.plugin.AbstractPlugin;
import org.b3log.latke.plugin.NotInteractivePlugin;
import org.b3log.latke.plugin.PluginType;
import org.b3log.latke.servlet.AbstractServletListener;
import org.b3log.latke.util.Stopwatchs;
import org.b3log.latke.util.Strings;
import org.json.JSONException;
import org.json.JSONObject;

@Named(value="LatkeBuiltInPluginManager")
@Singleton
public class PluginManager {
    private static final Logger LOGGER = Logger.getLogger(PluginManager.class);
    public static final String PLUGIN_LOADED_EVENT = "pluginLoadedEvt";
    private Map<String, HashSet<AbstractPlugin>> pluginCache = new HashMap<String, HashSet<AbstractPlugin>>();
    private Set<ClassLoader> classLoaders = new HashSet<ClassLoader>();
    @Inject
    private EventManager eventManager;

    public List<AbstractPlugin> getPlugins() {
        if (this.pluginCache.isEmpty()) {
            LOGGER.info("Plugin cache miss, reload");
            this.load();
        }
        ArrayList<AbstractPlugin> ret = new ArrayList<AbstractPlugin>();
        for (Map.Entry<String, HashSet<AbstractPlugin>> entry : this.pluginCache.entrySet()) {
            ret.addAll((Collection<AbstractPlugin>)entry.getValue());
        }
        return ret;
    }

    public Set<AbstractPlugin> getPlugins(String viewName) {
        Set ret;
        if (this.pluginCache.isEmpty()) {
            LOGGER.info("Plugin cache miss, reload");
            this.load();
        }
        if (null == (ret = (Set)this.pluginCache.get(viewName))) {
            return Collections.emptySet();
        }
        return ret;
    }

    public void load() {
        Stopwatchs.start("Load Plugins");
        this.classLoaders.clear();
        ServletContext servletContext = AbstractServletListener.getServletContext();
        Set pluginDirPaths = servletContext.getResourcePaths("/plugins");
        ArrayList<AbstractPlugin> plugins = new ArrayList<AbstractPlugin>();
        if (null != pluginDirPaths) {
            for (String pluginDirPath : pluginDirPaths) {
                try {
                    LOGGER.log(Level.INFO, "Loading plugin under directory[{0}]", pluginDirPath);
                    AbstractPlugin plugin = this.load(pluginDirPath, this.pluginCache);
                    if (plugin == null) continue;
                    plugins.add(plugin);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARN, "Load plugin under directory[" + pluginDirPath + "] failed", e);
                }
            }
        }
        try {
            this.eventManager.fireEventSynchronously(new Event(PLUGIN_LOADED_EVENT, plugins));
        }
        catch (EventException e) {
            throw new RuntimeException("Plugin load error", e);
        }
        Stopwatchs.end();
    }

    private AbstractPlugin load(String pluginDirPath, Map<String, HashSet<AbstractPlugin>> holder) throws Exception {
        String rendererId;
        Properties props = new Properties();
        ServletContext servletContext = AbstractServletListener.getServletContext();
        String plugin = StringUtils.substringAfter((String)pluginDirPath, (String)"/plugins");
        plugin = plugin.replace("/", "");
        File file = Latkes.getWebFile("/plugins/" + plugin + "/plugin.properties");
        props.load(new FileInputStream(file));
        URL defaultClassesFileDirURL = servletContext.getResource("/plugins/" + plugin + "classes");
        URL classesFileDirURL = null;
        try {
            classesFileDirURL = servletContext.getResource(props.getProperty("classesDirPath"));
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.ERROR, "Reads [" + props.getProperty("classesDirPath") + "] failed", e);
        }
        URLClassLoader classLoader = new URLClassLoader(new URL[]{defaultClassesFileDirURL, classesFileDirURL}, PluginManager.class.getClassLoader());
        this.classLoaders.add(classLoader);
        String pluginClassName = props.getProperty("pluginClass");
        if (StringUtils.isBlank((String)pluginClassName)) {
            pluginClassName = NotInteractivePlugin.class.getName();
        }
        if (StringUtils.isBlank((String)(rendererId = props.getProperty("rendererId")))) {
            LOGGER.log(Level.WARN, "no renderer defined by this plugin[" + plugin + "]\uff0cthis plugin will be ignore!", new Object[0]);
            return null;
        }
        Class<?> pluginClass = classLoader.loadClass(pluginClassName);
        LOGGER.log(Level.TRACE, "Loading plugin class[name={0}]", pluginClassName);
        AbstractPlugin ret = (AbstractPlugin)pluginClass.newInstance();
        ret.setRendererId(rendererId);
        PluginManager.setPluginProps(plugin, ret, props);
        this.registerEventListeners(props, classLoader, ret);
        this.register(ret, holder);
        ret.changeStatus();
        return ret;
    }

    private void register(AbstractPlugin plugin, Map<String, HashSet<AbstractPlugin>> holder) {
        String[] redererIds;
        String rendererId = plugin.getRendererId();
        for (String rid : redererIds = rendererId.split(";")) {
            HashSet set = holder.computeIfAbsent(rid, k -> new HashSet());
            set.add(plugin);
        }
        LOGGER.log(Level.DEBUG, "Registered plugin[name={0}, version={1}] for rendererId[name={2}], [{3}] plugins totally", plugin.getName(), plugin.getVersion(), rendererId, holder.size());
    }

    private static void setPluginProps(String pluginDirName, AbstractPlugin plugin, Properties props) throws Exception {
        String author = props.getProperty("author");
        String name = props.getProperty("name");
        String version = props.getProperty("version");
        String types = props.getProperty("types");
        LOGGER.log(Level.TRACE, "Plugin[name={0}, author={1}, version={2}, types={3}]", name, author, version, types);
        plugin.setAuthor(author);
        plugin.setName(name);
        plugin.setId(name + "_" + version);
        plugin.setVersion(version);
        plugin.setDir(pluginDirName);
        plugin.readLangs();
        File settingFile = Latkes.getWebFile("/plugins/" + pluginDirName + "/config.json");
        if (null != settingFile && settingFile.exists()) {
            try {
                String config = FileUtils.readFileToString((File)settingFile);
                JSONObject jsonObject = new JSONObject(config);
                plugin.setSetting(jsonObject);
            }
            catch (IOException ie) {
                LOGGER.log(Level.ERROR, "reading the config of the plugin[" + name + "]  failed", ie);
            }
            catch (JSONException e) {
                LOGGER.log(Level.ERROR, "convert the  config of the plugin[" + name + "] to json failed", e);
            }
        }
        Arrays.stream(types.split(",")).map(PluginType::valueOf).forEach(plugin::addType);
    }

    private void registerEventListeners(Properties props, URLClassLoader classLoader, AbstractPlugin plugin) throws Exception {
        String[] eventListenerClassArray;
        String eventListenerClasses = props.getProperty("eventListenerClasses");
        for (String eventListenerClassName : eventListenerClassArray = eventListenerClasses.split(",")) {
            if (Strings.isEmptyOrNull(eventListenerClassName)) {
                LOGGER.log(Level.INFO, "No event listener to load for plugin[name={0}]", plugin.getName());
                return;
            }
            LOGGER.log(Level.DEBUG, "Loading event listener[className={0}]", eventListenerClassName);
            Class<?> eventListenerClass = classLoader.loadClass(eventListenerClassName);
            AbstractEventListener eventListener = (AbstractEventListener)eventListenerClass.newInstance();
            plugin.addEventListener(eventListener);
            LOGGER.log(Level.DEBUG, "Registered event listener[class={0}, eventType={1}] for plugin[name={2}]", eventListener.getClass(), eventListener.getEventType(), plugin.getName());
        }
    }

    public Set<ClassLoader> getClassLoaders() {
        return Collections.unmodifiableSet(this.classLoaders);
    }
}

