/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.logging;

import java.text.MessageFormat;
import org.b3log.latke.logging.Level;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public final class Logger {
    private static final String FQCN = Logger.class.getName();
    private org.slf4j.Logger proxy;

    private Logger(String className) {
        this.proxy = LoggerFactory.getLogger((String)className);
    }

    public static Logger getLogger(String className) {
        return new Logger(className);
    }

    public static Logger getLogger(Class<?> clazz) {
        return new Logger(clazz.getName());
    }

    public void error(String msg) {
        if (this.proxy.isErrorEnabled()) {
            if (this.proxy instanceof LocationAwareLogger) {
                ((LocationAwareLogger)this.proxy).log(null, FQCN, 40, msg, null, null);
            } else {
                this.proxy.error(msg);
            }
        }
    }

    public void warn(String msg) {
        if (this.proxy.isWarnEnabled()) {
            if (this.proxy instanceof LocationAwareLogger) {
                ((LocationAwareLogger)this.proxy).log(null, FQCN, 30, msg, null, null);
            } else {
                this.proxy.warn(msg);
            }
        }
    }

    public void info(String msg) {
        if (this.proxy.isInfoEnabled()) {
            if (this.proxy instanceof LocationAwareLogger) {
                ((LocationAwareLogger)this.proxy).log(null, FQCN, 20, msg, null, null);
            } else {
                this.proxy.info(msg);
            }
        }
    }

    public void debug(String msg) {
        if (this.proxy.isDebugEnabled()) {
            if (this.proxy instanceof LocationAwareLogger) {
                ((LocationAwareLogger)this.proxy).log(null, FQCN, 10, msg, null, null);
            } else {
                this.proxy.debug(msg);
            }
        }
    }

    public void trace(String msg) {
        if (this.proxy.isTraceEnabled()) {
            if (this.proxy instanceof LocationAwareLogger) {
                ((LocationAwareLogger)this.proxy).log(null, FQCN, 0, msg, null, null);
            } else {
                this.proxy.trace(msg);
            }
        }
    }

    public void log(Level level, String msg, Throwable throwable) {
        switch (level) {
            case ERROR: {
                if (!this.proxy.isErrorEnabled()) break;
                if (this.proxy instanceof LocationAwareLogger) {
                    ((LocationAwareLogger)this.proxy).log(null, FQCN, 40, msg, null, throwable);
                    break;
                }
                this.proxy.error(msg, throwable);
                break;
            }
            case WARN: {
                if (!this.proxy.isWarnEnabled()) break;
                if (this.proxy instanceof LocationAwareLogger) {
                    ((LocationAwareLogger)this.proxy).log(null, FQCN, 30, msg, null, throwable);
                    break;
                }
                this.proxy.warn(msg, throwable);
                break;
            }
            case INFO: {
                if (!this.proxy.isInfoEnabled()) break;
                if (this.proxy instanceof LocationAwareLogger) {
                    ((LocationAwareLogger)this.proxy).log(null, FQCN, 20, msg, null, throwable);
                    break;
                }
                this.proxy.info(msg, throwable);
                break;
            }
            case DEBUG: {
                if (!this.proxy.isDebugEnabled()) break;
                if (this.proxy instanceof LocationAwareLogger) {
                    ((LocationAwareLogger)this.proxy).log(null, FQCN, 10, msg, null, throwable);
                    break;
                }
                this.proxy.debug(msg, throwable);
                break;
            }
            case TRACE: {
                if (!this.proxy.isTraceEnabled()) break;
                if (this.proxy instanceof LocationAwareLogger) {
                    ((LocationAwareLogger)this.proxy).log(null, FQCN, 0, msg, null, throwable);
                    break;
                }
                this.proxy.trace(msg, throwable);
                break;
            }
            default: {
                throw new IllegalStateException("Logging level [" + (Object)((Object)level) + "] is invalid");
            }
        }
    }

    public void log(Level level, String msg, Object ... args) {
        String message = msg;
        if (null != args && 0 < args.length && (msg.indexOf("{0") >= 0 || msg.indexOf("{1") >= 0 || msg.indexOf("{2") >= 0 || msg.indexOf("{3") >= 0)) {
            message = MessageFormat.format(msg, args);
        }
        switch (level) {
            case ERROR: {
                if (!this.proxy.isErrorEnabled()) break;
                if (this.proxy instanceof LocationAwareLogger) {
                    ((LocationAwareLogger)this.proxy).log(null, FQCN, 40, message, null, null);
                    break;
                }
                this.proxy.error(message);
                break;
            }
            case WARN: {
                if (!this.proxy.isWarnEnabled()) break;
                if (this.proxy instanceof LocationAwareLogger) {
                    ((LocationAwareLogger)this.proxy).log(null, FQCN, 30, message, null, null);
                    break;
                }
                this.proxy.warn(message);
                break;
            }
            case INFO: {
                if (!this.proxy.isInfoEnabled()) break;
                if (this.proxy instanceof LocationAwareLogger) {
                    ((LocationAwareLogger)this.proxy).log(null, FQCN, 20, message, null, null);
                    break;
                }
                this.proxy.info(message);
                break;
            }
            case DEBUG: {
                if (!this.proxy.isDebugEnabled()) break;
                if (this.proxy instanceof LocationAwareLogger) {
                    ((LocationAwareLogger)this.proxy).log(null, FQCN, 10, message, null, null);
                    break;
                }
                this.proxy.debug(message);
                break;
            }
            case TRACE: {
                if (!this.proxy.isTraceEnabled()) break;
                if (this.proxy instanceof LocationAwareLogger) {
                    ((LocationAwareLogger)this.proxy).log(null, FQCN, 0, message, null, null);
                    break;
                }
                this.proxy.trace(message);
                break;
            }
            default: {
                throw new IllegalStateException("Logging level [" + (Object)((Object)level) + "] is invalid");
            }
        }
    }

    public boolean isErrorEnabled() {
        if (this.proxy instanceof LocationAwareLogger) {
            return ((LocationAwareLogger)this.proxy).isErrorEnabled();
        }
        return this.proxy.isErrorEnabled();
    }

    public boolean isWarnEnabled() {
        if (this.proxy instanceof LocationAwareLogger) {
            return ((LocationAwareLogger)this.proxy).isWarnEnabled();
        }
        return this.proxy.isWarnEnabled();
    }

    public boolean isInfoEnabled() {
        if (this.proxy instanceof LocationAwareLogger) {
            return ((LocationAwareLogger)this.proxy).isInfoEnabled();
        }
        return this.proxy.isInfoEnabled();
    }

    public boolean isDebugEnabled() {
        if (this.proxy instanceof LocationAwareLogger) {
            return ((LocationAwareLogger)this.proxy).isDebugEnabled();
        }
        return this.proxy.isDebugEnabled();
    }

    public boolean isTraceEnabled() {
        if (this.proxy instanceof LocationAwareLogger) {
            return ((LocationAwareLogger)this.proxy).isTraceEnabled();
        }
        return this.proxy.isTraceEnabled();
    }

    public boolean isLoggable(Level level) {
        switch (level) {
            case TRACE: {
                return this.isTraceEnabled();
            }
            case DEBUG: {
                return this.isDebugEnabled();
            }
            case INFO: {
                return this.isInfoEnabled();
            }
            case WARN: {
                return this.isWarnEnabled();
            }
            case ERROR: {
                return this.isErrorEnabled();
            }
        }
        throw new IllegalStateException("Logging level [" + (Object)((Object)level) + "] is invalid");
    }
}

